/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.vocab.Namespaces;

public class OntologyIRIShortFormProvider
implements IRIShortFormProvider {
    private static final String OWL_EXTENSION = ".owl";
    private static final String RDF_EXTENSION = ".rdf";
    private static final String XML_EXTENSION = ".xml";
    private static final String OBO_EXTENSION = ".obo";
    private static final String[] EXTENSIONS = new String[]{".owl", ".rdf", ".xml", ".obo"};
    private static final Map<IRI, String> wellKnownShortForms;

    public String getShortForm(OWLOntology ont) {
        if (!ont.isAnonymous()) {
            return this.getShortForm(ont.getOntologyID().getOntologyIRI());
        }
        return ont.getOntologyID().toString();
    }

    @Override
    public String getShortForm(IRI iri) {
        String wellKnownShortForm = this.getWellKnownShortForm(iri);
        if (wellKnownShortForm != null) {
            return wellKnownShortForm;
        }
        URI uri = iri.toURI();
        String path = uri.getPath();
        String shortForm = null;
        if (path != null && path.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(path, "/", false);
            String candidatePathElement = "";
            while (tokenizer.hasMoreTokens()) {
                String tok = tokenizer.nextToken();
                if (!OntologyIRIShortFormProvider.isCandidatePathElement(tok)) continue;
                candidatePathElement = OntologyIRIShortFormProvider.stripExtensionIfPresent(tok);
            }
            shortForm = candidatePathElement;
        } else {
            shortForm = uri.getHost() != null ? iri.toString() : iri.toString();
        }
        return shortForm;
    }

    private String getWellKnownShortForm(IRI iri) {
        String wellKnownShortForm = wellKnownShortForms.get(iri);
        if (wellKnownShortForm != null) {
            return wellKnownShortForm;
        }
        return null;
    }

    private static String stripExtensionIfPresent(String shortForm) {
        String lowerCaseShortForm = shortForm.toLowerCase();
        for (String extension : EXTENSIONS) {
            if (!lowerCaseShortForm.endsWith(extension)) continue;
            return shortForm.substring(0, shortForm.length() - extension.length());
        }
        return shortForm;
    }

    private static boolean isCandidatePathElement(String pathElement) {
        return !pathElement.isEmpty() && !OntologyIRIShortFormProvider.isVersionString(pathElement);
    }

    private static boolean isVersionString(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (OntologyIRIShortFormProvider.isVersionStringChar(ch)) continue;
            return false;
        }
        return true;
    }

    private static boolean isVersionStringChar(char ch) {
        return OntologyIRIShortFormProvider.isDigit(ch) || ch == '.' || ch == 'v';
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    static {
        HashMap<IRI, String> map = new HashMap<IRI, String>();
        for (Namespaces ns : Namespaces.values()) {
            String iriPrefix = ns.getPrefixIRI();
            String iri = iriPrefix.endsWith("#") || iriPrefix.endsWith("/") ? iriPrefix.substring(0, iriPrefix.length() - 1) : iriPrefix;
            map.put(IRI.create(iri), ns.getPrefixName().toLowerCase());
            map.put(IRI.create(iri + "/"), ns.getPrefixName().toLowerCase());
        }
        wellKnownShortForms = Collections.unmodifiableMap(map);
    }
}

