/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import gnu.trove.map.hash.TCustomHashMap;
import gnu.trove.set.hash.TCustomHashSet;
import gnu.trove.strategy.HashingStrategy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.util.CollectionFactory;

public class MultiMap<Key, Value>
implements Serializable {
    private static final long serialVersionUID = 30406L;
    private static final int DEFAULT_INITIAL_CAPACITY = 5;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final Map<Key, Collection<Value>> map;
    private final HashcodeGuardedHashingStrategy<Object> keyHashcodeGuardedHashingStrategy = new HashcodeGuardedHashingStrategy();
    private int size = 0;
    private boolean useSets = true;
    private boolean threadSafe = false;

    public MultiMap() {
        this(false);
    }

    public MultiMap(boolean threadsafe) {
        this.threadSafe = threadsafe;
        this.map = this.threadSafe ? Collections.synchronizedMap(this.createMap()) : this.createMap();
    }

    public MultiMap(boolean threadsafe, boolean usesets) {
        this(threadsafe);
        this.useSets = usesets;
    }

    public boolean put(Key key, Value value) {
        boolean toReturn;
        Collection<Value> set = this.map.get(key);
        if (set == null) {
            set = this.createCollection();
            this.map.put(key, set);
        }
        if (toReturn = set.add(value)) {
            this.size = -1;
        }
        return toReturn;
    }

    protected Collection<Value> createCollection() {
        Collection<Object> toReturn;
        if (this.useSets) {
            Set<Value> set = this.createSet(5, 0.75f);
            toReturn = this.threadSafe ? Collections.synchronizedSet(set) : set;
        } else {
            ArrayList list = new ArrayList();
            toReturn = this.threadSafe ? Collections.synchronizedList(list) : list;
        }
        return toReturn;
    }

    protected Map<Key, Collection<Value>> createMap() {
        return new TCustomHashMap(this.keyHashcodeGuardedHashingStrategy, 17, 0.75f);
    }

    private Set<Value> createSet(int initialCapacity, float loadFactor) {
        return new TCustomHashSet(this.keyHashcodeGuardedHashingStrategy, initialCapacity, loadFactor);
    }

    public void setEntry(Key key, Collection<Value> values) {
        this.map.put(key, values);
        this.size = -1;
    }

    public Collection<Value> get(Key key) {
        Collection<Value> collection = this.map.get(key);
        if (collection != null) {
            return collection;
        }
        return Collections.emptyList();
    }

    public Set<Key> keySet() {
        return this.map.keySet();
    }

    public Set<Value> getAllValues() {
        Set toReturn = CollectionFactory.createSet();
        for (Collection<Value> s : this.map.values()) {
            toReturn.addAll(s);
        }
        return toReturn;
    }

    public boolean remove(Key key) {
        if (this.map.remove(key) != null) {
            this.size = -1;
            return true;
        }
        return false;
    }

    public boolean remove(Key key, Value value) {
        Collection<Value> c = this.map.get(key);
        if (c != null) {
            boolean toReturn = c.remove(value);
            if (!toReturn) {
                return false;
            }
            this.size = -1;
            if (c.isEmpty()) {
                this.map.remove(key);
            }
            return true;
        }
        return false;
    }

    public int size() {
        if (this.size < 0) {
            this.size = this.getAllValues().size();
        }
        return this.size;
    }

    public boolean contains(Key k, Value v) {
        Collection<Value> collection = this.map.get(k);
        if (collection == null) {
            return false;
        }
        return collection.contains(v);
    }

    public boolean containsKey(Key k) {
        return this.map.containsKey(k);
    }

    public boolean containsValue(Value v) {
        for (Collection<Value> c : this.map.values()) {
            if (!c.contains(v)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.map.clear();
        this.size = 0;
    }

    public String toString() {
        return "MultiMap " + this.size() + "\n" + this.map.toString();
    }

    public void putAll(MultiMap<Key, Value> otherMap) {
        for (Key k : otherMap.keySet()) {
            this.putAll(k, otherMap.get(k));
        }
    }

    public void putAll(Key k, Collection<Value> v) {
        Collection<Value> set = this.map.get(k);
        if (set == null) {
            set = this.createCollection();
            this.setEntry(k, set);
        }
        set.addAll(v);
        this.size = -1;
    }

    public boolean isValueSetsEqual() {
        if (this.map.size() < 2) {
            return true;
        }
        ArrayList<Collection<Value>> list = new ArrayList<Collection<Value>>(this.map.values());
        for (int i = 1; i < list.size(); ++i) {
            if (((Collection)list.get(0)).equals(list.get(i))) continue;
            return false;
        }
        return true;
    }

    private static class HashcodeGuardedHashingStrategy<Value>
    implements HashingStrategy<Value> {
        private HashcodeGuardedHashingStrategy() {
        }

        public int computeHashCode(Value object) {
            return object.hashCode();
        }

        public boolean equals(Value o1, Value o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            if (this.computeHashCode(o1) != this.computeHashCode(o2)) {
                return false;
            }
            return o1.equals(o2);
        }
    }
}

