/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Set;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyCharacteristicAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.InferredObjectPropertyAxiomGenerator;

public class InferredObjectPropertyCharacteristicAxiomGenerator
extends InferredObjectPropertyAxiomGenerator<OWLObjectPropertyCharacteristicAxiom> {
    @Override
    protected void addAxioms(OWLObjectProperty entity, OWLReasoner reasoner, OWLDataFactory dataFactory, Set<OWLObjectPropertyCharacteristicAxiom> result) {
        this.addIfEntailed(dataFactory.getOWLFunctionalObjectPropertyAxiom(entity), reasoner, result);
        this.addIfEntailed(dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(entity), reasoner, result);
        this.addIfEntailed(dataFactory.getOWLSymmetricObjectPropertyAxiom(entity), reasoner, result);
        this.addIfEntailed(dataFactory.getOWLAsymmetricObjectPropertyAxiom(entity), reasoner, result);
        this.addTransitiveAxiomIfEntailed(entity, reasoner, dataFactory, result);
        this.addIfEntailed(dataFactory.getOWLReflexiveObjectPropertyAxiom(entity), reasoner, result);
        this.addIfEntailed(dataFactory.getOWLIrreflexiveObjectPropertyAxiom(entity), reasoner, result);
    }

    protected void addTransitiveAxiomIfEntailed(OWLObjectProperty property, OWLReasoner reasoner, OWLDataFactory dataFactory, Set<OWLObjectPropertyCharacteristicAxiom> result) {
        OWLTransitiveObjectPropertyAxiom axiom = dataFactory.getOWLTransitiveObjectPropertyAxiom(property);
        if (reasoner.isEntailmentCheckingSupported(axiom.getAxiomType()) && reasoner.isEntailed(axiom) && !this.triviallyTransitiveCheck(property, reasoner, dataFactory)) {
            result.add(axiom);
        }
    }

    private boolean triviallyTransitiveCheck(OWLObjectProperty property, OWLReasoner reasoner, OWLDataFactory df) {
        OWLObjectSomeValuesFrom chain = df.getOWLObjectSomeValuesFrom(property, df.getOWLObjectSomeValuesFrom(property, df.getOWLThing()));
        return !reasoner.isSatisfiable(chain);
    }

    protected void addIfEntailed(OWLObjectPropertyCharacteristicAxiom axiom, OWLReasoner reasoner, Set<OWLObjectPropertyCharacteristicAxiom> result) {
        if (reasoner.isEntailmentCheckingSupported(axiom.getAxiomType()) && reasoner.isEntailed(axiom)) {
            result.add(axiom);
        }
    }

    @Override
    public String getLabel() {
        return "Object property characteristics";
    }
}

