/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.HasShortForm;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationSubjectVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationSubjectVisitorEx;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.SWRLPredicate;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class IRI
implements OWLAnnotationSubject,
OWLAnnotationValue,
SWRLPredicate,
CharSequence,
OWLPrimitive,
HasShortForm {
    private static final long serialVersionUID = 30406L;
    private static final AtomicLong COUNTER = new AtomicLong(System.nanoTime());
    private static final LoadingCache<String, String> prefixCache = CacheBuilder.newBuilder().concurrencyLevel(8).maximumSize(1024L).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String key) {
            return key;
        }
    });
    private final Optional<String> remainder;
    private final String prefix;
    private int hashCode = 0;
    private int length;

    public URI toURI() {
        return URI.create(this.prefix + (String)this.remainder.or((Object)""));
    }

    public boolean isAbsolute() {
        int colonIndex = this.prefix.indexOf(58);
        if (colonIndex == -1) {
            return false;
        }
        for (int i = 0; i < colonIndex; ++i) {
            char ch = this.prefix.charAt(i);
            if (Character.isLetter(ch) || Character.isDigit(ch) || ch == '.' || ch == '+' || ch == '-') continue;
            return false;
        }
        return true;
    }

    public String getScheme() {
        int colonIndex = this.prefix.indexOf(58);
        if (colonIndex == -1) {
            return null;
        }
        return this.prefix.substring(0, colonIndex);
    }

    @Deprecated
    public String getStart() {
        return this.prefix;
    }

    public String getNamespace() {
        return this.prefix;
    }

    public IRI resolve(String s) {
        URI uri = URI.create(s);
        if (uri.isAbsolute() || uri.isOpaque()) {
            return IRI.create(uri);
        }
        return IRI.create(this.toURI().resolve(uri));
    }

    public boolean isReservedVocabulary() {
        return Namespaces.OWL.inNamespace(this.prefix) || Namespaces.RDF.inNamespace(this.prefix) || Namespaces.RDFS.inNamespace(this.prefix) || Namespaces.XSD.inNamespace(this.prefix);
    }

    public boolean isThing() {
        return this.remainder != null && this.remainder.equals((Object)"Thing") && Namespaces.OWL.inNamespace(this.prefix);
    }

    public boolean isNothing() {
        return this.equals(OWLRDFVocabulary.OWL_NOTHING.getIRI());
    }

    public boolean isPlainLiteral() {
        return ((String)this.remainder.or((Object)"")).equals("PlainLiteral") && Namespaces.RDF.inNamespace(this.prefix);
    }

    @Deprecated
    public String getFragment() {
        return (String)this.remainder.or((Object)"");
    }

    public Optional<String> getRemainder() {
        return this.remainder;
    }

    public String toQuotedString() {
        return '<' + this.prefix + (String)this.remainder.or((Object)"") + '>';
    }

    public static IRI create(String str) {
        if (str == null) {
            throw new NullPointerException("String must not be null");
        }
        int index = XMLUtils.getNCNameSuffixIndex(str);
        if (index < 0) {
            return new IRI(str, null);
        }
        return new IRI(str.substring(0, index), str.substring(index));
    }

    public static IRI create(String prefix, String suffix) {
        if (prefix == null) {
            return IRI.create(suffix);
        }
        if (suffix == null) {
            return IRI.create(prefix);
        }
        int index = XMLUtils.getNCNameSuffixIndex(prefix);
        int test = XMLUtils.getNCNameSuffixIndex(suffix);
        if (index == -1 && test == 0) {
            return new IRI(prefix, suffix);
        }
        return IRI.create(prefix + suffix);
    }

    public static IRI create(File file) {
        if (file == null) {
            throw new NullPointerException("file cannot be null");
        }
        return new IRI(file.toURI());
    }

    public static IRI create(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri cannot be null");
        }
        return new IRI(uri);
    }

    public static IRI create(URL url) throws URISyntaxException {
        if (url == null) {
            throw new NullPointerException("url cannot be null");
        }
        return new IRI(url.toURI());
    }

    public static IRI generateDocumentIRI() {
        return IRI.create("owlapi:ontology" + COUNTER.incrementAndGet());
    }

    private static String cache(String s) {
        try {
            return (String)prefixCache.get((Object)s);
        }
        catch (ExecutionException e) {
            return s;
        }
    }

    protected IRI(String prefix, String fragment) {
        this.prefix = IRI.cache(prefix);
        this.remainder = fragment == null ? Optional.absent() : (fragment.isEmpty() ? Optional.absent() : Optional.fromNullable((Object)fragment));
        this.length = prefix.length() + ((String)this.remainder.or((Object)"")).length();
        this.hashCode = prefix.hashCode() + ((String)this.remainder.or((Object)"")).hashCode();
    }

    protected IRI(String s) {
        this(XMLUtils.getNCNamePrefix(s), XMLUtils.getNCNameSuffix(s));
    }

    protected IRI(URI uri) {
        this(uri.toString());
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (index >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (index < this.prefix.length()) {
            return this.prefix.charAt(index);
        }
        return ((String)this.remainder.get()).charAt(index - this.prefix.length());
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.prefix);
        sb.append((String)this.remainder.or((Object)""));
        return sb.subSequence(start, end);
    }

    public String prefixedBy(String prefix) {
        if (prefix == null) {
            throw new NullPointerException("prefix cannot be null");
        }
        if (this.remainder.isPresent()) {
            return prefix + (String)this.remainder.get();
        }
        return prefix;
    }

    @Override
    public String getShortForm() {
        if (this.remainder.isPresent()) {
            return (String)this.remainder.get();
        }
        int lastSlashIndex = this.prefix.lastIndexOf(47);
        if (lastSlashIndex != -1 && lastSlashIndex != this.prefix.length() - 1) {
            return this.prefix.substring(lastSlashIndex + 1);
        }
        return this.toQuotedString();
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(OWLAnnotationSubjectVisitor visitor) {
        visitor.visit(this);
    }

    public <E> E accept(OWLAnnotationSubjectVisitorEx<E> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Set<OWLClass> getClassesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<OWLEntity> getSignature() {
        return Collections.emptySet();
    }

    @Override
    public boolean containsEntityInSignature(OWLEntity owlEntity) {
        return false;
    }

    @Override
    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        return Collections.emptySet();
    }

    @Override
    public Set<OWLDatatype> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<OWLClassExpression> getNestedClassExpressions() {
        return Collections.emptySet();
    }

    @Override
    public int compareTo(OWLObject o) {
        if (o == this || this.equals(o)) {
            return 0;
        }
        if (!(o instanceof IRI)) {
            return -1;
        }
        IRI other = (IRI)o;
        int diff = this.prefix.compareTo(other.prefix);
        if (diff != 0) {
            return diff;
        }
        return ((String)this.remainder.or((Object)"")).compareTo((String)other.remainder.or((Object)""));
    }

    @Override
    public String toString() {
        if (!this.remainder.isPresent()) {
            return this.prefix;
        }
        return this.prefix + (String)this.remainder.get();
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isTopEntity() {
        return false;
    }

    @Override
    public boolean isBottomEntity() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IRI)) {
            return false;
        }
        IRI other = (IRI)obj;
        return this.remainder.equals(other.remainder) && other.prefix.equals(this.prefix);
    }
}

