/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.semanticweb.owlapi.io.OWLParserFactory;

public class OWLParserFactoryRegistry {
    private static final OWLParserFactoryRegistry instance = new OWLParserFactoryRegistry();
    private final List<OWLParserFactory> parserFactories = new CopyOnWriteArrayList<OWLParserFactory>();

    private OWLParserFactoryRegistry() {
    }

    public static OWLParserFactoryRegistry getInstance() {
        return instance;
    }

    public synchronized void clearParserFactories() {
        this.parserFactories.clear();
    }

    public List<OWLParserFactory> getParserFactories() {
        return Collections.unmodifiableList(this.parserFactories);
    }

    public synchronized void registerParserFactory(OWLParserFactory parserFactory) {
        this.parserFactories.add(0, parserFactory);
    }

    public synchronized void registerParserFactories(OWLParserFactory ... factories) {
        for (OWLParserFactory p : factories) {
            this.parserFactories.add(p);
        }
    }

    public void unregisterParserFactory(OWLParserFactory parserFactory) {
        this.parserFactories.remove(parserFactory);
    }
}

