/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashMap;
import java.util.Map;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.NamespaceUtil;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class QNameShortFormProvider
implements ShortFormProvider {
    private final NamespaceUtil namespaceUtil = new NamespaceUtil();

    public QNameShortFormProvider() {
        this(new HashMap<String, String>());
    }

    public QNameShortFormProvider(Map<String, String> prefix2NamespaceMap) {
        for (Map.Entry<String, String> e : prefix2NamespaceMap.entrySet()) {
            this.namespaceUtil.setPrefix(e.getKey(), e.getValue());
        }
    }

    @Override
    public String getShortForm(OWLEntity entity) {
        String iri = entity.getIRI().toString();
        String namespace = XMLUtils.getNCNamePrefix(iri);
        String localName = XMLUtils.getNCNameSuffix(iri);
        String prefix = this.namespaceUtil.getPrefix(namespace);
        String toReturn = prefix + ":" + (localName != null ? localName : "");
        return toReturn;
    }

    @Override
    public void dispose() {
    }
}

