/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashMap;
import java.util.Map;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.OWLEntityURIConverterStrategy;

public class OWLEntityURIUnderscores2CamelBackConverterStrategy
implements OWLEntityURIConverterStrategy {
    private final Map<IRI, IRI> iriMap = new HashMap<IRI, IRI>();

    @Override
    public IRI getConvertedIRI(OWLEntity entity) {
        IRI convIRI = this.iriMap.get(entity.getIRI());
        if (convIRI == null) {
            convIRI = OWLEntityURIUnderscores2CamelBackConverterStrategy.convert(entity.getIRI());
            this.iriMap.put(entity.getIRI(), convIRI);
        }
        return convIRI;
    }

    private static IRI convert(IRI iri) {
        String iriString = iri.toString();
        String fragment = iri.toURI().getFragment();
        if (fragment != null) {
            String base = iriString.substring(0, iriString.length() - fragment.length());
            String camelCaseFragment = OWLEntityURIUnderscores2CamelBackConverterStrategy.toCamelCase(fragment);
            return IRI.create(base + camelCaseFragment);
        }
        String path = iri.toURI().getPath();
        if (path.length() > 0) {
            int index = path.lastIndexOf(47);
            String lastPathElement = path.substring(index + 1, path.length());
            String camelCaseElement = OWLEntityURIUnderscores2CamelBackConverterStrategy.toCamelCase(lastPathElement);
            String base = iriString.substring(0, iriString.lastIndexOf(47) + 1);
            return IRI.create(base + camelCaseElement);
        }
        return iri;
    }

    private static String toCamelCase(String s) {
        StringBuilder sb = new StringBuilder();
        boolean nextIsUpperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '_') {
                nextIsUpperCase = true;
                continue;
            }
            if (nextIsUpperCase) {
                sb.append(Character.toUpperCase(ch));
                nextIsUpperCase = false;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

