/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.deployment.spring;

import it.openutils.deployment.spring.PropertyAnnotationsUtils;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.UrlResource;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentPropertyConfigurer
extends PropertyPlaceholderConfigurer
implements ApplicationContextAware,
SmartInstantiationAwareBeanPostProcessor {
    private String serverPropertyName = "env";
    private String applicationPropertyName = "appl";
    private static Logger log = LoggerFactory.getLogger(EnvironmentPropertyConfigurer.class);
    private ServletContext servletContext;
    private String fileLocation;
    protected Properties properties;
    private boolean inherit = true;
    private boolean exposeSystemProperties;
    private String nullValue;

    public void setFileLocation(String fileLocation) {
        this.fileLocation = fileLocation;
    }

    public void setInherit(boolean inherit) {
        this.inherit = inherit;
    }

    public void setServerPropertyName(String serverPropertyName) {
        this.serverPropertyName = serverPropertyName;
    }

    public void setApplicationPropertyName(String applicationPropertyName) {
        this.applicationPropertyName = applicationPropertyName;
    }

    public void setExposeSystemProperties(boolean exposeSystemProperties) {
        this.exposeSystemProperties = exposeSystemProperties;
    }

    public void setNullValue(String nullValue) {
        this.nullValue = nullValue;
        super.setNullValue(nullValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        HashMap<String, String> initParametersMap = new HashMap<String, String>();
        if (this.fileLocation != null) {
            String applName;
            if (this.servletContext != null) {
                Enumeration initParameters = this.servletContext.getInitParameterNames();
                while (initParameters.hasMoreElements()) {
                    String paramName = (String)initParameters.nextElement();
                    initParametersMap.put("${contextParam/" + paramName + "}", this.servletContext.getInitParameter(paramName));
                }
            }
            String hostname = null;
            try {
                hostname = StringUtils.substringBefore((String)StringUtils.lowerCase((String)InetAddress.getLocalHost().getHostName()), (String)".");
                initParametersMap.put("${" + this.serverPropertyName + "}", hostname);
            }
            catch (UnknownHostException e) {
                log.error(e.getMessage());
            }
            if (hostname != null) {
                System.setProperty("env", hostname);
            }
            if ((applName = this.getApplicationName()) != null) {
                System.setProperty("appl", applName);
                initParametersMap.put("${" + this.applicationPropertyName + "}", applName);
            }
            URL propertyUrl = null;
            String fileLocationFull = this.fileLocation;
            String replacedLocations = this.replaceAll(initParametersMap, fileLocationFull);
            Object[] locations = StringUtils.split((String)replacedLocations, (String)",");
            if (this.inherit) {
                ArrayUtils.reverse((Object[])locations);
            }
            Properties props = new Properties();
            boolean found = false;
            for (Object loc : locations) {
                propertyUrl = this.getResource(StringUtils.strip((String)loc));
                if (propertyUrl != null) {
                    found = true;
                    log.debug("Loading property file at {}", loc);
                    UrlResource resource = new UrlResource(propertyUrl);
                    InputStream is = null;
                    try {
                        is = resource.getInputStream();
                        props.load(is);
                    }
                    catch (IOException e) {
                        log.error("Error loading " + propertyUrl.toString(), (Throwable)e);
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    if (!this.inherit) break;
                }
                log.debug("Property file not found at {}", loc);
            }
            if (!found) {
                log.error("No properties found at {}", (Object)replacedLocations);
            }
            this.properties = props;
            super.setProperties(props);
            if (this.exposeSystemProperties) {
                for (String string : props.keySet()) {
                    String value = (String)props.get(string);
                    System.setProperty(string, value);
                }
            }
        }
        super.postProcessBeanFactory(beanFactory);
    }

    private String replaceAll(Map<String, String> params, String fileLocationFull) {
        String replacedLocations = fileLocationFull;
        for (Map.Entry<String, String> param : params.entrySet()) {
            replacedLocations = StringUtils.replace((String)replacedLocations, (String)param.getKey(), (String)param.getValue());
        }
        return replacedLocations;
    }

    private URL getResource(String resource) {
        URL url = null;
        if (this.servletContext != null && !StringUtils.contains((String)resource, (String)"classpath:")) {
            try {
                url = resource != null && !resource.startsWith("/") ? this.servletContext.getResource("/" + resource) : this.servletContext.getResource(resource);
                if (url != null) {
                    url.openConnection().connect();
                }
            }
            catch (MalformedURLException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                url = null;
            }
        }
        if (url == null) {
            try {
                url = ResourceUtils.getURL((String)resource);
                url.openStream().close();
            }
            catch (IOException e) {
                url = null;
            }
        }
        return url;
    }

    private String getApplicationName() {
        if (this.servletContext != null) {
            String url = this.servletContext.getRealPath("/");
            if ((url = StringUtils.replace((String)url, (String)"\\", (String)"/")).endsWith("/")) {
                url = StringUtils.substringBeforeLast((String)url, (String)"/");
            }
            return StringUtils.substringAfterLast((String)url, (String)"/");
        }
        return "";
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(key);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        try {
            if (applicationContext instanceof WebApplicationContext) {
                this.servletContext = ((WebApplicationContext)applicationContext).getServletContext();
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        PropertyAnnotationsUtils.autowireProperties(bean, new PlaceholderResolvingStringValueResolver(this.properties));
        return true;
    }

    public Class predictBeanType(Class beanClass, String beanName) {
        return null;
    }

    public Constructor[] determineCandidateConstructors(Class beanClass, String beanName) throws BeansException {
        return null;
    }

    public Object getEarlyBeanReference(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInstantiation(Class beanClass, String beanName) throws BeansException {
        return null;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        return pvs;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    protected class PlaceholderResolvingStringValueResolver
    implements StringValueResolver {
        private final Properties props;

        public PlaceholderResolvingStringValueResolver(Properties props) {
            this.props = props;
        }

        public String resolveStringValue(String strVal) throws BeansException {
            String value = EnvironmentPropertyConfigurer.this.parseStringValue(strVal, this.props, new HashSet());
            return value.equals(EnvironmentPropertyConfigurer.this.nullValue) ? null : value;
        }
    }
}

