/**
 *
 * openutils deployment tools (http://www.openmindlab.com/lab/products/deployment.html)
 * Copyright(C) 2007-2010, Openmind S.r.l. http://www.openmindonline.it
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package it.openutils.deployment.spring;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

import org.springframework.beans.SimpleTypeConverter;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringValueResolver;


/**
 * Utility class for doing property replacement in fields.
 * @author fgiust
 * @version $Id: PropertyAnnotationsUtils.java 2163 2010-03-19 22:24:28Z fgiust $
 */
public final class PropertyAnnotationsUtils
{

    private static SimpleTypeConverter typeConverter = new SimpleTypeConverter();

    private PropertyAnnotationsUtils()
    {
        // don't instantiate
    }

    public static void autowireProperties(final Object bean, final StringValueResolver valueResolver)
    {
        ReflectionUtils.doWithFields(bean.getClass(), new ReflectionUtils.FieldCallback()
        {

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException
            {
                Property annotation = field.getAnnotation(Property.class);
                if (annotation != null)
                {
                    if (Modifier.isStatic(field.getModifiers()))
                    {
                        throw new IllegalStateException(
                            "PropertyAutowired annotation is not supported on static fields");
                    }

                    Object strValue = valueResolver.resolveStringValue("${" + annotation.value() + "}");

                    if (strValue != null)
                    {
                        Object value = typeConverter.convertIfNecessary(strValue, field.getType());
                        ReflectionUtils.makeAccessible(field);
                        field.set(bean, value);
                    }
                }
            }

        });
    }

}
