/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.deployment.spring;

import it.openutils.deployment.spring.Property;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringValueResolver;

public final class PropertyAnnotationsUtils {
    private static SimpleTypeConverter typeConverter = new SimpleTypeConverter();

    private PropertyAnnotationsUtils() {
    }

    public static void autowireProperties(final Object bean, final StringValueResolver valueResolver) {
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                Property annotation = field.getAnnotation(Property.class);
                if (annotation != null) {
                    if (Modifier.isStatic(field.getModifiers())) {
                        throw new IllegalStateException("PropertyAutowired annotation is not supported on static fields");
                    }
                    String strValue = valueResolver.resolveStringValue("${" + annotation.value() + "}");
                    if (strValue != null) {
                        Object value = typeConverter.convertIfNecessary((Object)strValue, field.getType());
                        ReflectionUtils.makeAccessible((Field)field);
                        field.set(bean, value);
                    }
                }
            }
        });
    }
}

