/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.deployment.spring;

import it.openutils.deployment.spring.PropertyAnnotationsUtils;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.UrlResource;
import org.springframework.util.ResourceUtils;
import org.springframework.web.context.WebApplicationContext;

public class EnvironmentPropertyConfigurer
extends PropertyPlaceholderConfigurer
implements ApplicationContextAware,
SmartInstantiationAwareBeanPostProcessor {
    private static final String PROPERTY_APPL = "${appl}";
    private static final String PROPERTY_ENV = "${env}";
    private static Logger log = LoggerFactory.getLogger(EnvironmentPropertyConfigurer.class);
    @Deprecated
    private String defaultEnvironment;
    private ServletContext servletContext;
    private String fileLocation;
    protected Properties properties;
    private boolean inherit = true;

    public void setFileLocation(String fileLocation) {
        this.fileLocation = fileLocation;
    }

    public void setInherit(boolean inherit) {
        this.inherit = inherit;
    }

    @Deprecated
    public void setDefaultEnvironment(String defaultEnvironment) {
        this.defaultEnvironment = defaultEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.fileLocation != null) {
            String applName;
            String hostname = null;
            try {
                hostname = StringUtils.substringBefore((String)StringUtils.lowerCase((String)InetAddress.getLocalHost().getHostName()), (String)".");
            }
            catch (UnknownHostException e) {
                log.error(e.getMessage());
            }
            if (hostname != null) {
                System.setProperty("env", hostname);
            }
            if ((applName = this.getApplicationName()) != null) {
                System.setProperty("appl", applName);
            }
            URL propertyUrl = null;
            String fileLocationFull = this.fileLocation;
            if (this.defaultEnvironment != null) {
                log.warn("Usage of \"defaultEnvironment\" is deprecated, please specify the fallback location as the last comma separated value in \"fileLocation\"");
                fileLocationFull = fileLocationFull + "," + StringUtils.replace((String)fileLocationFull, (String)PROPERTY_ENV, (String)this.defaultEnvironment);
            }
            String replacedLocations = StringUtils.replace((String)fileLocationFull, (String)PROPERTY_ENV, (String)hostname);
            replacedLocations = StringUtils.replace((String)replacedLocations, (String)PROPERTY_APPL, (String)applName);
            Object[] locations = StringUtils.split((String)replacedLocations, (String)",");
            if (this.inherit) {
                ArrayUtils.reverse((Object[])locations);
            }
            Properties props = new Properties();
            boolean found = false;
            for (Object loc : locations) {
                propertyUrl = this.getResource(StringUtils.strip((String)loc));
                if (propertyUrl != null) {
                    found = true;
                    log.debug("Loading property file at {}", loc);
                    UrlResource resource = new UrlResource(propertyUrl);
                    InputStream is = null;
                    try {
                        is = resource.getInputStream();
                        props.load(is);
                    }
                    catch (IOException e) {
                        log.error("Error loading " + propertyUrl.toString(), (Throwable)e);
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    if (!this.inherit) break;
                }
                log.debug("Property file not found at {}", loc);
            }
            if (!found) {
                log.error("No properties found at {}", (Object)replacedLocations);
            }
            this.properties = props;
            super.setProperties(props);
        }
        super.postProcessBeanFactory(beanFactory);
    }

    private URL getResource(String resource) {
        URL url = null;
        if (this.servletContext != null && !StringUtils.contains((String)resource, (String)"classpath:")) {
            try {
                url = resource != null && !resource.startsWith("/") ? this.servletContext.getResource("/" + resource) : this.servletContext.getResource(resource);
                if (url != null) {
                    url.openConnection().connect();
                }
            }
            catch (MalformedURLException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                url = null;
            }
        }
        if (url == null) {
            try {
                url = ResourceUtils.getURL((String)resource);
                url.openStream().close();
            }
            catch (IOException e) {
                url = null;
            }
        }
        return url;
    }

    private String getApplicationName() {
        if (this.servletContext != null) {
            String url = this.servletContext.getRealPath("/");
            if ((url = StringUtils.replace((String)url, (String)"\\", (String)"/")).endsWith("/")) {
                url = StringUtils.substringBeforeLast((String)url, (String)"/");
            }
            return StringUtils.substringAfterLast((String)url, (String)"/");
        }
        return "";
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(key);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        try {
            if (applicationContext instanceof WebApplicationContext) {
                this.servletContext = ((WebApplicationContext)applicationContext).getServletContext();
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        PropertyAnnotationsUtils.autowireProperties(bean, this.properties);
        return true;
    }

    public Class predictBeanType(Class beanClass, String beanName) {
        return null;
    }

    public Constructor[] determineCandidateConstructors(Class beanClass, String beanName) throws BeansException {
        return null;
    }

    public Object getEarlyBeanReference(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInstantiation(Class beanClass, String beanName) throws BeansException {
        return null;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        return pvs;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

