/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.deployment.log4j;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import javax.servlet.ServletContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentResolver {
    private static Logger log = LoggerFactory.getLogger(DeploymentResolver.class);

    public static File resolveServerRelativeLocation(ServletContext context, String commaSeparatedListOfPaths) throws FileNotFoundException {
        String[] propertiesLocation = StringUtils.split((String)commaSeparatedListOfPaths, (char)',');
        String servername = DeploymentResolver.resolveServerName();
        String rootPath = StringUtils.stripEnd((String)StringUtils.replace((String)context.getRealPath("/"), (String)"\\", (String)"/"), (String)"/");
        String webapp = StringUtils.substringAfterLast((String)rootPath, (String)"/");
        log.info("Resolving log configuration using servername={} and webapp={}", (Object)servername, (Object)webapp);
        for (int j = 0; j < propertiesLocation.length; ++j) {
            String location = StringUtils.trim((String)propertiesLocation[j]);
            location = StringUtils.replace((String)location, (String)"${servername}", (String)servername);
            File initFile = new File(rootPath, location = StringUtils.replace((String)location, (String)"${webapp}", (String)webapp));
            if (initFile.exists() && !initFile.isDirectory()) {
                log.debug("Log4j config FOUND at {}", (Object)initFile.getAbsolutePath());
                return initFile;
            }
            log.debug("Log4j config not found at {}", (Object)initFile.getAbsolutePath());
        }
        throw new FileNotFoundException(MessageFormat.format("No configuration found using location list {0}. [servername] is [{1}], [webapp] is [{2}] and base path is [{3}]", ArrayUtils.toString((Object)propertiesLocation), servername, webapp, rootPath));
    }

    public static String resolveServerName() {
        String servername = null;
        try {
            servername = StringUtils.lowerCase((String)InetAddress.getLocalHost().getHostName());
            if (StringUtils.contains((String)servername, (String)".")) {
                servername = StringUtils.substringBefore((String)servername, (String)".");
            }
        }
        catch (UnknownHostException e) {
            System.err.println(e.getMessage());
        }
        return servername;
    }
}

