/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.deployment.spring;

import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.web.context.ServletContextAware;

public class EnvironmentPropertyConfigurer
extends PropertyPlaceholderConfigurer
implements ServletContextAware {
    private String fileLocation;
    private String defaultEnvironment;
    private ServletContext servletContext;
    private static Logger log = LoggerFactory.getLogger(EnvironmentPropertyConfigurer.class);

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setFileLocation(String fileLocation) {
        this.fileLocation = fileLocation;
    }

    public void setDefaultEnvironment(String defaultEnvironment) {
        this.defaultEnvironment = defaultEnvironment;
    }

    private String getRootPath() {
        if (this.servletContext != null) {
            return this.servletContext.getRealPath("/");
        }
        return "src/main/webapp/";
    }

    private URL getResource(String resource) {
        URL url = null;
        if (this.servletContext != null) {
            try {
                url = this.servletContext.getResource(resource);
            }
            catch (MalformedURLException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                return new File(this.getRootPath(), resource).toURL();
            }
            catch (MalformedURLException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return url;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.fileLocation != null) {
            String hostname = null;
            try {
                hostname = StringUtils.lowerCase((String)InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                log.error(e.getMessage());
            }
            System.setProperty("env", hostname);
            String resolvedLocation = StringUtils.replace((String)this.fileLocation, (String)"${env}", (String)hostname);
            URL propertyUrl = null;
            propertyUrl = this.getResource(resolvedLocation);
            if (propertyUrl == null) {
                log.info("No environment specific properties found at {}, using default", (Object)resolvedLocation);
                resolvedLocation = StringUtils.replace((String)this.fileLocation, (String)"${env}", (String)this.defaultEnvironment);
                propertyUrl = this.getResource(resolvedLocation);
            }
            if (propertyUrl == null) {
                log.error("No default properties found at {}", (Object)resolvedLocation);
            } else {
                UrlResource resource = new UrlResource(propertyUrl);
                super.setLocation((Resource)resource);
            }
        }
        super.postProcessBeanFactory(beanFactory);
    }
}

