/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.deployment.log4j;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import javax.servlet.ServletContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class DeploymentResolver {
    public static File resolveServerRelativeLocation(ServletContext context, String commaSeparatedListOfPaths) throws FileNotFoundException {
        String[] propertiesLocation = StringUtils.split((String)commaSeparatedListOfPaths, (char)',');
        String servername = null;
        try {
            servername = StringUtils.lowerCase((String)InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            System.err.println(e.getMessage());
        }
        String rootPath = StringUtils.replace((String)context.getRealPath(""), (String)"\\", (String)"/");
        String webapp = StringUtils.substringAfterLast((String)rootPath, (String)"/");
        for (int j = 0; j < propertiesLocation.length; ++j) {
            String location = StringUtils.trim((String)propertiesLocation[j]);
            location = StringUtils.replace((String)location, (String)"${servername}", (String)servername);
            File initFile = new File(rootPath, location = StringUtils.replace((String)location, (String)"${webapp}", (String)webapp));
            if (!initFile.exists() || initFile.isDirectory()) continue;
            return initFile;
        }
        throw new FileNotFoundException(MessageFormat.format("No configuration found using location list {0}. [servername] is [{1}], [webapp] is [{2}] and base path is [{3}]", ArrayUtils.toString((Object)propertiesLocation), servername, webapp, rootPath));
    }
}

