/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.look;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.geom.Arc2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PanelUI;
import org.noos.xing.mydoggy.FloatingLiveTypeDescriptor;
import org.noos.xing.mydoggy.FloatingTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.ToolWindowTypeDescriptor;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowTab;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.ui.PopupUpdater;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;
import org.noos.xing.mydoggy.plaf.ui.animation.AbstractAnimation;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowTabButton;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowTitleBar;
import org.noos.xing.mydoggy.plaf.ui.cmp.border.LineBorder;
import org.noos.xing.mydoggy.plaf.ui.drag.DragListenerAdapter;
import org.noos.xing.mydoggy.plaf.ui.drag.MyDoggyTransferable;
import org.noos.xing.mydoggy.plaf.ui.look.TitleBarMouseAdapter;
import org.noos.xing.mydoggy.plaf.ui.util.GraphicsUtil;
import org.noos.xing.mydoggy.plaf.ui.util.MutableColor;
import org.noos.xing.mydoggy.plaf.ui.util.RemoveNotifyDragListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class ToolWindowTitleBarUI
extends PanelUI
implements Cleaner,
PropertyChangeListener {
    protected ToolWindow toolWindow;
    protected ToolWindowDescriptor descriptor;
    protected MutableColor animBackStart;
    protected MutableColor animBackEnd;
    protected MutableColor animTextColor;
    protected ToolWindowTitleBar toolWindowTitleBar;
    protected ExtendedTableLayout toolWindowTitleBarLayout;
    protected MouseListener titleBarMouseAdapter;
    protected GradientAnimation animation;
    protected Timer flashingTimer;
    protected int flasingDuration;
    protected boolean flashingState;
    protected AbstractAnimation flashingAnimation;
    protected RemoveNotifyDragListener removeNotifyDragListener;
    protected List<PopupUpdater> popupUpdaterList;

    public static ComponentUI createUI(JComponent c) {
        return new ToolWindowTitleBarUI();
    }

    public void cleanup() {
        this.uninstallUI(this.toolWindowTitleBar);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("flash".equals(propertyName)) {
            if (evt.getNewValue() == Boolean.TRUE) {
                if (this.toolWindow.isVisible()) {
                    this.flasingDuration = SwingUtil.getInt(evt, -1);
                    SwingUtil.repaint(this.toolWindowTitleBar);
                }
            } else if (this.flashingTimer != null) {
                this.flashingTimer.stop();
                this.flashingTimer = null;
                SwingUtil.repaint(this.toolWindowTitleBar);
            }
        } else if ("active".equals(evt.getPropertyName())) {
            if (evt.getSource() != this.toolWindow || !this.toolWindow.isVisible()) {
                return;
            }
            if (evt.getNewValue() == Boolean.FALSE) {
                if (this.animBackStart.equals(UIManager.getColor("ToolWindowTitleBarUI.background.active.start"))) {
                    this.animation.hide(new Object[0]);
                } else {
                    this.animation.stop();
                }
            } else if (this.animBackStart.equals(UIManager.getColor("ToolWindowTitleBarUI.background.inactive.start"))) {
                this.animation.show(new Object[0]);
            } else {
                this.animation.stop();
            }
        } else if ("idVisibleOnTitleBar".equals(propertyName)) {
            ToolWindowTypeDescriptor typeDescriptor = (ToolWindowTypeDescriptor)evt.getSource();
            if (typeDescriptor.getType().equals((Object)this.toolWindow.getType())) {
                this.setIdOnTitleBarVisible((Boolean)evt.getNewValue());
            }
        } else if ("type".equals(propertyName)) {
            if (!ToolWindowType.EXTERN.equals(evt.getNewValue())) {
                this.setIdOnTitleBarVisible(this.descriptor.getTypeDescriptor((ToolWindowType)evt.getNewValue()).isIdVisibleOnTitleBar());
            }
        } else if ("titleBarVisible".equals(propertyName) && ((ToolWindowTypeDescriptor)evt.getSource()).getType() == this.toolWindow.getType()) {
            if (((Boolean)evt.getNewValue()).booleanValue()) {
                this.toolWindowTitleBarLayout.setColumn(1, SwingUtil.getInt("ToolWindowTitleBarUI.length", 16));
                this.toolWindowTitleBar.setVisible(true);
            } else {
                this.toolWindowTitleBarLayout.setColumn(1, 0.0);
                this.toolWindowTitleBar.setVisible(false);
            }
        }
    }

    public void installUI(JComponent c) {
        this.toolWindowTitleBar = (ToolWindowTitleBar)c;
        this.descriptor = this.toolWindowTitleBar.getToolWindowDescriptor();
        this.toolWindow = this.descriptor.getToolWindow();
        super.installUI(c);
        this.installDefaults(c);
        this.installComponents();
        this.installListeners(c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallDefaults(c);
        this.uninstallListeners(c);
        this.flashingAnimation.stop();
        this.animation.stop();
        if (this.flashingTimer != null) {
            this.flashingTimer.stop();
        }
        this.flashingTimer = null;
        this.toolWindowTitleBar = null;
        this.animation = null;
        this.flashingAnimation = null;
        this.toolWindow = null;
        this.descriptor = null;
    }

    public void paint(Graphics g, JComponent c) {
        Rectangle r = c.getBounds();
        r.y = 0;
        r.x = 0;
        if (this.toolWindow.isFlashing()) {
            if (this.flashingState) {
                this.updateToolWindowTitleBar(g, c, this.animBackStart, this.animBackEnd, UIManager.getColor("ToolWindowTitleBarUI.id.background.flashing.on"), this.animTextColor);
            } else {
                this.updateToolWindowTitleBar(g, c, this.animBackStart, this.animBackEnd, UIManager.getColor("ToolWindowTitleBarUI.id.background.flashing.off"), this.animTextColor);
            }
            if (this.flashingTimer == null) {
                this.flashingTimer = new Timer(700, new ActionListener(){
                    long start = 0L;

                    public void actionPerformed(ActionEvent e) {
                        if (this.start == 0L) {
                            this.start = System.currentTimeMillis();
                        }
                        boolean bl = ToolWindowTitleBarUI.this.flashingState = !ToolWindowTitleBarUI.this.flashingState;
                        if (ToolWindowTitleBarUI.this.flashingAnimation.isAnimating()) {
                            ToolWindowTitleBarUI.this.flashingAnimation.stop();
                        }
                        if (ToolWindowTitleBarUI.this.flashingState) {
                            ToolWindowTitleBarUI.this.flashingAnimation.show(new Object[0]);
                        } else {
                            ToolWindowTitleBarUI.this.flashingAnimation.hide(new Object[0]);
                        }
                        if (ToolWindowTitleBarUI.this.flasingDuration != -1 && System.currentTimeMillis() - this.start > (long)ToolWindowTitleBarUI.this.flasingDuration) {
                            ToolWindowTitleBarUI.this.toolWindow.setFlashing(false);
                        }
                    }
                });
                this.flashingState = true;
                this.flashingAnimation.show(new Object[0]);
            }
            if (!this.flashingTimer.isRunning()) {
                this.flashingTimer.start();
            }
        } else if (this.animation.isAnimating()) {
            this.updateToolWindowTitleBar(g, c, this.animBackStart, this.animBackEnd, UIManager.getColor("ToolWindowTitleBarUI.id.background.animating"), this.animTextColor);
        } else if (c.isEnabled()) {
            this.updateToolWindowTitleBar(g, c, UIManager.getColor("ToolWindowTitleBarUI.background.active.start"), UIManager.getColor("ToolWindowTitleBarUI.background.active.end"), UIManager.getColor("ToolWindowTitleBarUI.id.background.active"), UIManager.getColor("ToolWindowTitleBarUI.id.foreground.active"));
        } else {
            this.updateToolWindowTitleBar(g, c, UIManager.getColor("ToolWindowTitleBarUI.background.inactive.start"), UIManager.getColor("ToolWindowTitleBarUI.background.inactive.end"), UIManager.getColor("ToolWindowTitleBarUI.id.background.inactive"), UIManager.getColor("ToolWindowTitleBarUI.id.foreground.inactive"));
        }
    }

    protected void installDefaults(JComponent c) {
        this.animBackStart = new MutableColor(UIManager.getColor("ToolWindowTitleBarUI.background.inactive.start"));
        this.animBackEnd = new MutableColor(0, 0, 0);
        this.animTextColor = new MutableColor(0, 0, 0);
        this.flashingAnimation = new GradientAnimation(700.0f);
        this.flasingDuration = -1;
        this.animation = new GradientAnimation();
        this.toolWindowTitleBar.setBorder(null);
        LookAndFeel.installColorsAndFont(c, "Panel.background", "Panel.foreground", "Panel.font");
        LookAndFeel.installBorder(c, "Panel.border");
        SwingUtil.installFont(c, "ToolWindowTitleBarUI.font");
    }

    protected void uninstallDefaults(JComponent c) {
        LookAndFeel.uninstallBorder(c);
    }

    protected void installListeners(JComponent c) {
        this.descriptor.getCleaner().addCleaner(this);
        this.descriptor.getToolWindow().addPlafPropertyChangeListener(this);
        this.descriptor.addTypeDescriptorChangePropertyListener(this);
        this.titleBarMouseAdapter = new TitleBarMouseAdapter(this.descriptor);
        this.toolWindowTitleBar.addMouseListener(this.titleBarMouseAdapter);
        ToolWindowTitleBarDragListener dragListener = new ToolWindowTitleBarDragListener(this.descriptor);
        this.removeNotifyDragListener = new RemoveNotifyDragListener(this.toolWindowTitleBar, dragListener);
        this.descriptor.getManager().addRemoveNotifyListener(this.removeNotifyDragListener);
        this.toolWindowTitleBar.getToolWindowTabPanel().setDragListener(dragListener);
    }

    protected void uninstallListeners(JComponent c) {
        this.descriptor.getCleaner().removeCleaner(this);
        this.descriptor.getToolWindow().removePlafPropertyChangeListener(this);
        this.descriptor.removeTypeDescriptorChangePropertyListener(this);
        this.toolWindowTitleBar.removeMouseListener(this.titleBarMouseAdapter);
        this.removeNotifyDragListener.cleanup();
        this.descriptor.getManager().removeRemoveNotifyListener(this.removeNotifyDragListener);
    }

    protected void installComponents() {
        this.toolWindowTitleBarLayout = new ExtendedTableLayout(new double[][]{{3.0, -1.0, 2.0, -2.0, 3.0}, {0.0, SwingUtil.getInt("ToolWindowTitleBarUI.length", 16), 0.0}}, false);
        this.toolWindowTitleBar.setLayout((LayoutManager)((Object)this.toolWindowTitleBarLayout));
        this.toolWindowTitleBar.add((Component)this.toolWindowTitleBar.getToolWindowTabPanel(), "1,1");
        this.toolWindowTitleBar.add((Component)this.toolWindowTitleBar.getToolWindowTitleButtonPanel(), "3,1,right,c");
        this.setIdOnTitleBarVisible(true);
    }

    protected void setIdOnTitleBarVisible(boolean visible) {
        if (!visible) {
            this.toolWindowTitleBarLayout.setColumn(0, 3.0);
        }
        SwingUtil.repaint(this.toolWindowTitleBar);
    }

    protected void updateToolWindowTitleBar(Graphics g, JComponent c, Color backgroundStart, Color backgroundEnd, Color idBackgroundColor, Color idColor) {
        Rectangle r = c.getBounds();
        r.y = 0;
        r.x = 0;
        GraphicsUtil.fillRect(g, r, backgroundStart, backgroundEnd, null, 5);
        if (this.descriptor.isIdVisibleOnTitleBar()) {
            int columWidth = this.getTitleWidth(g);
            if ((double)columWidth != this.toolWindowTitleBarLayout.getColumn(0)) {
                this.toolWindowTitleBarLayout.setColumn(0, columWidth);
                SwingUtil.revalidate(this.toolWindowTitleBar);
            }
            String id = SwingUtil.getUserString(this.descriptor.getToolWindow().getRepresentativeAnchorDescriptor().getTitle());
            r.width = g.getFontMetrics().stringWidth(id) + 8;
            int halfHeigh = r.height / 2;
            GraphicsUtil.fillRect(g, r, Color.WHITE, idBackgroundColor, new Polygon(new int[]{r.x, r.x + r.width - halfHeigh, r.x + r.width - halfHeigh, r.x}, new int[]{r.y, r.y, r.y + r.height, r.y + r.height}, 4), 5);
            GraphicsUtil.fillRect(g, r, Color.WHITE, idBackgroundColor, new Arc2D.Double(r.x + r.width - r.height, r.y, r.height, r.height, -90.0, 180.0, 1), 5);
            g.setColor(idColor);
            g.drawString(id, r.x + 2, r.y + (r.height - g.getFontMetrics().getHeight()) / 2 + g.getFontMetrics().getAscent());
        }
    }

    protected int getTitleWidth(Graphics g) {
        return g.getFontMetrics().stringWidth(SwingUtil.getUserString(this.toolWindow.getRepresentativeAnchorDescriptor().getTitle())) + 12;
    }

    public class ToolWindowTitleBarDragListener
    extends DragListenerAdapter {
        protected JComponent lastOverCmp;
        protected Border oldBorder;
        protected LineBorder highligthBorder;
        protected boolean moveAnchor;
        protected ToolWindowAnchor lastAnchor;

        public ToolWindowTitleBarDragListener(ToolWindowDescriptor descriptor) {
            super(descriptor);
            this.lastOverCmp = null;
            this.oldBorder = null;
            this.highligthBorder = new LineBorder(Color.BLUE, 3);
            descriptor.getCleaner().addCleaner(this);
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            ToolWindowTabButton toolWindowTabButton;
            super.dragGestureRecognized(dge);
            if (!(ToolWindowTitleBarUI.this.toolWindow.getType() != ToolWindowType.FLOATING && ToolWindowTitleBarUI.this.toolWindow.getType() != ToolWindowType.FLOATING_FREE && ToolWindowTitleBarUI.this.toolWindow.getType() != ToolWindowType.FLOATING_LIVE || dge.getTriggerEvent().isShiftDown())) {
                return;
            }
            if (!this.acquireLocks()) {
                return;
            }
            MyDoggyToolWindowTab toolWindowTab = null;
            if (SwingUtilities.isDescendingFrom(dge.getComponent(), ToolWindowTitleBarUI.this.toolWindowTitleBar) && (toolWindowTabButton = SwingUtil.getParent(dge.getComponent(), ToolWindowTabButton.class)) != null) {
                toolWindowTab = (MyDoggyToolWindowTab)toolWindowTabButton.getToolWindowTab();
            }
            if (toolWindowTab != null && toolWindowTab.getDockableDelegator() != null) {
                MyDoggyTransferable transferable = new MyDoggyTransferable(this.manager);
                transferable.addEntry(MyDoggyTransferable.TOOL_WINDOW_ID_DF, toolWindowTab.getDockableDelegator().getId());
                transferable.addEntry(MyDoggyTransferable.TOOL_WINDOW_TAB_ID_DF, toolWindowTab.getId());
                dge.startDrag(DragSource.DefaultMoveDrop, transferable, this);
            } else {
                dge.startDrag(DragSource.DefaultMoveDrop, new MyDoggyTransferable(this.manager, MyDoggyTransferable.TOOL_WINDOW_ID_DF, ToolWindowTitleBarUI.this.toolWindow.getId()), this);
            }
            if (!this.descriptor.isDragImageAvailable() || SwingUtil.getBoolean("drag.icon.useDefault", false)) {
                this.setGhostImage(dge.getDragOrigin(), SwingUtil.getImage("mydoggy.image.drag"));
            } else {
                Component contentContainer = this.descriptor.getComponentForDragImage();
                BufferedImage ghostImage = new BufferedImage(contentContainer.getWidth(), contentContainer.getHeight(), 1);
                contentContainer.print(ghostImage.getGraphics());
                ghostImage = GraphicsUtil.scale(ghostImage, contentContainer.getWidth() / 3, contentContainer.getHeight() / 3);
                this.setGhostImage(dge.getDragOrigin(), ghostImage);
            }
            this.lastAnchor = null;
        }

        public void dragMouseMoved(DragSourceDragEvent dsde) {
            if (!this.checkStatus()) {
                return;
            }
            ToolWindowAnchor newAnchor = this.manager.getToolWindowAnchor(dsde.getLocation());
            if (newAnchor != this.lastAnchor) {
                if (newAnchor == null) {
                    this.manager.getBar(this.lastAnchor).setTemporarilyVisible(false);
                } else if (this.manager.getBar(newAnchor).getAvailableTools() == 0) {
                    this.manager.getBar(newAnchor).setTemporarilyVisible(true);
                }
                this.lastAnchor = newAnchor;
            }
            this.updateGhostImage(dsde.getLocation());
            this.updateDropTarget(dsde);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (!this.checkStatus()) {
                return;
            }
            this.releaseLocks();
            this.manager.setBarsTemporarilyVisible(false);
            this.cleanupGhostImage();
            try {
                if (this.lastDropPanel != null) {
                    this.lastDropPanel.drop(dsde.getDragSourceContext().getTransferable());
                } else if (this.lastBarAnchor == null) {
                    Window ancestor = SwingUtilities.getWindowAncestor(this.manager);
                    Rectangle ancestorBounds = ancestor.getBounds();
                    Point dsdeLocation = dsde.getLocation();
                    if (dsdeLocation.x >= ancestorBounds.x && dsdeLocation.y >= ancestorBounds.y && (double)dsdeLocation.x <= ancestorBounds.getMaxX() && (double)dsdeLocation.y <= ancestorBounds.getMaxY()) {
                        SwingUtil.convertPointFromScreen2(dsdeLocation, ancestor);
                        ToolWindow toolWindow = (ToolWindow)this.descriptor.getDockable();
                        ((FloatingLiveTypeDescriptor)toolWindow.getTypeDescriptor(FloatingLiveTypeDescriptor.class)).setLocation(dsdeLocation.x, dsdeLocation.y);
                        toolWindow.setType(ToolWindowType.FLOATING_LIVE);
                    } else {
                        ToolWindow toolWindow = (ToolWindow)this.descriptor.getDockable();
                        ((FloatingTypeDescriptor)toolWindow.getTypeDescriptor(FloatingTypeDescriptor.class)).setLocation(dsdeLocation.x, dsdeLocation.y);
                        toolWindow.setType(ToolWindowType.FLOATING);
                    }
                }
            }
            finally {
                this.dockableDropDragEnd();
            }
        }
    }

    public class GradientAnimation
    extends AbstractAnimation {
        public GradientAnimation() {
            super(300.0f);
        }

        protected GradientAnimation(float animationDuration) {
            super(animationDuration);
        }

        protected float onAnimating(float animationPercent) {
            switch (this.getAnimationDirection()) {
                case INCOMING: {
                    GraphicsUtil.getInterpolatedColor(ToolWindowTitleBarUI.this.animBackStart, UIManager.getColor("ToolWindowTitleBarUI.background.active.start"), UIManager.getColor("ToolWindowTitleBarUI.background.inactive.start"), animationPercent);
                    GraphicsUtil.getInterpolatedColor(ToolWindowTitleBarUI.this.animBackEnd, UIManager.getColor("ToolWindowTitleBarUI.background.active.end"), UIManager.getColor("ToolWindowTitleBarUI.background.inactive.end"), animationPercent);
                    GraphicsUtil.getInterpolatedColor(ToolWindowTitleBarUI.this.animTextColor, UIManager.getColor("ToolWindowTitleBarUI.id.foreground.active"), UIManager.getColor("ToolWindowTitleBarUI.id.foreground.inactive"), animationPercent);
                    break;
                }
                case OUTGOING: {
                    GraphicsUtil.getInterpolatedColor(ToolWindowTitleBarUI.this.animBackStart, UIManager.getColor("ToolWindowTitleBarUI.background.inactive.start"), UIManager.getColor("ToolWindowTitleBarUI.background.active.start"), animationPercent);
                    GraphicsUtil.getInterpolatedColor(ToolWindowTitleBarUI.this.animBackEnd, UIManager.getColor("ToolWindowTitleBarUI.background.inactive.end"), UIManager.getColor("ToolWindowTitleBarUI.background.active.end"), animationPercent);
                    GraphicsUtil.getInterpolatedColor(ToolWindowTitleBarUI.this.animTextColor, UIManager.getColor("ToolWindowTitleBarUI.id.foreground.inactive"), UIManager.getColor("ToolWindowTitleBarUI.id.foreground.active"), animationPercent);
                }
            }
            SwingUtil.repaint(ToolWindowTitleBarUI.this.toolWindowTitleBar);
            return animationPercent;
        }

        protected void onFinishAnimation() {
            switch (this.getAnimationDirection()) {
                case INCOMING: {
                    ToolWindowTitleBarUI.this.animBackStart.setRGB(UIManager.getColor("ToolWindowTitleBarUI.background.active.start"));
                    break;
                }
                case OUTGOING: {
                    ToolWindowTitleBarUI.this.animBackStart.setRGB(UIManager.getColor("ToolWindowTitleBarUI.background.inactive.start"));
                }
            }
            SwingUtil.repaint(ToolWindowTitleBarUI.this.toolWindowTitleBar);
        }

        protected void onHide(Object ... params) {
            ToolWindowTitleBarUI.this.animBackStart.setRGB(UIManager.getColor("ToolWindowTitleBarUI.background.active.start"));
            ToolWindowTitleBarUI.this.animBackEnd.setRGB(UIManager.getColor("ToolWindowTitleBarUI.background.active.end"));
        }

        protected void onShow(Object ... params) {
            ToolWindowTitleBarUI.this.animBackStart.setRGB(UIManager.getColor("ToolWindowTitleBarUI.background.inactive.start"));
            ToolWindowTitleBarUI.this.animBackEnd.setRGB(UIManager.getColor("ToolWindowTitleBarUI.background.inactive.end"));
        }

        protected void onStartAnimation(AbstractAnimation.Direction direction) {
        }

        protected AbstractAnimation.Direction chooseFinishDirection(AbstractAnimation.Type type) {
            return type == AbstractAnimation.Type.SHOW ? AbstractAnimation.Direction.OUTGOING : AbstractAnimation.Direction.INCOMING;
        }
    }
}

