/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.look;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;
import org.noos.xing.mydoggy.ToolWindowListener;
import org.noos.xing.mydoggy.event.ToolWindowTabEvent;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindow;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowTab;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowTabButton;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowTabPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowTabTitle;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowTitleButton;
import org.noos.xing.mydoggy.plaf.ui.look.TitleBarMouseAdapter;
import org.noos.xing.mydoggy.plaf.ui.util.GraphicsUtil;
import org.noos.xing.mydoggy.plaf.ui.util.MyDoggyUtil;
import org.noos.xing.mydoggy.plaf.ui.util.RemoveNotifyDragListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class ToolWindowTabButtonUI
extends BasicPanelUI
implements Cleaner,
PropertyChangeListener,
MouseListener,
ActionListener {
    protected ToolWindowTabPanel toolWindowTabPanel;
    protected ToolWindowTabButton toolWindowTabButton;
    protected MyDoggyToolWindow toolWindow;
    protected MyDoggyToolWindowTab tab;
    protected MouseListener titleBarMouseListener;
    protected TabButtonToolWindowListener tabButtonToolWindowListener;
    protected TableLayout layout;
    protected JLabel titleLabel;
    protected JButton closeButton;
    protected JButton minimizeButton;
    protected boolean pressed;
    protected boolean inside;
    protected boolean selected;
    protected Timer flashingTimer;
    protected int flasingDuration = -1;
    protected boolean flashingState;
    protected RemoveNotifyDragListener removeNotifyDragListener;

    public static ComponentUI createUI(JComponent c) {
        return new ToolWindowTabButtonUI();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if ("flash".equals(property)) {
            if (evt.getNewValue() == Boolean.TRUE) {
                if (!this.tab.isSelected()) {
                    this.flasingDuration = SwingUtil.getInt(evt, -1);
                    SwingUtil.repaint(this.toolWindowTabButton);
                }
            } else if (this.flashingTimer != null) {
                this.flashingTimer.stop();
                this.flashingTimer = null;
                SwingUtil.repaint(this.toolWindowTabButton);
            }
        } else if ("selected".equals(property)) {
            if (evt.getNewValue() == Boolean.FALSE) {
                this.setEnabled(false);
                this.selected = false;
            } else {
                this.tab.setFlashing(false);
                this.ensureVisible();
                this.setEnabled(true);
                this.selected = true;
            }
            SwingUtil.repaint(this.toolWindowTabButton);
        } else if ("title".equals(property)) {
            this.titleLabel.setText((String)evt.getNewValue());
            this.toolWindowTabButton.setName("toolWindow." + this.toolWindow.getId() + ".tabs." + this.tab.getTitle());
            SwingUtil.repaint(this.titleLabel);
        } else if ("icon".equals(property)) {
            this.titleLabel.setIcon((Icon)evt.getNewValue());
        } else if ("ensureVisible".equals(property)) {
            this.ensureVisible();
        } else if ("minimizable".equals(property)) {
            if (this.tab.isMinimizable()) {
                this.layout.setColumn(1, 1.0);
                this.layout.setColumn(2, 14.0);
            } else {
                this.layout.setColumn(1, 0.0);
                this.layout.setColumn(2, 0.0);
            }
            this.toolWindowTabButton.revalidate();
            this.toolWindowTabButton.repaint();
        } else if ("closeable".equals(property)) {
            if (this.tab.isCloseable()) {
                this.layout.setColumn(3, 1.0);
                this.layout.setColumn(4, 14.0);
            } else {
                this.layout.setColumn(3, 0.0);
                this.layout.setColumn(4, 0.0);
            }
            this.toolWindowTabButton.revalidate();
            this.toolWindowTabButton.repaint();
        }
    }

    public void cleanup() {
        this.uninstallUI(this.toolWindowTabButton);
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("close".equals(actionCommand)) {
            this.toolWindow.removeToolWindowTab(this.tab);
        } else {
            this.tab.setMinimized(true);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.toolWindow.setActive(true);
        if (SwingUtilities.isLeftMouseButton(e) && !this.selected) {
            this.pressed = true;
            this.toolWindowTabButton.repaint();
        } else {
            this.pressed = false;
            this.toolWindowTabButton.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.pressed = false;
        this.toolWindowTabButton.repaint();
    }

    public void mouseEntered(MouseEvent e) {
        this.inside = true;
        this.toolWindowTabButton.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.inside = false;
        this.toolWindowTabButton.repaint();
    }

    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ToolWindowTabButtonUI.this.tab.setSelected(true);
                }
            });
        }
    }

    public void installUI(JComponent c) {
        this.toolWindowTabButton = (ToolWindowTabButton)c;
        this.tab = (MyDoggyToolWindowTab)this.toolWindowTabButton.getToolWindowTab();
        this.toolWindow = (MyDoggyToolWindow)this.tab.getOwner();
        this.toolWindowTabPanel = this.toolWindowTabButton.getToolWindowTabPanel();
        super.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (this.flashingTimer != null) {
            this.flashingTimer.stop();
        }
        this.flashingTimer = null;
        this.tab = null;
        this.toolWindow = null;
    }

    protected void installDefaults(JPanel p) {
        super.installDefaults(p);
        this.installComponents();
        this.installListeners();
    }

    protected void uninstallDefaults(JPanel p) {
        super.uninstallDefaults(p);
        this.uninstallListeners();
        this.uninstallComponents();
    }

    public void update(Graphics g, final JComponent c) {
        if (this.tab == null || this.toolWindow == null) {
            return;
        }
        Rectangle bounds = c.getBounds();
        bounds.y = 0;
        bounds.x = 0;
        if (this.tab.isFlashing() && this.toolWindow.isVisible()) {
            if (this.flashingState) {
                GraphicsUtil.fillRect(g, bounds, UIManager.getColor("ToolWindowTitleBarUI.background.active.end"), UIManager.getColor("ToolWindowTitleBarUI.background.active.start"), new RoundRectangle2D.Double(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, 10.0, 10.0), 5);
            } else if (this.toolWindow.isActive()) {
                GraphicsUtil.fillRect(g, bounds, UIManager.getColor("ToolWindowTitleBarUI.background.active.start"), UIManager.getColor("ToolWindowTitleBarUI.background.active.end"), new RoundRectangle2D.Double(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, 10.0, 10.0), 5);
            }
            if (this.flashingTimer == null) {
                this.flashingTimer = new Timer(600, new ActionListener(){
                    long start = 0L;

                    public void actionPerformed(ActionEvent e) {
                        Rectangle bounds = ToolWindowTabButtonUI.this.toolWindowTabButton.getBounds();
                        bounds.y = 0;
                        bounds.x = 0;
                        if (this.start == 0L) {
                            this.start = System.currentTimeMillis();
                        }
                        ToolWindowTabButtonUI.this.flashingState = !ToolWindowTabButtonUI.this.flashingState;
                        c.putClientProperty("mydoggy.flashingState", ToolWindowTabButtonUI.this.flashingState);
                        SwingUtil.repaint(ToolWindowTabButtonUI.this.toolWindowTabButton);
                        if (ToolWindowTabButtonUI.this.flasingDuration != -1 && System.currentTimeMillis() - this.start > (long)ToolWindowTabButtonUI.this.flasingDuration) {
                            ToolWindowTabButtonUI.this.tab.setFlashing(false);
                        }
                    }
                });
                this.flashingState = true;
            }
            if (!this.flashingTimer.isRunning()) {
                this.flashingTimer.start();
            }
        } else if (MyDoggyUtil.getNumTabs(this.toolWindow) > 1 && this.tab.isSelected() && this.toolWindow.isActive()) {
            GraphicsUtil.fillRect(g, bounds, UIManager.getColor("ToolWindowTitleBarUI.background.active.end"), UIManager.getColor("ToolWindowTitleBarUI.background.active.start"), new RoundRectangle2D.Double(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, 10.0, 10.0), 5);
        }
        super.update(g, c);
    }

    protected void installComponents() {
        this.toolWindow = (MyDoggyToolWindow)this.tab.getOwner();
        String name = "toolWindow." + this.tab.getOwner().getId() + ".tab." + this.tab.getTitle();
        this.toolWindowTabButton.setName(name);
        this.layout = new TableLayout((double[][])new double[][]{{-1.0, 0.0, 0.0, 0.0, 0.0}, {-1.0}});
        this.toolWindowTabButton.setLayout((LayoutManager)this.layout);
        this.toolWindowTabButton.setOpaque(false);
        this.toolWindowTabButton.setFocusable(false);
        this.toolWindowTabButton.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.inside = false;
        this.pressed = false;
        this.selected = false;
        this.titleLabel = new ToolWindowTabTitle(this.tab);
        this.titleLabel.setName(name + ".title");
        this.toolWindowTabButton.add((Component)this.titleLabel, "0,0,FULL,FULL");
        this.closeButton = new ToolWindowTitleButton();
        this.closeButton.setName(name + ".closeButton");
        this.closeButton.setActionCommand("close");
        this.closeButton.setToolTipText(SwingUtil.getString("@@tool.tab.close"));
        this.closeButton.setIcon(UIManager.getIcon("ToolWindowTabButtonUI.icon.tabClose"));
        this.minimizeButton = new ToolWindowTitleButton();
        this.minimizeButton.setName(name + ".minimizeButton");
        this.minimizeButton.setActionCommand("minimize");
        this.minimizeButton.setToolTipText(SwingUtil.getString("@@tool.tab.minimize"));
        this.minimizeButton.setIcon(UIManager.getIcon("ToolWindowTabButtonUI.icon.tabMinimize"));
        this.toolWindowTabButton.add((Component)this.minimizeButton, "2,0,FULL,c");
        this.toolWindowTabButton.add((Component)this.closeButton, "4,0,FULL,c");
    }

    protected void uninstallComponents() {
    }

    protected void installListeners() {
        this.tab.addPlafPropertyChangeListener(this);
        this.tab.getCleanerAggregator().addCleaner(this);
        this.tabButtonToolWindowListener = new TabButtonToolWindowListener();
        this.toolWindow.addToolWindowListener(this.tabButtonToolWindowListener);
        this.toolWindowTabButton.addMouseListener(this.toolWindowTabPanel.getMouseEventDispatcher());
        this.toolWindowTabButton.addMouseMotionListener(this.toolWindowTabPanel.getMouseEventDispatcher());
        this.titleBarMouseListener = new TitleBarMouseAdapter(((MyDoggyToolWindowManager)this.tab.getOwner().getDockableManager()).getDescriptor(this.tab.getOwner()));
        this.titleLabel.addMouseListener(this.titleBarMouseListener);
        this.titleLabel.addMouseListener(this.toolWindowTabPanel.getMouseEventDispatcher());
        this.titleLabel.addMouseMotionListener(this.toolWindowTabPanel.getMouseEventDispatcher());
        this.titleLabel.addMouseListener(this);
        this.closeButton.addActionListener(this);
        this.minimizeButton.addActionListener(this);
        this.removeNotifyDragListener = new RemoveNotifyDragListener(this.toolWindowTabPanel.getDragListener(), this.toolWindowTabButton, this.titleLabel, this.minimizeButton, this.closeButton);
        this.toolWindow.getDescriptor().getManager().addRemoveNotifyListener(this.removeNotifyDragListener);
    }

    protected void uninstallListeners() {
        this.removeNotifyDragListener.cleanup();
        this.tab.removePlafPropertyChangeListener(this);
        this.tab.getCleanerAggregator().removeCleaner(this);
        this.toolWindow.removeToolWindowListener(this.tabButtonToolWindowListener);
        this.toolWindowTabButton.removeMouseListener(this.toolWindowTabPanel.getMouseEventDispatcher());
        this.toolWindowTabButton.removeMouseMotionListener(this.toolWindowTabPanel.getMouseEventDispatcher());
        this.titleLabel.removeMouseListener(this.titleBarMouseListener);
        this.titleLabel.removeMouseListener(this.toolWindowTabPanel.getMouseEventDispatcher());
        this.titleLabel.removeMouseMotionListener(this.toolWindowTabPanel.getMouseEventDispatcher());
        this.titleLabel.removeMouseListener(this);
        this.closeButton.removeActionListener(this);
        this.minimizeButton.removeActionListener(this);
        this.toolWindow.getDescriptor().getManager().removeRemoveNotifyListener(this.removeNotifyDragListener);
    }

    protected void setEnabled(boolean enabled) {
        if (enabled) {
            this.titleLabel.setForeground(UIManager.getColor("ToolWindowTitleBarUI.tab.foreground.selected"));
            this.closeButton.setIcon(UIManager.getIcon("ToolWindowTabButtonUI.icon.tabClose"));
            this.minimizeButton.setIcon(UIManager.getIcon("ToolWindowTabButtonUI.icon.tabMinimize"));
        } else {
            this.titleLabel.setForeground(UIManager.getColor("ToolWindowTitleBarUI.tab.foreground.unselected"));
            this.closeButton.setIcon(UIManager.getIcon("ToolWindowTabButtonUI.icon.tabClose.inactive"));
            this.minimizeButton.setIcon(UIManager.getIcon("ToolWindowTabButtonUI.icon.tabMinimize.inactive"));
        }
        if (enabled && MyDoggyUtil.getNumTabs(this.toolWindow) > 1) {
            if (this.tab.isCloseable()) {
                this.layout.setColumn(3, 1.0);
                this.layout.setColumn(4, 14.0);
            } else {
                this.layout.setColumn(3, 0.0);
                this.layout.setColumn(4, 0.0);
            }
            if (this.tab.isMinimizable()) {
                this.layout.setColumn(1, 1.0);
                this.layout.setColumn(2, 14.0);
            } else {
                this.layout.setColumn(1, 0.0);
                this.layout.setColumn(2, 0.0);
            }
        } else {
            this.layout.setColumn(1, 0.0);
            this.layout.setColumn(2, 0.0);
            this.layout.setColumn(3, 0.0);
            this.layout.setColumn(4, 0.0);
        }
        this.toolWindowTabButton.revalidate();
        this.toolWindowTabButton.repaint();
    }

    protected void ensureVisible() {
        this.toolWindowTabPanel.ensureVisible(this.toolWindowTabButton.getBounds());
    }

    protected void hideAllButtons() {
        this.layout.setColumn(1, 0.0);
        this.layout.setColumn(2, 0.0);
        this.layout.setColumn(3, 0.0);
        this.layout.setColumn(4, 0.0);
        SwingUtil.repaint(this.toolWindowTabButton);
    }

    public class TabButtonToolWindowListener
    implements ToolWindowListener,
    Cleaner {
        public TabButtonToolWindowListener() {
            ToolWindowTabButtonUI.this.tab.getCleanerAggregator().addBefore(ToolWindowTabButtonUI.this, this);
        }

        public void toolWindowTabAdded(ToolWindowTabEvent event) {
        }

        public boolean toolWindowTabRemoving(ToolWindowTabEvent event) {
            return true;
        }

        public void toolWindowTabRemoved(ToolWindowTabEvent event) {
            if (ToolWindowTabButtonUI.this.toolWindow != null && MyDoggyUtil.getNumTabs(ToolWindowTabButtonUI.this.toolWindow) == 1) {
                ToolWindowTabButtonUI.this.hideAllButtons();
            }
        }

        public void cleanup() {
            if (ToolWindowTabButtonUI.this.toolWindow != null) {
                ToolWindowTabButtonUI.this.toolWindow.removeToolWindowListener(this);
            }
        }
    }
}

