/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.look;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLabelUI;
import org.noos.xing.mydoggy.DockedTypeDescriptor;
import org.noos.xing.mydoggy.FloatingLiveTypeDescriptor;
import org.noos.xing.mydoggy.FloatingTypeDescriptor;
import org.noos.xing.mydoggy.RepresentativeAnchorDescriptor;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowManager;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.ui.DockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;
import org.noos.xing.mydoggy.plaf.ui.animation.AbstractAnimation;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.GlassPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.RepresentativeAnchorBalloonTip;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowRepresentativeAnchor;
import org.noos.xing.mydoggy.plaf.ui.cmp.border.LineBorder;
import org.noos.xing.mydoggy.plaf.ui.drag.MyDoggyTransferable;
import org.noos.xing.mydoggy.plaf.ui.drag.RepresentativeAnchorDragListener;
import org.noos.xing.mydoggy.plaf.ui.translucent.TranslucentPanel;
import org.noos.xing.mydoggy.plaf.ui.util.GraphicsUtil;
import org.noos.xing.mydoggy.plaf.ui.util.MutableColor;
import org.noos.xing.mydoggy.plaf.ui.util.RemoveNotifyDragListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class ToolWindowRepresentativeAnchorUI
extends MetalLabelUI
implements Cleaner {
    protected ToolWindowRepresentativeAnchor representativeAnchor;
    protected LineBorder labelBorder;
    protected ToolWindowDescriptor descriptor;
    protected ToolWindow toolWindow;
    protected RepresentativeAnchorDescriptor representativeAnchorDescriptor;
    protected ToolWindowRepresentativeAnchorMouseAdapter adapter;
    protected Timer flashingTimer;
    protected int flasingDuration;
    protected boolean flashingState;
    protected MutableColor flashingAnimBackStart;
    protected MutableColor flashingAnimBackEnd;
    protected AbstractAnimation flashingAnimation;
    protected TranslucentPanel previewPanel;
    protected RepresentativeAnchorBalloonTip balloonTip;
    protected boolean representativeAnchorVisible = true;
    protected RemoveNotifyDragListener removeNotifyDragListener;

    public static ComponentUI createUI(JComponent c) {
        return new ToolWindowRepresentativeAnchorUI();
    }

    public void propertyChange(final PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if ("visible".equals(propertyName)) {
            boolean visible = (Boolean)e.getNewValue();
            this.representativeAnchor.setOpaque(visible);
            if (visible) {
                this.labelBorder.setLineColor(UIManager.getColor("ToolWindowRepresentativeAnchorUI.border.mouseIn"));
                this.descriptor.getToolBar().ensureVisible(this.representativeAnchor);
                this.toolWindow.setFlashing(false);
            } else {
                this.labelBorder.setLineColor(UIManager.getColor("ToolWindowRepresentativeAnchorUI.border.mouseOut"));
            }
            SwingUtil.repaint(this.representativeAnchor);
        } else if ("flash".equals(propertyName)) {
            if (e.getNewValue() == Boolean.TRUE) {
                if (!this.toolWindow.isVisible()) {
                    this.flasingDuration = SwingUtil.getInt(e, -1);
                    SwingUtil.repaint(this.representativeAnchor);
                }
            } else if (this.flashingTimer != null) {
                this.flashingTimer.stop();
                this.flashingTimer = null;
                SwingUtil.repaint(this.representativeAnchor);
            }
        } else if ("showMessage".equals(propertyName)) {
            this.representativeAnchorDescriptor.ensureVisible();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Object[] params = (Object[])e.getNewValue();
                    ToolWindowRepresentativeAnchorUI.this.balloonTip.setRootPaneContainer(ToolWindowRepresentativeAnchorUI.this.descriptor.getManager().getRootPaneContainer());
                    ToolWindowRepresentativeAnchorUI.this.balloonTip.setIcon((Icon)params[0]);
                    ToolWindowRepresentativeAnchorUI.this.balloonTip.setText((String)params[1]);
                    ToolWindowRepresentativeAnchorUI.this.balloonTip.showTip();
                }
            });
        } else if ("focusOwner".equals(propertyName) && this.balloonTip.isVisible() && e.getNewValue() != null) {
            this.balloonTip.hideTip();
            if (!this.toolWindow.isAvailable() && !((ToolWindowManager)this.toolWindow.getDockableManager()).getToolWindowManagerDescriptor().isShowUnavailableTools()) {
                this.representativeAnchorDescriptor.setVisible(false);
            }
        }
    }

    public void cleanup() {
        this.uninstallUI(this.representativeAnchor);
    }

    public void installUI(JComponent c) {
        this.representativeAnchor = (ToolWindowRepresentativeAnchor)c;
        this.descriptor = this.representativeAnchor.getDockableDescriptor();
        this.toolWindow = this.descriptor.getToolWindow();
        this.representativeAnchorDescriptor = this.toolWindow.getRepresentativeAnchorDescriptor();
        super.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (this.flashingTimer != null) {
            this.flashingTimer.stop();
        }
        this.flashingTimer = null;
        this.flashingAnimation.stop();
        this.descriptor = null;
        this.toolWindow = null;
        this.representativeAnchorDescriptor = null;
        this.representativeAnchor = null;
    }

    public void update(Graphics g, JComponent c) {
        if (this.toolWindow.isAvailable()) {
            c.setForeground(UIManager.getColor("ToolWindowRepresentativeAnchorUI.foreground"));
        } else {
            c.setForeground(UIManager.getColor("ToolWindowRepresentativeAnchorUI.foreground.unavailable"));
        }
        if (this.isFlashing() && !this.toolWindow.isVisible()) {
            this.updateAnchor(g, c, this.flashingAnimBackStart, this.flashingAnimBackEnd, false, true);
            if (this.flashingTimer == null) {
                this.flashingTimer = new Timer(600, new ActionListener(){
                    long start = 0L;

                    public void actionPerformed(ActionEvent e) {
                        if (this.start == 0L) {
                            this.start = System.currentTimeMillis();
                        }
                        boolean bl = ToolWindowRepresentativeAnchorUI.this.flashingState = !ToolWindowRepresentativeAnchorUI.this.flashingState;
                        if (ToolWindowRepresentativeAnchorUI.this.flashingAnimation.isAnimating()) {
                            ToolWindowRepresentativeAnchorUI.this.flashingAnimation.stop();
                        }
                        if (ToolWindowRepresentativeAnchorUI.this.flashingState) {
                            ToolWindowRepresentativeAnchorUI.this.flashingAnimation.show(new Object[0]);
                        } else {
                            ToolWindowRepresentativeAnchorUI.this.flashingAnimation.hide(new Object[0]);
                        }
                        if (ToolWindowRepresentativeAnchorUI.this.flasingDuration != -1 && System.currentTimeMillis() - this.start > (long)ToolWindowRepresentativeAnchorUI.this.flasingDuration) {
                            ToolWindowRepresentativeAnchorUI.this.toolWindow.setFlashing(false);
                        }
                    }
                });
                this.flashingState = true;
                this.flashingAnimation.show(new Object[0]);
            }
            if (!this.flashingTimer.isRunning()) {
                this.flashingTimer.start();
            }
        } else {
            if (this.flashingTimer != null) {
                this.flashingTimer.stop();
                this.flashingTimer = null;
            }
            this.updateAnchor(g, c, UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.active.start"), UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.active.end"), this.toolWindow.isVisible(), false);
        }
        this.paint(g, c);
    }

    protected void installDefaults(JLabel c) {
        super.installDefaults(c);
        this.balloonTip = new RepresentativeAnchorBalloonTip(this.representativeAnchorDescriptor, this.representativeAnchor);
        this.flashingAnimation = new GradientAnimation();
        this.flasingDuration = -1;
        this.flashingAnimBackStart = new MutableColor(UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"));
        this.flashingAnimBackEnd = new MutableColor(UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"));
        this.labelBorder = new LineBorder(UIManager.getColor("ToolWindowRepresentativeAnchorUI.border.mouseOut"), 1, true, 3, 3);
        c.setBorder(this.labelBorder);
        c.setForeground(UIManager.getColor("ToolWindowRepresentativeAnchorUI.foreground"));
        String oldText = c.getText();
        if (oldText != null) {
            c.setText(null);
            c.setText(oldText);
        }
        if ((oldText = c.getToolTipText()) != null) {
            c.setToolTipText(null);
            c.setToolTipText(oldText);
        }
        SwingUtil.installFont(c, "ToolWindowRepresentativeAnchorUI.font");
    }

    protected void installListeners(JLabel c) {
        super.installListeners(c);
        this.representativeAnchorDescriptor.addPropertyChangeListener((PropertyChangeListener)this);
        this.descriptor.getCleaner().addCleaner(this);
        this.adapter = new ToolWindowRepresentativeAnchorMouseAdapter();
        c.addMouseListener(this.adapter);
        c.addMouseMotionListener(this.adapter);
        this.descriptor.getToolWindow().addPlafPropertyChangeListener(this);
        this.removeNotifyDragListener = new RemoveNotifyDragListener(c, new ToolWindowRepresentativeAnchorDragListener(this.descriptor, c));
        this.descriptor.getManager().addRemoveNotifyListener(this.removeNotifyDragListener);
        this.descriptor.getManager().addInternalPropertyChangeListener("focusOwner", this);
    }

    protected void uninstallListeners(JLabel c) {
        super.uninstallListeners(c);
        this.representativeAnchorDescriptor.removePropertyChangeListener((PropertyChangeListener)this);
        this.descriptor.getCleaner().removeCleaner(this);
        c.removeMouseListener(this.adapter);
        c.removeMouseMotionListener(this.adapter);
        this.descriptor.getToolWindow().removePlafPropertyChangeListener(this);
        this.removeNotifyDragListener.cleanup();
        this.descriptor.getManager().removeRemoveNotifyListener(this.removeNotifyDragListener);
        this.descriptor.getManager().removeInternalPropertyChangeListener("focusOwner", this);
    }

    protected void updateAnchor(Graphics g, JComponent c, Color backgroundStart, Color backgroundEnd, boolean active, boolean flashing) {
        Rectangle r = c.getBounds();
        r.y = 0;
        r.x = 0;
        if (flashing || active) {
            GraphicsUtil.fillRect(g, r, backgroundStart, backgroundEnd, null, 1);
        } else {
            g.setColor(UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"));
            g.fillRect(0, 0, r.width, r.height);
        }
    }

    protected void hideAllPreview() {
        if (this.previewPanel != null) {
            GlassPanel glassPane = this.descriptor.getManager().getGlassPanel();
            glassPane.remove(this.previewPanel);
        }
    }

    protected boolean isFlashing() {
        boolean result = this.toolWindow.isFlashing();
        if (!result) {
            for (ToolWindowTab tab : this.toolWindow.getToolWindowTabs()) {
                if (!tab.isFlashing()) continue;
                return true;
            }
        }
        return result;
    }

    public class ToolWindowRepresentativeAnchorDragListener
    extends RepresentativeAnchorDragListener {
        public ToolWindowRepresentativeAnchorDragListener(DockableDescriptor descriptor, Component component) {
            super(descriptor, component);
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            ToolWindowRepresentativeAnchorUI.this.hideAllPreview();
            super.dragGestureRecognized(dge);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dragDropEnd(DragSourceDropEvent dsde) {
            super.dragDropEnd(dsde);
            try {
                if (this.lastDropPanel != null) {
                    this.lastDropPanel.drop(dsde.getDragSourceContext().getTransferable());
                } else if (this.lastBarAnchor == null) {
                    Window ancestor = SwingUtilities.getWindowAncestor(this.manager);
                    Rectangle ancestorBounds = ancestor.getBounds();
                    Point dsdeLocation = dsde.getLocation();
                    if (dsdeLocation.x >= ancestorBounds.x && dsdeLocation.y >= ancestorBounds.y && (double)dsdeLocation.x <= ancestorBounds.getMaxX() && (double)dsdeLocation.y <= ancestorBounds.getMaxY()) {
                        SwingUtil.convertPointFromScreen2(dsdeLocation, ancestor);
                        ToolWindow toolWindow = (ToolWindow)this.descriptor.getDockable();
                        ((FloatingLiveTypeDescriptor)toolWindow.getTypeDescriptor(FloatingLiveTypeDescriptor.class)).setLocation(dsdeLocation.x, dsdeLocation.y);
                        toolWindow.setType(ToolWindowType.FLOATING_LIVE);
                    } else {
                        ToolWindow toolWindow = (ToolWindow)this.descriptor.getDockable();
                        ((FloatingTypeDescriptor)toolWindow.getTypeDescriptor(FloatingTypeDescriptor.class)).setLocation(dsdeLocation.x, dsdeLocation.y);
                        toolWindow.setType(ToolWindowType.FLOATING);
                    }
                    if (!ToolWindowRepresentativeAnchorUI.this.toolWindow.isVisible()) {
                        ToolWindowRepresentativeAnchorUI.this.toolWindow.setActive(true);
                    }
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.dockableDropDragEnd();
                throw throwable;
            }
            this.dockableDropDragEnd();
        }

        protected Transferable createTransferable() {
            return new MyDoggyTransferable(this.manager, MyDoggyTransferable.TOOL_WINDOW_ID_DF, ToolWindowRepresentativeAnchorUI.this.toolWindow.getId());
        }
    }

    public class ToolWindowRepresentativeAnchorMouseAdapter
    extends MouseInputAdapter
    implements ActionListener,
    Cleaner {
        protected Timer previewTimer = new Timer(0, this);
        protected boolean firstPreview = true;

        public ToolWindowRepresentativeAnchorMouseAdapter() {
            ToolWindowRepresentativeAnchorUI.this.descriptor.getCleaner().addBefore(ToolWindowRepresentativeAnchorUI.this, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseClicked(MouseEvent e) {
            if (!ToolWindowRepresentativeAnchorUI.this.toolWindow.isAvailable()) {
                return;
            }
            this.previewTimer.stop();
            this.firstPreview = false;
            this.actionPerformed(new ActionEvent(this.previewTimer, 0, "stop"));
            if (SwingUtilities.isLeftMouseButton(e)) {
                int onmask = 64;
                if ((e.getModifiersEx() & onmask) == onmask) {
                    if (ToolWindowRepresentativeAnchorUI.this.toolWindow.isVisible()) {
                        ToolWindowRepresentativeAnchorUI.this.toolWindow.setVisible(false);
                    } else {
                        block13: {
                            if (ToolWindowRepresentativeAnchorUI.this.toolWindow.isAggregateMode()) {
                                ToolWindowRepresentativeAnchorUI.this.toolWindow.setAggregateMode(false);
                                try {
                                    ToolWindowRepresentativeAnchorUI.this.toolWindow.setVisible(true);
                                    Object var4_3 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var4_4 = null;
                                    ToolWindowRepresentativeAnchorUI.this.toolWindow.setAggregateMode(true);
                                    throw throwable;
                                }
                                ToolWindowRepresentativeAnchorUI.this.toolWindow.setAggregateMode(true);
                                {
                                    break block13;
                                }
                            }
                            ToolWindowRepresentativeAnchorUI.this.toolWindow.aggregate();
                        }
                        ToolWindowRepresentativeAnchorUI.this.toolWindow.setActive(true);
                    }
                } else if (ToolWindowRepresentativeAnchorUI.this.toolWindow.isVisible()) {
                    ToolWindowRepresentativeAnchorUI.this.toolWindow.setVisible(false);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ToolWindowRepresentativeAnchorUI.this.toolWindow.setActive(true);
                        }
                    });
                    ToolWindowRepresentativeAnchorUI.this.toolWindow.setVisible(true);
                }
            } else if (SwingUtilities.isRightMouseButton(e) && ((DockedTypeDescriptor)ToolWindowRepresentativeAnchorUI.this.toolWindow.getTypeDescriptor(ToolWindowType.DOCKED)).isPopupMenuEnabled()) {
                ToolWindowRepresentativeAnchorUI.this.descriptor.showPopupMenu(e.getComponent(), e.getX(), e.getY());
            }
            ToolWindowRepresentativeAnchorUI.this.representativeAnchor.setBorder(ToolWindowRepresentativeAnchorUI.this.labelBorder);
            ToolWindowRepresentativeAnchorUI.this.labelBorder.setLineColor(UIManager.getColor("ToolWindowRepresentativeAnchorUI.border.mouseIn"));
            SwingUtil.repaint(ToolWindowRepresentativeAnchorUI.this.representativeAnchor);
        }

        public void mouseEntered(MouseEvent e) {
            if (!ToolWindowRepresentativeAnchorUI.this.toolWindow.isAvailable()) {
                return;
            }
            if (!ToolWindowRepresentativeAnchorUI.this.toolWindow.isVisible() && ToolWindowRepresentativeAnchorUI.this.previewPanel == null) {
                this.previewTimer.setInitialDelay(ToolWindowRepresentativeAnchorUI.this.representativeAnchorDescriptor.getPreviewDelay());
                this.previewTimer.start();
            }
            if (ToolWindowRepresentativeAnchorUI.this.toolWindow.isFlashing()) {
                return;
            }
            Component source = e.getComponent();
            if (!source.isOpaque()) {
                ToolWindowRepresentativeAnchorUI.this.labelBorder.setLineColor(UIManager.getColor("ToolWindowRepresentativeAnchorUI.border.mouseIn"));
                SwingUtil.repaint(source);
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!ToolWindowRepresentativeAnchorUI.this.toolWindow.isAvailable()) {
                return;
            }
            if (e.getX() >= ToolWindowRepresentativeAnchorUI.this.representativeAnchor.getWidth() || e.getX() <= 0 || e.getY() >= ToolWindowRepresentativeAnchorUI.this.representativeAnchor.getHeight() || e.getY() <= 0) {
                this.firstPreview = false;
            }
            this.previewTimer.stop();
            this.actionPerformed(new ActionEvent(this.previewTimer, 0, "stop"));
            if (ToolWindowRepresentativeAnchorUI.this.toolWindow.isFlashing()) {
                return;
            }
            Component source = e.getComponent();
            if (!source.isOpaque()) {
                ToolWindowRepresentativeAnchorUI.this.labelBorder.setLineColor(UIManager.getColor("ToolWindowRepresentativeAnchorUI.border.mouseOut"));
                SwingUtil.repaint(source);
            }
        }

        public void mouseDragged(MouseEvent e) {
            this.firstPreview = false;
            this.previewTimer.stop();
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.previewTimer) {
                if ("stop".equals(e.getActionCommand())) {
                    Window windowAncestor;
                    if (ToolWindowRepresentativeAnchorUI.this.previewPanel != null && !this.firstPreview && (windowAncestor = SwingUtilities.getWindowAncestor(ToolWindowRepresentativeAnchorUI.this.representativeAnchor)) != null) {
                        GlassPanel glassPane = ToolWindowRepresentativeAnchorUI.this.descriptor.getManager().getGlassPanel();
                        glassPane.remove(ToolWindowRepresentativeAnchorUI.this.previewPanel);
                        glassPane.setVisible(false);
                        SwingUtil.repaint(glassPane);
                        SwingUtil.repaint(windowAncestor);
                        ToolWindowRepresentativeAnchorUI.this.previewPanel = null;
                    }
                    this.firstPreview = false;
                } else if (ToolWindowRepresentativeAnchorUI.this.representativeAnchorDescriptor.isPreviewEnabled() && ToolWindowRepresentativeAnchorUI.this.descriptor.getManager().getToolWindowManagerDescriptor().isPreviewEnabled()) {
                    ToolWindowPanel contentContainer = ToolWindowRepresentativeAnchorUI.this.descriptor.getToolWindowPanel();
                    RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)SwingUtilities.getWindowAncestor(ToolWindowRepresentativeAnchorUI.this.representativeAnchor));
                    if (rootPaneContainer != null) {
                        this.firstPreview = true;
                        this.previewTimer.stop();
                        GlassPanel glassPane = ToolWindowRepresentativeAnchorUI.this.descriptor.getManager().getGlassPanel();
                        if (ToolWindowRepresentativeAnchorUI.this.previewPanel != null) {
                            glassPane.remove(ToolWindowRepresentativeAnchorUI.this.previewPanel);
                        }
                        ToolWindowRepresentativeAnchorUI.this.previewPanel = new TranslucentPanel((LayoutManager)((Object)new ExtendedTableLayout(new double[][]{{2.0, -1.0, 2.0}, {2.0, -1.0, 2.0}})));
                        ToolWindowRepresentativeAnchorUI.this.previewPanel.setAlphaModeRatio(ToolWindowRepresentativeAnchorUI.this.representativeAnchorDescriptor.getPreviewTransparentRatio());
                        this.setPreviewPanelBounds(rootPaneContainer);
                        ToolWindowRepresentativeAnchorUI.this.previewPanel.add((Component)contentContainer, "1,1,FULL,FULL");
                        glassPane.add(ToolWindowRepresentativeAnchorUI.this.previewPanel);
                        glassPane.setVisible(true);
                        SwingUtil.repaint(glassPane);
                    }
                }
            }
        }

        public void cleanup() {
            this.actionPerformed(new ActionEvent(this.previewTimer, 0, "stop"));
            if (this.previewTimer != null) {
                this.previewTimer.stop();
                this.previewTimer = null;
            }
        }

        protected void setPreviewPanelBounds(RootPaneContainer rootPaneContainer) {
            if (SwingUtil.getBoolean("toolwindowl.preview.full", false)) {
                this.setFullPreviewBounds();
            } else {
                this.setThumbnailPreviewBounds(rootPaneContainer);
            }
        }

        protected void setThumbnailPreviewBounds(RootPaneContainer rootPaneContainer) {
            int width = 176;
            int height = 132;
            JMenuBar jMenuBar = rootPaneContainer instanceof JFrame ? ((JFrame)rootPaneContainer).getJMenuBar() : null;
            ToolWindowRepresentativeAnchorUI.this.previewPanel.setSize(width + 4, height + 4);
            Rectangle containerRect = ToolWindowRepresentativeAnchorUI.this.descriptor.getManagerBounds();
            Rectangle raBound = ToolWindowRepresentativeAnchorUI.this.representativeAnchor.getParent().getBounds();
            switch (ToolWindowRepresentativeAnchorUI.this.descriptor.getToolWindow().getAnchor()) {
                case LEFT: {
                    ToolWindowRepresentativeAnchorUI.this.previewPanel.setLocation(containerRect.x + raBound.x + raBound.width + 3, (jMenuBar != null ? jMenuBar.getHeight() : 0) + containerRect.y + raBound.y + ToolWindowRepresentativeAnchorUI.this.descriptor.getToolBar(ToolWindowAnchor.TOP).getSize());
                    break;
                }
                case TOP: {
                    ToolWindowRepresentativeAnchorUI.this.previewPanel.setLocation(containerRect.x + raBound.x + ToolWindowRepresentativeAnchorUI.this.descriptor.getToolBar(ToolWindowAnchor.LEFT).getSize(), (jMenuBar != null ? jMenuBar.getHeight() : 0) + containerRect.y + raBound.y + raBound.height + 3);
                    break;
                }
                case BOTTOM: {
                    ToolWindowRepresentativeAnchorUI.this.previewPanel.setLocation(containerRect.x + raBound.x + ToolWindowRepresentativeAnchorUI.this.descriptor.getToolBar(ToolWindowAnchor.LEFT).getSize(), (jMenuBar != null ? jMenuBar.getHeight() : 0) + containerRect.y + containerRect.height - ToolWindowRepresentativeAnchorUI.this.previewPanel.getHeight() - 26);
                    break;
                }
                case RIGHT: {
                    ToolWindowRepresentativeAnchorUI.this.previewPanel.setLocation(containerRect.x + containerRect.width - ToolWindowRepresentativeAnchorUI.this.previewPanel.getWidth() - 26, (jMenuBar != null ? jMenuBar.getHeight() : 0) + containerRect.y + raBound.y + ToolWindowRepresentativeAnchorUI.this.descriptor.getToolBar(ToolWindowAnchor.TOP).getSize());
                }
            }
            if ((double)(ToolWindowRepresentativeAnchorUI.this.previewPanel.getY() + ToolWindowRepresentativeAnchorUI.this.previewPanel.getHeight()) > containerRect.getY() + containerRect.getHeight() - 26.0) {
                ToolWindowRepresentativeAnchorUI.this.previewPanel.setLocation(ToolWindowRepresentativeAnchorUI.this.previewPanel.getX(), (jMenuBar != null ? jMenuBar.getHeight() : 0) + containerRect.y + containerRect.height - ToolWindowRepresentativeAnchorUI.this.descriptor.getToolBar(ToolWindowAnchor.BOTTOM).getSize() - ToolWindowRepresentativeAnchorUI.this.previewPanel.getHeight() - 3);
            }
            if ((double)(ToolWindowRepresentativeAnchorUI.this.previewPanel.getX() + ToolWindowRepresentativeAnchorUI.this.previewPanel.getWidth()) > (double)containerRect.x + containerRect.getWidth() - 26.0) {
                ToolWindowRepresentativeAnchorUI.this.previewPanel.setLocation(containerRect.x + containerRect.width - ToolWindowRepresentativeAnchorUI.this.descriptor.getToolBar(ToolWindowAnchor.RIGHT).getSize() - ToolWindowRepresentativeAnchorUI.this.previewPanel.getWidth() - 3, ToolWindowRepresentativeAnchorUI.this.previewPanel.getY());
            }
        }

        protected void setFullPreviewBounds() {
            int height;
            Container barContainer = ToolWindowRepresentativeAnchorUI.this.descriptor.getToolBar(ToolWindowRepresentativeAnchorUI.this.toolWindow.getAnchor()).getContainer();
            int length = Math.max(ToolWindowRepresentativeAnchorUI.this.descriptor.getDividerLocation(), ToolWindowRepresentativeAnchorUI.this.descriptor.getDockedTypeDescriptor().getMinimumDockLength());
            if (length == -1) {
                length = 200;
            }
            switch (ToolWindowRepresentativeAnchorUI.this.toolWindow.getAnchor()) {
                case LEFT: {
                    height = barContainer.getHeight();
                    ToolWindowRepresentativeAnchorUI.this.previewPanel.setSize(length, height);
                    Point location = new Point(0, 0);
                    SwingUtilities.convertPointToScreen(location, barContainer);
                    location.x += barContainer.getWidth();
                    ToolWindowRepresentativeAnchorUI.this.previewPanel.setLocation(location);
                    break;
                }
                case RIGHT: {
                    height = barContainer.getHeight();
                    ToolWindowRepresentativeAnchorUI.this.previewPanel.setSize(length, height);
                    Point location = new Point(0, 0);
                    SwingUtilities.convertPointToScreen(location, barContainer);
                    location.x -= ToolWindowRepresentativeAnchorUI.this.previewPanel.getWidth();
                    ToolWindowRepresentativeAnchorUI.this.previewPanel.setLocation(location);
                    break;
                }
                case TOP: {
                    int width = barContainer.getWidth();
                    ToolWindowRepresentativeAnchorUI.this.previewPanel.setSize(width, length);
                    Point location = new Point(0, 0);
                    SwingUtilities.convertPointToScreen(location, barContainer);
                    location.y += barContainer.getHeight();
                    ToolWindowRepresentativeAnchorUI.this.previewPanel.setLocation(location);
                    break;
                }
                case BOTTOM: {
                    int width = barContainer.getWidth();
                    ToolWindowRepresentativeAnchorUI.this.previewPanel.setSize(width, length);
                    Point location = new Point(0, 0);
                    SwingUtilities.convertPointToScreen(location, barContainer);
                    location.y -= ToolWindowRepresentativeAnchorUI.this.previewPanel.getHeight();
                    ToolWindowRepresentativeAnchorUI.this.previewPanel.setLocation(location);
                }
            }
            height = ToolWindowRepresentativeAnchorUI.this.previewPanel.getHeight();
            Point point = SwingUtilities.convertPoint(ToolWindowRepresentativeAnchorUI.this.previewPanel, 0, 0, ToolWindowRepresentativeAnchorUI.this.descriptor.getManager().getLayeredPane());
            ToolWindowRepresentativeAnchorUI.this.previewPanel.setBounds(point.x, point.y, ToolWindowRepresentativeAnchorUI.this.previewPanel.getWidth(), height);
        }
    }

    public class GradientAnimation
    extends AbstractAnimation {
        public GradientAnimation() {
            super(600.0f);
        }

        protected float onAnimating(float animationPercent) {
            switch (this.getAnimationDirection()) {
                case INCOMING: {
                    GraphicsUtil.getInterpolatedColor(ToolWindowRepresentativeAnchorUI.this.flashingAnimBackStart, UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"), UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.active.start"), animationPercent);
                    GraphicsUtil.getInterpolatedColor(ToolWindowRepresentativeAnchorUI.this.flashingAnimBackEnd, UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"), UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.active.end"), animationPercent);
                    break;
                }
                case OUTGOING: {
                    GraphicsUtil.getInterpolatedColor(ToolWindowRepresentativeAnchorUI.this.flashingAnimBackStart, UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.active.start"), UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"), animationPercent);
                    GraphicsUtil.getInterpolatedColor(ToolWindowRepresentativeAnchorUI.this.flashingAnimBackEnd, UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.active.end"), UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"), animationPercent);
                }
            }
            SwingUtil.repaint(ToolWindowRepresentativeAnchorUI.this.representativeAnchor);
            return animationPercent;
        }

        protected void onFinishAnimation() {
            switch (this.getAnimationDirection()) {
                case INCOMING: {
                    ToolWindowRepresentativeAnchorUI.this.flashingAnimBackStart.setRGB(UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"));
                    break;
                }
                case OUTGOING: {
                    ToolWindowRepresentativeAnchorUI.this.flashingAnimBackStart.setRGB(UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.active.start"));
                }
            }
            SwingUtil.repaint(ToolWindowRepresentativeAnchorUI.this.representativeAnchor);
        }

        protected void onHide(Object ... params) {
            ToolWindowRepresentativeAnchorUI.this.flashingAnimBackStart.setRGB(UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.active.start"));
            ToolWindowRepresentativeAnchorUI.this.flashingAnimBackEnd.setRGB(UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.active.end"));
        }

        protected void onShow(Object ... params) {
            ToolWindowRepresentativeAnchorUI.this.flashingAnimBackStart.setRGB(UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"));
            ToolWindowRepresentativeAnchorUI.this.flashingAnimBackEnd.setRGB(UIManager.getColor("ToolWindowRepresentativeAnchorUI.background.inactive"));
        }

        protected void onStartAnimation(AbstractAnimation.Direction direction) {
        }

        protected AbstractAnimation.Direction chooseFinishDirection(AbstractAnimation.Type type) {
            return type == AbstractAnimation.Type.SHOW ? AbstractAnimation.Direction.OUTGOING : AbstractAnimation.Direction.INCOMING;
        }
    }
}

