/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.look;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.DockableManagerListener;
import org.noos.xing.mydoggy.event.DockableManagerEvent;
import org.noos.xing.mydoggy.plaf.ui.cmp.DockablePanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.border.LineBorder;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class DockablePanelUI
extends BasicPanelUI
implements PropertyChangeListener,
ActionListener,
DockableManagerListener {
    protected static Border FLASHING_BORDER = new LineBorder(Color.RED, 3);
    protected DockablePanel dockablePanel;
    protected Dockable dockable;
    protected boolean flashingEnabled;
    protected Timer flashingTimer;
    protected int flashingDuration = -1;
    protected boolean flashingState;
    protected Border flashingBorder;
    protected long startingTime = 0L;
    protected int flashingInterval = 500;

    public static ComponentUI createUI(JComponent c) {
        return new DockablePanelUI();
    }

    public void installUI(JComponent c) {
        this.dockablePanel = (DockablePanel)c;
        this.dockable = this.dockablePanel.getDockable();
        this.flashingEnabled = this.dockable instanceof Content;
        super.installUI(c);
        this.installListeners();
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallListeners();
        this.dockablePanel = null;
        this.dockable = null;
    }

    protected void installDefaults(JPanel p) {
        super.installDefaults(p);
        LookAndFeel.installColorsAndFont(p, "DockablePanelUI.background", "DockablePanelUI.foreground", "DockablePanelUI.font");
        LookAndFeel.installBorder(p, "DockablePanelUI.border");
        this.flashingBorder = SwingUtil.getBorder("DockablePanelUI.border.flashing", FLASHING_BORDER);
    }

    protected void installListeners() {
        this.dockable.addPropertyChangeListener((PropertyChangeListener)this);
        this.dockable.getDockableManager().addDockableManagerListener((DockableManagerListener)this);
    }

    protected void uninstallListeners() {
        this.dockable.removePropertyChangeListener((PropertyChangeListener)this);
        this.dockable.getDockableManager().removeDockableManagerListener((DockableManagerListener)this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("flash".equals(propertyName)) {
            if (!this.flashingEnabled) {
                return;
            }
            if (evt.getNewValue() == Boolean.TRUE) {
                if (!this.dockable.isSelected()) {
                    this.dockablePanel.putClientProperty("oldBorder", this.dockablePanel.getBorder());
                    this.flashingDuration = SwingUtil.getInt(evt, -1);
                    this.flashingTimer = new Timer(this.flashingInterval, this);
                    this.flashingTimer.start();
                }
            } else if (this.flashingTimer != null) {
                this.flashingTimer.stop();
                this.flashingTimer = null;
                this.dockablePanel.setBorder((Border)this.dockablePanel.getClientProperty("oldBorder"));
            }
        } else if ("selected".equals(propertyName) && evt.getNewValue() == Boolean.TRUE) {
            this.dockable.setFlashing(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.startingTime == 0L) {
            this.startingTime = System.currentTimeMillis();
        }
        boolean bl = this.flashingState = !this.flashingState;
        if (this.flashingState) {
            this.dockablePanel.setBorder(this.flashingBorder);
        } else {
            this.dockablePanel.setBorder((Border)this.dockablePanel.getClientProperty("oldBorder"));
        }
        if (this.flashingDuration != -1 && System.currentTimeMillis() - this.startingTime > (long)this.flashingDuration) {
            this.dockable.setFlashing(false);
        }
    }

    public void dockableAdded(DockableManagerEvent event) {
    }

    public void dockableRemoved(DockableManagerEvent event) {
        if (event.getDockable() == this.dockable) {
            if (this.flashingTimer != null) {
                this.flashingTimer.stop();
            }
            this.uninstallUI(this.dockablePanel);
        }
    }
}

