/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.look;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.plaf.ui.cmp.DockableDropPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.DockableOwner;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiDockableOwner;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitWindow;
import org.noos.xing.mydoggy.plaf.ui.drag.MyDoggyTransferable;
import org.noos.xing.mydoggy.plaf.ui.util.GraphicsUtil;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class DockableDropPanelUI
extends BasicPanelUI {
    protected DockableDropPanel dockableDropPanel;
    protected TableLayout layout;
    protected int threshold;
    protected Point mouseLocation;
    protected boolean dragActive;
    protected MultiDockableOwner oldMultiDockableOwner;
    protected Component onDockableContainer;
    protected ToolWindowAnchor onAnchor;
    protected Dockable onDockable;
    protected Dockable refDockable;
    protected int onIndex;

    public static ComponentUI createUI(JComponent c) {
        return new DockableDropPanelUI();
    }

    public void installUI(JComponent c) {
        this.dockableDropPanel = (DockableDropPanel)c;
        super.installUI(c);
        this.updateComponent();
        this.installListeners(c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallListeners(c);
        this.layout = null;
        this.dockableDropPanel = null;
    }

    protected void installDefaults(JPanel p) {
        super.installDefaults(p);
        p.setOpaque(false);
        this.layout = new TableLayout((double[][])new double[][]{{0.0, -1.0, 0.0}, {0.0, -1.0, 0.0}});
        this.dockableDropPanel.setLayout((LayoutManager)this.layout);
        this.threshold = this.dockableDropPanel.getThreshold();
    }

    protected void installListeners(JComponent c) {
    }

    protected void uninstallListeners(JComponent c) {
    }

    public void update(Graphics g, JComponent c) {
        this.onDockable = null;
        this.onDockableContainer = null;
        this.onIndex = -1;
        if (this.dragActive && this.mouseLocation != null) {
            int xLimit = this.threshold;
            int yLimit = this.threshold;
            if (this.mouseLocation.x <= xLimit && this.mouseLocation.y > yLimit && this.mouseLocation.y < c.getHeight() - yLimit) {
                this.layout.setColumn(0, (double)xLimit);
                this.layout.setColumn(2, 0.0);
                this.layout.setRow(0, 0.0);
                this.layout.setRow(2, 0.0);
                this.drawRect(g, 0, 0, 20, c.getHeight());
                this.onAnchor = ToolWindowAnchor.LEFT;
            } else if (this.mouseLocation.y <= yLimit && this.mouseLocation.x > xLimit && this.mouseLocation.x < c.getWidth() - xLimit) {
                this.layout.setColumn(0, 0.0);
                this.layout.setColumn(2, 0.0);
                this.layout.setRow(0, 20.0);
                this.layout.setRow(2, 0.0);
                this.drawRect(g, 0, 0, c.getWidth(), 20);
                this.onAnchor = ToolWindowAnchor.TOP;
            } else if (this.mouseLocation.x >= c.getWidth() - xLimit && this.mouseLocation.y > yLimit && this.mouseLocation.y < c.getHeight() - yLimit) {
                this.layout.setColumn(0, 0.0);
                this.layout.setColumn(2, 20.0);
                this.layout.setRow(0, 0.0);
                this.layout.setRow(2, 0.0);
                this.drawRect(g, c.getWidth() - 20, 0, 20, c.getHeight());
                this.onAnchor = ToolWindowAnchor.RIGHT;
            } else if (this.mouseLocation.y >= c.getHeight() - yLimit && this.mouseLocation.x > xLimit && this.mouseLocation.x < c.getWidth() - xLimit) {
                this.layout.setColumn(0, 0.0);
                this.layout.setColumn(2, 0.0);
                this.layout.setRow(0, 0.0);
                this.layout.setRow(2, 20.0);
                this.drawRect(g, 0, c.getHeight() - 20, c.getWidth(), 20);
                this.onAnchor = ToolWindowAnchor.BOTTOM;
            } else {
                this.resetLayout();
                Component deepestCmp = SwingUtilities.getDeepestComponentAt(c, this.mouseLocation.x, this.mouseLocation.y);
                if (deepestCmp != null) {
                    this.onDockableContainer = (Component)((Object)SwingUtil.getParent(deepestCmp, DockableOwner.class));
                    if (this.onDockableContainer != null) {
                        if (this.onDockableContainer instanceof MultiDockableOwner) {
                            MultiDockableOwner multiDockableOwner = (MultiDockableOwner)((Object)this.onDockableContainer);
                            if (this.oldMultiDockableOwner != null && this.oldMultiDockableOwner != multiDockableOwner) {
                                this.oldMultiDockableOwner.setPointerVisible(false);
                            }
                            this.onIndex = multiDockableOwner.getDockableIndex(this.mouseLocation);
                            this.onDockable = multiDockableOwner.getDockable(this.onIndex);
                            multiDockableOwner.setPointerVisible(true);
                            this.oldMultiDockableOwner = multiDockableOwner;
                        } else if (this.onDockableContainer instanceof DockableOwner) {
                            this.onDockable = ((DockableOwner)((Object)this.onDockableContainer)).getDockable();
                            Component tmp = (Component)((Object)SwingUtil.getParent(deepestCmp, MultiDockableOwner.class));
                            if (tmp != null) {
                                this.onDockableContainer = tmp;
                            }
                        } else {
                            throw new IllegalStateException("Dockable Container not reconized!!!");
                        }
                        if (this.onDockable == null) {
                            MultiSplitWindow multiSplitWindow = SwingUtil.getParent(deepestCmp, MultiSplitWindow.class);
                            if (multiSplitWindow != null) {
                                this.refDockable = multiSplitWindow.getDockable();
                            }
                        } else {
                            this.refDockable = null;
                        }
                        Rectangle toolBounds = this.onDockableContainer.getBounds();
                        Point point = SwingUtilities.convertPoint(this.onDockableContainer, new Point(0, 0), c);
                        toolBounds.x = point.x;
                        toolBounds.y = point.y;
                        xLimit = toolBounds.width / 3;
                        yLimit = toolBounds.height / 3;
                        Point inToolLocation = SwingUtilities.convertPoint(c, this.mouseLocation, this.onDockableContainer);
                        if (inToolLocation.x <= xLimit && inToolLocation.y > yLimit && inToolLocation.y < toolBounds.height - yLimit) {
                            this.drawRect(g, toolBounds.x, toolBounds.y, xLimit, toolBounds.height);
                            this.onAnchor = ToolWindowAnchor.LEFT;
                        } else if (inToolLocation.y <= yLimit && inToolLocation.x > xLimit && inToolLocation.x < toolBounds.width - xLimit) {
                            this.drawRect(g, toolBounds.x, toolBounds.y, toolBounds.width, yLimit);
                            this.onAnchor = ToolWindowAnchor.TOP;
                        } else if (inToolLocation.x >= toolBounds.width - xLimit && inToolLocation.y > yLimit && inToolLocation.y < toolBounds.height - yLimit) {
                            this.drawRect(g, toolBounds.x + toolBounds.width - xLimit, toolBounds.y, xLimit, toolBounds.height);
                            this.onAnchor = ToolWindowAnchor.RIGHT;
                        } else if (inToolLocation.y >= toolBounds.height - yLimit && inToolLocation.x > xLimit && inToolLocation.x < toolBounds.width - xLimit) {
                            this.layout.setColumn(0, 0.0);
                            this.drawRect(g, toolBounds.x, toolBounds.y + toolBounds.height - yLimit, toolBounds.width, yLimit);
                            this.onAnchor = ToolWindowAnchor.BOTTOM;
                        } else {
                            this.drawRect(g, toolBounds.x, toolBounds.y, toolBounds.width, toolBounds.height);
                            this.onAnchor = null;
                        }
                    }
                }
            }
        }
    }

    public Component getComponent() {
        return this.dockableDropPanel.getComponentCount() == 0 ? null : this.dockableDropPanel.getComponent(0);
    }

    public void setComponent(Component component) {
        this.dockableDropPanel.removeAll();
        this.dockableDropPanel.add(component, "1,1,FULL,FULL");
    }

    public void updateComponent() {
        this.dockableDropPanel.removeAll();
        if (this.dockableDropPanel.getComponent() != null) {
            this.dockableDropPanel.add(this.dockableDropPanel.getComponent(), "1,1,FULL,FULL");
        }
    }

    public void resetComponent() {
        this.dockableDropPanel.removeAll();
        this.resetLayout();
    }

    public void dragExit() {
        this.mouseLocation = null;
        this.resetLayout();
        if (this.oldMultiDockableOwner != null) {
            this.oldMultiDockableOwner.setPointerVisible(false);
        }
        SwingUtil.repaint(this.dockableDropPanel);
    }

    public boolean dragStart(Transferable transferable) {
        this.dragActive = false;
        for (Class<? extends Dockable> clazz : this.dockableDropPanel.getTargets()) {
            if (clazz.isAssignableFrom(ToolWindow.class)) {
                if (!transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_ID_DF)) continue;
                this.dragActive = true;
                break;
            }
            if (clazz.isAssignableFrom(ToolWindowTab.class)) {
                if (!transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_TAB_ID_DF)) continue;
                this.dragActive = true;
                break;
            }
            if (!clazz.isAssignableFrom(Content.class) || !transferable.isDataFlavorSupported(MyDoggyTransferable.CONTENT_ID_DF)) continue;
            this.dragActive = true;
            break;
        }
        if (this.dragActive) {
            SwingUtil.repaint(this.dockableDropPanel);
        }
        return this.dragActive;
    }

    public void dragOver(Point location) {
        this.mouseLocation = location;
        SwingUtil.repaint(this.dockableDropPanel);
    }

    public void dragEnd() {
        this.mouseLocation = null;
        this.dragActive = false;
        this.resetLayout();
        if (this.oldMultiDockableOwner != null) {
            this.oldMultiDockableOwner.setPointerVisible(false);
        }
        SwingUtil.repaint(this.dockableDropPanel);
    }

    public Component getOnDockableContainer() {
        return this.onDockableContainer;
    }

    public Dockable getOnDockable() {
        return this.onDockable;
    }

    public ToolWindowAnchor getOnAnchor() {
        return this.onAnchor;
    }

    public int getOnIndex() {
        return this.onIndex;
    }

    public Dockable getRefDockable() {
        return this.refDockable;
    }

    protected void drawRect(Graphics g, int x, int y, int width, int height) {
        g.setColor(Color.BLUE);
        GraphicsUtil.fillRoundRect(g, x, y, width, height, 3, 10, 10, 0.25f);
    }

    protected void putProperty(JComponent c, String name) {
        Boolean value = (Boolean)c.getClientProperty(name);
        if (value != null) {
            c.putClientProperty(name, value == false);
        } else {
            c.putClientProperty(name, false);
        }
    }

    protected void resetLayout() {
        this.layout.setColumn(0, 0.0);
        this.layout.setColumn(2, 0.0);
        this.layout.setRow(0, 0.0);
        this.layout.setRow(2, 0.0);
    }
}

