/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.content;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentManagerUI;
import org.noos.xing.mydoggy.ContentManagerUIListener;
import org.noos.xing.mydoggy.ContentUI;
import org.noos.xing.mydoggy.DesktopContentManagerUI;
import org.noos.xing.mydoggy.DesktopContentUI;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.PersistenceDelegate;
import org.noos.xing.mydoggy.PersistenceDelegateFilter;
import org.noos.xing.mydoggy.ToolWindowManager;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.ui.DockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentDesktopManager;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentDialog;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentFrame;
import org.noos.xing.mydoggy.plaf.ui.content.MyDoggyContentManagerUI;
import org.noos.xing.mydoggy.plaf.ui.content.MyDoggyDesktopContentUI;
import org.noos.xing.mydoggy.plaf.ui.content.PlafContent;
import org.noos.xing.mydoggy.plaf.ui.content.PlafContentManagerUI;
import org.noos.xing.mydoggy.plaf.ui.content.action.NextContentAction;
import org.noos.xing.mydoggy.plaf.ui.content.action.PreviousContentAction;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyDoggyDesktopContentManagerUI
extends MyDoggyContentManagerUI<DesktopContentUI>
implements DesktopContentManagerUI,
PlafContentManagerUI {
    protected JDesktopPane desktopPane;
    protected int contentIndex = 0;
    protected JPopupMenu popupMenu;

    public MyDoggyDesktopContentManagerUI() {
        this.setContentManagerUI((ContentManagerUI)this);
    }

    @Override
    public PlafContentManagerUI install(ContentManagerUI oldContentManagerUI, ToolWindowManager manager) {
        this.toolWindowManager = (MyDoggyToolWindowManager)manager;
        this.contentManager = manager.getContentManager();
        this.resourceManager = this.toolWindowManager.getResourceManager();
        this.contentIndex = 0;
        if (oldContentManagerUI != null) {
            this.closeable = oldContentManagerUI.isCloseable();
            this.detachable = oldContentManagerUI.isDetachable();
            this.minimizable = oldContentManagerUI.isMinimizable();
        }
        this.setPopupMenu(this.contentManager.getPopupMenu());
        this.initComponents();
        this.initListeners();
        this.toolWindowManager.setMainContent(this.desktopPane);
        this.lastSelected = null;
        Content selectedContent = null;
        this.contentValueAdjusting = true;
        for (Content content : this.contentManager.getContents()) {
            if (content.isSelected()) {
                selectedContent = content;
            }
            this.addContent((PlafContent)content, new Object[0]);
        }
        this.contentValueAdjusting = false;
        if (oldContentManagerUI != null && SwingUtil.getBoolean("ContentManagerUI.ContentManagerUiListener.import", false)) {
            for (Content content : oldContentManagerUI.getContentManagerUiListener()) {
                oldContentManagerUI.removeContentManagerUIListener((ContentManagerUIListener)content);
                this.addContentManagerUIListener((ContentManagerUIListener)content);
            }
        }
        this.installed = true;
        if (oldContentManagerUI != null) {
            final Content selectedContent1 = selectedContent;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (selectedContent1 != null) {
                        selectedContent1.setSelected(true);
                    } else if (MyDoggyDesktopContentManagerUI.this.contentManager.getContentCount() > 0) {
                        MyDoggyDesktopContentManagerUI.this.contentManager.getContent(0).setSelected(true);
                    }
                }
            });
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstall() {
        this.uninstalling = true;
        try {
            if (this.maximizedContent != null) {
                this.maximizedContent.setMaximized(false);
            }
            this.contentValueAdjusting = true;
            for (Content content : this.contentManager.getContents()) {
                this.removeContent((PlafContent)content);
            }
            this.contentValueAdjusting = false;
            this.installed = false;
            Object var6_5 = null;
            this.uninstalling = false;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.uninstalling = false;
            throw throwable;
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    @Override
    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void setSelected(Content content, boolean selected) {
        if (selected) {
            if (this.lastSelected != null) {
                this.lastSelected.setSelected(false);
            }
            if (content.isMinimized()) {
                content.setMinimized(false);
                content.setSelected(true);
                return;
            } else if (content.isDetached()) {
                Window window = SwingUtilities.windowForComponent(content.getComponent());
                window.toFront();
                SwingUtil.requestFocus(window);
                return;
            } else {
                JInternalFrame internalFrame = this.getInternalFrame(content);
                if (internalFrame == null) throw new IllegalStateException("Invalid content ui state.");
                try {
                    this.valueAdjusting = true;
                    internalFrame.setSelected(selected);
                    this.lastSelected = content == this.lastSelected ? null : content;
                    this.valueAdjusting = false;
                    return;
                }
                catch (PropertyVetoException e) {
                    e.printStackTrace();
                }
            }
            return;
        } else {
            if (content != this.lastSelected) return;
            this.lastSelected = null;
        }
    }

    @Override
    public void updateUI() {
        this.desktopPane.updateUI();
    }

    @Override
    public void selectNextContent(Content content) {
    }

    protected void initComponents() {
        if (this.desktopPane == null) {
            this.desktopPane = new JDesktopPane();
            this.desktopPane.setDesktopManager(new ContentDesktopManager());
            this.desktopPane.setBackground(Color.GRAY);
            this.setupActions();
        }
    }

    protected void initListeners() {
        if (this.internalPropertyChangeSupport == null) {
            this.internalPropertyChangeSupport = new PropertyChangeSupport(this);
            this.internalPropertyChangeSupport.addPropertyChangeListener("component", new ComponentListener());
            this.internalPropertyChangeSupport.addPropertyChangeListener("disabledIcon", new DisabledIconListener());
            this.internalPropertyChangeSupport.addPropertyChangeListener("icon", new IconListener());
            this.internalPropertyChangeSupport.addPropertyChangeListener("enabled", new EnabledListener());
            this.internalPropertyChangeSupport.addPropertyChangeListener("foreground", new ForegroundListener());
            this.internalPropertyChangeSupport.addPropertyChangeListener("popupMenu", new PopupMenuListener());
            this.internalPropertyChangeSupport.addPropertyChangeListener("title", new TitleListener());
            this.internalPropertyChangeSupport.addPropertyChangeListener("toolTipText", new ToolTipTextListener());
            DetachedListener detachedListener = new DetachedListener();
            this.internalPropertyChangeSupport.addPropertyChangeListener("detached.dispose", detachedListener);
            this.internalPropertyChangeSupport.addPropertyChangeListener("detached", detachedListener);
            MaximizedListener maximizedListener = new MaximizedListener();
            this.internalPropertyChangeSupport.addPropertyChangeListener("maximizedBefore", maximizedListener);
            this.internalPropertyChangeSupport.addPropertyChangeListener("maximized", maximizedListener);
            this.internalPropertyChangeSupport.addPropertyChangeListener("minimized", new MinimizedListener());
            this.desktopPane.addMouseListener(new PopupMouseListener());
        }
    }

    protected void setupActions() {
        SwingUtil.addKeyActionMapping(1, this.desktopPane, KeyStroke.getKeyStroke(39, 8), "nextContent", new NextContentAction(this.toolWindowManager));
        SwingUtil.addKeyActionMapping(1, this.desktopPane, KeyStroke.getKeyStroke(37, 8), "previousContent", new PreviousContentAction(this.toolWindowManager));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object addUIForContent(Content content, Object ... constraints) {
        JInternalFrame internalFrame;
        DesktopContentUI desktopContentUI = (DesktopContentUI)this.contentUIMap.get(content);
        if (desktopContentUI == null) {
            MyDoggyDesktopContentUI myDoggyDesktopContentUI = new MyDoggyDesktopContentUI(this.contentManager, (ContentManagerUI)this, content);
            internalFrame = myDoggyDesktopContentUI.getInternalFrame();
            if (constraints.length > 0) {
                if (constraints[0] instanceof Point) {
                    Point location = (Point)constraints[0];
                    Dimension prefferedSize = content.getComponent().getPreferredSize();
                    internalFrame.setBounds(location.x, location.y, prefferedSize.width > 0 ? prefferedSize.width : 320, prefferedSize.height > 0 ? prefferedSize.height : 200);
                } else if (constraints[0] instanceof Rectangle) {
                    internalFrame.setBounds((Rectangle)constraints[0]);
                } else {
                    constraints = null;
                }
            }
            if (constraints == null || constraints.length == 0) {
                int height;
                int contentX;
                int contentY = contentX = 10 + this.contentIndex++ * 25;
                Dimension prefferedSize = content.getComponent().getPreferredSize();
                int width = prefferedSize.width > 0 ? prefferedSize.width : 320;
                int n = height = prefferedSize.height > 0 ? prefferedSize.height : 200;
                if (contentX > this.desktopPane.getWidth() - width || contentY > this.desktopPane.getHeight() - height) {
                    this.contentIndex = 0;
                    contentX = 10;
                    contentY = 10;
                }
                internalFrame.setBounds(contentX, contentY, width, height);
            }
            this.contentUIMap.put(content, myDoggyDesktopContentUI);
        } else {
            internalFrame = ((MyDoggyDesktopContentUI)desktopContentUI).getInternalFrame();
            internalFrame.getContentPane().add(content.getComponent());
        }
        this.desktopPane.add(internalFrame);
        this.contentValueAdjusting = true;
        try {
            internalFrame.show();
            internalFrame.toFront();
            Object var12_14 = null;
            this.contentValueAdjusting = false;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            this.contentValueAdjusting = false;
            throw throwable;
        }
        if (content.isSelected()) {
            try {
                internalFrame.setSelected(true);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeUIForContent(Content content) {
        MyDoggyDesktopContentUI desktopContentUI = (MyDoggyDesktopContentUI)content.getContentUI();
        JInternalFrame internalFrame = desktopContentUI.getInternalFrame();
        this.valueAdjusting = true;
        try {
            internalFrame.removePropertyChangeListener(this.contentUIListener);
            this.desktopPane.remove(internalFrame);
            desktopContentUI.cleanup();
            Object var5_4 = null;
            this.valueAdjusting = false;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.valueAdjusting = false;
            throw throwable;
        }
    }

    protected JInternalFrame getInternalFrame(Content content) {
        return ((MyDoggyDesktopContentUI)content.getContentUI()).getInternalFrame();
    }

    public class PopupMouseListener
    extends MouseAdapter
    implements ActionListener {
        protected JPopupMenu popupMenu = new JPopupMenu();

        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) && MyDoggyDesktopContentManagerUI.this.isPopupMenuEnabled()) {
                this.popupMenu.removeAll();
                for (Content content : MyDoggyDesktopContentManagerUI.this.contentManager.getContents()) {
                    JMenuItem maximize;
                    JMenu menu = new JMenu(content.getTitle());
                    JMenuItem detach = new JMenuItem(SwingUtil.getString("@@tab.content.detach"));
                    detach.putClientProperty(Content.class, content);
                    detach.setActionCommand("Detach");
                    detach.addActionListener(this);
                    detach.setEnabled(((DesktopContentUI)MyDoggyDesktopContentManagerUI.this.getContentUI(content)).isDetachable() && !content.isDetached());
                    menu.add(detach);
                    ContentUI contentUI = content.getContentUI();
                    if (content.isMaximized() || content.isMinimized()) {
                        maximize = new JMenuItem();
                        maximize.putClientProperty(Content.class, content);
                        maximize.setActionCommand(content.isMaximized() ? "Maximize" : "Minimize");
                        maximize.setText(SwingUtil.getString("@@tabbed.page.restore"));
                        maximize.addActionListener(this);
                        menu.add(maximize);
                    } else {
                        if (contentUI.isMaximizable()) {
                            maximize = new JMenuItem();
                            maximize.putClientProperty(Content.class, content);
                            maximize.setActionCommand("Maximize");
                            maximize.setText(SwingUtil.getString("@@tabbed.page.maximize"));
                            maximize.addActionListener(this);
                            menu.add(maximize);
                        }
                        if (contentUI.isMinimizable()) {
                            JMenuItem minimize = new JMenuItem();
                            minimize.putClientProperty(Content.class, content);
                            minimize.setActionCommand("Minimize");
                            minimize.setText(SwingUtil.getString("@@tabbed.page.minimize"));
                            minimize.addActionListener(this);
                            minimize.setEnabled(((DesktopContentUI)MyDoggyDesktopContentManagerUI.this.getContentUI(content)).isMinimizable() && !content.isMinimized());
                            menu.add(minimize);
                        }
                    }
                    this.popupMenu.add(menu);
                }
                this.popupMenu.show(MyDoggyDesktopContentManagerUI.this.desktopPane, e.getX(), e.getY());
            }
        }

        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            if ("Detach".equals(actionCommand)) {
                JComponent c = (JComponent)e.getSource();
                Content content = (Content)c.getClientProperty(Content.class);
                content.setDetached(true);
                MyDoggyDesktopContentManagerUI.this.fireContentUIDetached((ContentUI)MyDoggyDesktopContentManagerUI.this.getContentUI(content));
            } else if ("Maximize".equals(actionCommand)) {
                Content content;
                JComponent c = (JComponent)e.getSource();
                content.setMaximized(!(content = (Content)c.getClientProperty(Content.class)).isMaximized());
            } else if ("Minimize".equals(actionCommand)) {
                Content content;
                JComponent c = (JComponent)e.getSource();
                content.setMinimized(!(content = (Content)c.getClientProperty(Content.class)).isMinimized());
            }
        }
    }

    public class DetachedListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            Content content = (Content)evt.getSource();
            if ("detached.dispose".equals(evt.getPropertyName())) {
                Window window = SwingUtilities.windowForComponent(content.getComponent());
                window.setVisible(false);
                window.dispose();
            } else if (((Boolean)evt.getNewValue()).booleanValue()) {
                Object contentUI = MyDoggyDesktopContentManagerUI.this.getContentUI(content);
                JInternalFrame internalFrame = MyDoggyDesktopContentManagerUI.this.getInternalFrame(content);
                if (internalFrame == null) {
                    throw new IllegalStateException("Invalid Content : " + content);
                }
                Rectangle inBounds = MyDoggyDesktopContentManagerUI.this.toolWindowManager.getBoundsToScreen(internalFrame.getBounds(), MyDoggyDesktopContentManagerUI.this.desktopPane);
                MyDoggyDesktopContentManagerUI.this.desktopPane.remove(internalFrame);
                Frame parentFrame = MyDoggyDesktopContentManagerUI.this.toolWindowManager.getWindowAncestor() instanceof Frame ? (Frame)MyDoggyDesktopContentManagerUI.this.toolWindowManager.getWindowAncestor() : null;
                Window dialog = contentUI.isAddToTaskBarWhenDetached() ? new ContentFrame(content, (ContentUI)contentUI, parentFrame, inBounds) : new ContentDialog(content, (ContentUI)contentUI, parentFrame, inBounds);
                dialog.addWindowFocusListener(new MyDoggyContentManagerUI.ContentDialogFocusListener(MyDoggyDesktopContentManagerUI.this, content));
                dialog.toFront();
                dialog.setVisible(true);
                SwingUtil.repaint(MyDoggyDesktopContentManagerUI.this.desktopPane);
                SwingUtil.requestFocus(dialog);
            } else {
                Window window = SwingUtilities.windowForComponent(content.getComponent());
                window.setVisible(false);
                window.dispose();
                MyDoggyDesktopContentManagerUI.this.addUIForContent(content, new Object[0]);
                content.setSelected(true);
            }
        }
    }

    public class MinimizedListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            Content content = (Content)evt.getSource();
            if (((Boolean)evt.getNewValue()).booleanValue()) {
                JInternalFrame internalFrame;
                content.setSelected(false);
                content.setMaximized(false);
                DockableDescriptor descriptor = MyDoggyDesktopContentManagerUI.this.toolWindowManager.getDockableDescriptor(content.getId());
                if (descriptor == null) {
                    descriptor = MyDoggyDesktopContentManagerUI.this.toolWindowManager.createDescriptor((Dockable)content);
                }
                if ((internalFrame = MyDoggyDesktopContentManagerUI.this.getInternalFrame(content)) == null) {
                    throw new IllegalStateException("Invalid Content : " + content);
                }
                MyDoggyDesktopContentManagerUI.this.desktopPane.remove(internalFrame);
                descriptor.setAvailable(true);
                SwingUtil.repaint(MyDoggyDesktopContentManagerUI.this.desktopPane);
            } else {
                DockableDescriptor descriptor = MyDoggyDesktopContentManagerUI.this.toolWindowManager.getDockableDescriptor(content.getId());
                descriptor.setAvailable(false);
                MyDoggyDesktopContentManagerUI.this.addUIForContent(content, new Object[0]);
                content.setSelected(true);
            }
        }
    }

    public class MaximizedListener
    implements PropertyChangeListener {
        protected ByteArrayOutputStream tmpWorkspace;
        protected Component oldFucusOwner;

        public void propertyChange(PropertyChangeEvent evt) {
            Content content = (Content)evt.getSource();
            if ("maximizedBefore".equals(evt.getPropertyName())) {
                if (((Boolean)evt.getNewValue()).booleanValue()) {
                    this.tmpWorkspace = new ByteArrayOutputStream();
                    MyDoggyDesktopContentManagerUI.this.toolWindowManager.getPersistenceDelegate().save((OutputStream)this.tmpWorkspace, (PersistenceDelegateFilter)new MyDoggyContentManagerUI.ContentManagerUIPersistenceDelegateFilter(MyDoggyDesktopContentManagerUI.this));
                    MyDoggyDesktopContentManagerUI.this.toolWindowManager.getToolWindowGroup().setVisible(false);
                    this.oldFucusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    try {
                        ((MyDoggyDesktopContentUI)MyDoggyDesktopContentManagerUI.this.getContentUI(content)).getInternalFrame().setMaximum(true);
                    }
                    catch (PropertyVetoException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
            } else if (!((Boolean)evt.getNewValue()).booleanValue() && this.tmpWorkspace != null) {
                MyDoggyDesktopContentManagerUI.this.toolWindowManager.getPersistenceDelegate().merge((InputStream)new ByteArrayInputStream(this.tmpWorkspace.toByteArray()), MyDoggyDesktopContentManagerUI.this.resourceManager.getObject(PersistenceDelegate.MergePolicy.class, PersistenceDelegate.MergePolicy.UNION));
                try {
                    ((MyDoggyDesktopContentUI)MyDoggyDesktopContentManagerUI.this.getContentUI(content)).getInternalFrame().setMaximum(false);
                }
                catch (PropertyVetoException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                this.tmpWorkspace = null;
                if (this.oldFucusOwner != null) {
                    SwingUtil.requestFocus(this.oldFucusOwner);
                    this.oldFucusOwner = null;
                }
            }
        }
    }

    public class ToolTipTextListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            Content content = (Content)evt.getSource();
            if (content.isMinimized()) {
                return;
            }
            if (!content.isDetached()) {
                JInternalFrame internalFrame = MyDoggyDesktopContentManagerUI.this.getInternalFrame(content);
                if (internalFrame != null) {
                    internalFrame.setToolTipText((String)evt.getNewValue());
                } else {
                    throw new IllegalStateException("Invalid content ui state.");
                }
            }
        }
    }

    public class TitleListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            Content content = (Content)evt.getSource();
            if (content.isMinimized()) {
                return;
            }
            if (content.isDetached()) {
                SwingUtil.setWindowTitle(content.getComponent(), (String)evt.getNewValue());
            } else {
                JInternalFrame internalFrame = MyDoggyDesktopContentManagerUI.this.getInternalFrame(content);
                if (internalFrame != null) {
                    internalFrame.setTitle((String)evt.getNewValue());
                } else {
                    throw new IllegalStateException("Invalid content ui state.");
                }
            }
        }
    }

    public class PopupMenuListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            Content content = (Content)evt.getSource();
            if (content.isMinimized()) {
                return;
            }
            if (!content.isDetached()) {
                JInternalFrame internalFrame = MyDoggyDesktopContentManagerUI.this.getInternalFrame(content);
                if (internalFrame != null) {
                    internalFrame.setComponentPopupMenu((JPopupMenu)evt.getNewValue());
                } else {
                    throw new IllegalStateException("Invalid content ui state.");
                }
            }
        }
    }

    public class ForegroundListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            Content content = (Content)evt.getSource();
            if (content.isMinimized()) {
                return;
            }
            if (!content.isDetached()) {
                JInternalFrame internalFrame = MyDoggyDesktopContentManagerUI.this.getInternalFrame(content);
                if (internalFrame != null) {
                    internalFrame.setForeground((Color)evt.getNewValue());
                } else {
                    throw new IllegalStateException("Invalid content ui state.");
                }
            }
        }
    }

    public class EnabledListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            Content content = (Content)evt.getSource();
            if (content.isMinimized()) {
                return;
            }
            if (!content.isDetached()) {
                JInternalFrame internalFrame = MyDoggyDesktopContentManagerUI.this.getInternalFrame(content);
                if (internalFrame != null) {
                    internalFrame.setEnabled((Boolean)evt.getNewValue());
                } else {
                    throw new IllegalStateException("Invalid content ui state.");
                }
            }
        }
    }

    public class IconListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            Content content = (Content)evt.getSource();
            if (content.isMinimized()) {
                return;
            }
            if (!content.isDetached()) {
                JInternalFrame internalFrame = MyDoggyDesktopContentManagerUI.this.getInternalFrame(content);
                if (internalFrame != null) {
                    internalFrame.setFrameIcon((Icon)evt.getNewValue());
                } else {
                    throw new IllegalStateException("Invalid content ui state.");
                }
            }
        }
    }

    public class DisabledIconListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
        }
    }

    public class ComponentListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            Content content = (Content)evt.getSource();
            if (content.isMinimized()) {
                return;
            }
            if (content.isDetached()) {
                RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)SwingUtilities.windowForComponent(content.getComponent()));
                Container container = rootPaneContainer.getContentPane();
                container.removeAll();
                container.add((Component)evt.getNewValue());
            } else {
                JInternalFrame internalFrame = MyDoggyDesktopContentManagerUI.this.getInternalFrame(content);
                if (internalFrame != null) {
                    Container container = internalFrame.getContentPane();
                    container.removeAll();
                    container.add((Component)evt.getNewValue());
                } else {
                    throw new IllegalStateException("Invalid content ui state.");
                }
            }
        }
    }
}

