/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp.event;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowBar;
import org.noos.xing.mydoggy.ToolWindowManager;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class ToolsOnBarMouseListener
extends MouseAdapter
implements ActionListener {
    protected ToolWindowManager toolWindowManager;
    protected ToolWindowBar toolWindowBar;
    protected ToolWindowAnchor anchor;
    protected JPopupMenu popupMenu;

    public ToolsOnBarMouseListener(ToolWindowManager toolWindowManager, ToolWindowBar toolWindowBar) {
        this.toolWindowManager = toolWindowManager;
        this.toolWindowBar = toolWindowBar;
        this.anchor = toolWindowBar.getAnchor();
    }

    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            if (this.toolWindowBar.getPopupMenu() != null) {
                this.toolWindowBar.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
            } else {
                this.initPopupMenu();
                this.popupMenu.removeAll();
                ToolWindow[] tools = this.toolWindowManager.getToolsByAnchor(this.anchor);
                if (tools.length > 0) {
                    for (ToolWindow tool : tools) {
                        if (!tool.isAvailable()) continue;
                        JMenuItem showTool = new JMenuItem();
                        showTool.setText(SwingUtil.getUserString(tool.getRepresentativeAnchorDescriptor().getTitle()));
                        showTool.setActionCommand("tool.visible." + tool.getId());
                        showTool.addActionListener(this);
                        this.popupMenu.add(showTool);
                    }
                    if (this.popupMenu.getComponentCount() > 0) {
                        this.popupMenu.addSeparator();
                    }
                    JMenuItem showTool = new JMenuItem();
                    showTool.setText(this.toolWindowBar.areToolsVisible() ? SwingUtil.getString("@@tool.bar.tools.hide") : SwingUtil.getString("@@tool.bar.tools.show"));
                    showTool.setActionCommand("bar.visible");
                    showTool.addActionListener(this);
                    this.popupMenu.add(showTool);
                    this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if (actionCommand.startsWith("tool.visible.")) {
            String toolId = actionCommand.substring(13);
            this.toolWindowManager.getToolWindow((Object)toolId).setActive(true);
        } else if ("bar.visible".equals(actionCommand)) {
            this.toolWindowBar.setToolsVisible(!this.toolWindowBar.areToolsVisible());
        }
    }

    protected void initPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu("ToolWindowBarContainerPopupMenu");
            this.popupMenu.setLightWeightPopupEnabled(false);
        }
    }
}

