/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.Timer;
import org.noos.xing.mydoggy.AggregationPosition;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.FloatingTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.ui.animation.TransparencyAnimation;
import org.noos.xing.mydoggy.plaf.ui.cmp.DockableDropPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.FloatingWindow;
import org.noos.xing.mydoggy.plaf.ui.cmp.FloatingWindowDockableDropPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitDockableContainer;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.FloatingResizeMouseInputHandler;
import org.noos.xing.mydoggy.plaf.ui.cmp.multisplit.MultiSplitLayout;
import org.noos.xing.mydoggy.plaf.ui.transparency.TransparencyManager;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatingDialog
extends JDialog
implements FloatingWindow,
PropertyChangeListener,
ActionListener {
    protected MyDoggyToolWindowManager toolWindowManager;
    protected FloatingResizeMouseInputHandler resizeMouseInputHandler;
    protected DockableDropPanel dockableDropPanel;
    protected MultiSplitDockableContainer<ToolWindow> multiSplitDockableContainer;
    protected Timer transparencyTimer;
    protected TransparencyManager<Window> transparencyManager;
    protected TransparencyAnimation transparencyAnimation;

    public FloatingDialog(MyDoggyToolWindowManager toolWindowManager, Window owner, boolean modal) {
        super(owner instanceof Frame ? (Frame)owner : null);
        this.toolWindowManager = toolWindowManager;
        this.setFocusableWindowState(true);
        this.setModal(modal);
        this.enableEvents(96L);
        this.initComponents();
        this.initListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        if ("active".equals(evt.getPropertyName())) {
            TransparencyManager<Window> transparencyManager;
            ToolWindow toolWindow = (ToolWindow)evt.getSource();
            FloatingTypeDescriptor typeDescriptor = (FloatingTypeDescriptor)toolWindow.getTypeDescriptor(FloatingTypeDescriptor.class);
            if (this.transparencyTimer != null) {
                this.transparencyTimer.stop();
                if (this.transparencyAnimation.isAnimating()) {
                    transparencyManager = this.transparencyManager;
                    synchronized (transparencyManager) {
                        if (this.transparencyManager.isAlphaModeEnabled(this)) {
                            this.transparencyAnimation.stop();
                            this.transparencyManager.setAlphaModeRatio(this, 1.0f);
                        }
                    }
                }
            }
            if (typeDescriptor.isTransparentMode()) {
                if (evt.getNewValue() == Boolean.FALSE) {
                    if (this.transparencyAnimation != null) {
                        this.transparencyTimer = new Timer(typeDescriptor.getTransparentDelay() + 100, this){

                            protected void fireActionPerformed(ActionEvent e) {
                                e = new ActionEvent(evt.getSource(), e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers());
                                super.fireActionPerformed(e);
                            }
                        };
                        this.transparencyTimer.start();
                    }
                } else {
                    if (this.transparencyTimer != null) {
                        this.transparencyTimer.stop();
                    }
                    if (this.transparencyAnimation != null) {
                        transparencyManager = this.transparencyManager;
                        synchronized (transparencyManager) {
                            if (this.transparencyManager.isAlphaModeEnabled(this)) {
                                this.transparencyAnimation.stop();
                                this.transparencyManager.setAlphaModeRatio(this, 1.0f);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.transparencyTimer.isRunning()) {
            this.transparencyTimer.stop();
            if (this.transparencyAnimation != null) {
                FloatingTypeDescriptor floatingTypeDescriptor = (FloatingTypeDescriptor)((ToolWindow)e.getSource()).getTypeDescriptor(FloatingTypeDescriptor.class);
                this.transparencyAnimation.setAlpha(floatingTypeDescriptor.getTransparentRatio());
                this.transparencyAnimation.show(new Object[0]);
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            TransparencyManager<Window> transparencyManager = SwingUtil.getTransparencyManager();
            transparencyManager.setAlphaModeRatio(this, 1.0f);
        }
        super.setVisible(visible);
    }

    @Override
    public void importFrom(FloatingWindow oldWindow) {
        this.setName(oldWindow.getName());
        this.setBounds(oldWindow.getBounds());
        this.setContentPane(oldWindow.getContentPane());
        Component child = this.getContentPane().getComponent(0);
        if (!(child instanceof FloatingWindowDockableDropPanel)) {
            throw new IllegalArgumentException("Cannot recognize old window.");
        }
        FloatingWindowDockableDropPanel floatingWindowDockableDropPanel = (FloatingWindowDockableDropPanel)child;
        floatingWindowDockableDropPanel.setModalWindow(this);
        this.dockableDropPanel = floatingWindowDockableDropPanel;
        this.multiSplitDockableContainer = (MultiSplitDockableContainer)this.dockableDropPanel.getComponent();
    }

    @Override
    public void setUndecorated(boolean undecorated) {
        super.setUndecorated(undecorated);
        if (this.getContentPane().getLayout() instanceof TableLayout) {
            if (undecorated) {
                TableLayout tableLayout = (TableLayout)this.getContentPane().getLayout();
                int borderLength = SwingUtil.getInt("modawindow.border.length", 2);
                tableLayout.setRow(new double[]{borderLength, -1.0, borderLength});
                tableLayout.setColumn(new double[]{borderLength, -1.0, borderLength});
                SwingUtil.revalidate(this);
            } else {
                TableLayout tableLayout = (TableLayout)this.getContentPane().getLayout();
                tableLayout.setRow(new double[]{0.0, -1.0, 0.0});
                tableLayout.setColumn(new double[]{0.0, -1.0, 0.0});
                SwingUtil.revalidate(this);
            }
        }
    }

    @Override
    public Window getWindow() {
        return this;
    }

    @Override
    public void addDockable(ToolWindow toolWindow, Component content) {
        this.addDockable(toolWindow, content, null, AggregationPosition.DEFAULT);
        if (this.getDockableCount() == 1) {
            this.setTitle(toolWindow.getTitle());
        }
        boolean resizable = ((FloatingTypeDescriptor)toolWindow.getTypeDescriptor(FloatingTypeDescriptor.class)).isResizable();
        if (this.getDockableCount() == 1) {
            this.setResizable(resizable);
        } else if (resizable) {
            this.setResizable(resizable);
        }
    }

    @Override
    public void addDockable(ToolWindow toolWindow, Component content, ToolWindow aggregationOnDockable, AggregationPosition aggregationPosition) {
        this.multiSplitDockableContainer.addDockable((Dockable)toolWindow, content, (Dockable)aggregationOnDockable, -1, aggregationPosition);
        toolWindow.addPropertyChangeListener((PropertyChangeListener)this);
        boolean resizable = ((FloatingTypeDescriptor)toolWindow.getTypeDescriptor(FloatingTypeDescriptor.class)).isResizable();
        if (this.getDockableCount() == 1) {
            this.setResizable(resizable);
        } else if (resizable) {
            this.setResizable(resizable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDockable(ToolWindow toolWindow) {
        try {
            this.multiSplitDockableContainer.removeDockable((Dockable)toolWindow);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            toolWindow.removePropertyChangeListener((PropertyChangeListener)this);
            throw throwable;
        }
        toolWindow.removePropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public int getDockableCount() {
        return this.multiSplitDockableContainer.getDockableCount();
    }

    @Override
    public ToolWindow getDockable() {
        return (ToolWindow)this.multiSplitDockableContainer.getDockableEntries().get((int)0).dockable;
    }

    @Override
    public List<ToolWindow> getDockables() {
        return this.multiSplitDockableContainer.getDockables();
    }

    @Override
    public boolean containsDockable(ToolWindow toolWindow) {
        return this.multiSplitDockableContainer.containsDockable((Dockable)toolWindow);
    }

    @Override
    public Object getMultiSplitLayout() {
        return this.multiSplitDockableContainer.getMultiSplitLayout();
    }

    @Override
    public void setMultiSplitLayout(Object model) {
        this.multiSplitDockableContainer.setMultiSplitLayout((MultiSplitLayout.Node)model);
    }

    @Override
    public void setResizable(boolean resizable) {
        super.setResizable(resizable);
        this.resizeMouseInputHandler.setResizable(resizable);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.toolWindowManager = null;
        this.dockableDropPanel = null;
        this.multiSplitDockableContainer = null;
        if (this.transparencyTimer != null) {
            this.transparencyTimer.stop();
            this.transparencyTimer = null;
        }
        this.transparencyManager = null;
        this.transparencyAnimation = null;
    }

    protected void initComponents() {
        this.multiSplitDockableContainer = new MultiSplitDockableContainer(this.toolWindowManager, 0);
        this.dockableDropPanel = new FloatingWindowDockableDropPanel(this, this.toolWindowManager);
        this.dockableDropPanel.setComponent(this.multiSplitDockableContainer);
        ((JComponent)this.getContentPane()).setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.setLayout((LayoutManager)((Object)new ExtendedTableLayout(new double[][]{{0.0, -1.0, 0.0}, {0.0, -1.0, 0.0}})));
        this.add((Component)this.dockableDropPanel, "1,1,FULL,FULL");
        this.transparencyManager = SwingUtil.getTransparencyManager();
        this.transparencyAnimation = this.transparencyManager.isServiceAvailable() ? new TransparencyAnimation(SwingUtil.getTransparencyManager(), this, 0.0f) : null;
    }

    protected void initListeners() {
        this.resizeMouseInputHandler = new FloatingResizeMouseInputHandler(this);
        this.addMouseListener(this.resizeMouseInputHandler);
        this.addMouseMotionListener(this.resizeMouseInputHandler);
        this.addWindowListener(new FloatingWindowListener());
    }

    public class FloatingWindowListener
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            for (MultiSplitDockableContainer.DockableEntry dockableEntry : FloatingDialog.this.multiSplitDockableContainer.getDockableEntries()) {
                ((ToolWindow)dockableEntry.dockable).setVisible(false);
            }
            super.windowClosing(e);
        }
    }
}

