/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.noos.xing.mydoggy.SlidingTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindow;
import org.noos.xing.mydoggy.plaf.PropertyChangeEventSource;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.ui.MyDoggyToolWindowContainer;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;
import org.noos.xing.mydoggy.plaf.ui.animation.AbstractAnimation;
import org.noos.xing.mydoggy.plaf.ui.animation.TransparencyAnimation;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.border.SlidingBorder;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.SlidingMouseInputHandler;
import org.noos.xing.mydoggy.plaf.ui.translucent.TranslucentPanel;
import org.noos.xing.mydoggy.plaf.ui.util.DynamicPropertyChangeListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class SlidingContainer
extends MyDoggyToolWindowContainer
implements Cleaner {
    protected SlidingAnimation slidingAnimation;
    protected SlidingBorder border;
    protected Container barContainer;
    protected JLayeredPane layeredPane;
    protected JPanel mainPanel;
    protected TranslucentPanel sheet;
    protected SlidingMouseInputHandler slidingMouseInputHandler;
    protected PropertyChangeListener propertyChangeListener;
    protected ComponentListener componentListener;

    public SlidingContainer(ToolWindowDescriptor toolWindowDescriptor) {
        super(toolWindowDescriptor);
        this.initComponents();
        this.initListeners();
    }

    public void cleanup() {
        this.removeListeners();
        this.layeredPane = null;
        super.cleanup();
    }

    public void setVisible(boolean visible, Container barContainer) {
        this.barContainer = barContainer;
        ToolWindowPanel content = this.toolWindowPanel;
        this.sheet.remove(content);
        this.slidingAnimation.stop();
        if (visible) {
            this.descriptor.externalFocusValueAdjusting = true;
            TableLayout layout = (TableLayout)this.sheet.getLayout();
            layout.setColumn(0, 0.0);
            layout.setColumn(2, 0.0);
            layout.setRow(0, 0.0);
            layout.setRow(2, 0.0);
            barContainer.getParent().doLayout();
            this.resize();
            ((Component)content).setVisible(true);
            this.sheet.add((Component)content, "1,1,FULL,FULL");
            this.border.setAnchor(this.toolWindow.getAnchor());
            this.sheet.setBorder(this.border);
            int height = this.mainPanel.getHeight();
            Point point = SwingUtilities.convertPoint(this.mainPanel, 0, 0, this.layeredPane);
            this.sheet.setBounds(point.x, point.y, this.mainPanel.getWidth(), height);
            this.layeredPane.remove(this.sheet);
            this.layeredPane.setLayer(this.sheet, JLayeredPane.DEFAULT_LAYER + 2);
            this.layeredPane.add(this.sheet);
            if (this.descriptor.getTypeDescriptor(ToolWindowType.SLIDING).isAnimating()) {
                this.slidingAnimation.show(this.sheet.getBounds());
            } else {
                this.descriptor.externalFocusValueAdjusting = false;
            }
        } else {
            TableLayout layout = (TableLayout)this.sheet.getLayout();
            layout.setColumn(0, 2.0);
            layout.setColumn(2, 2.0);
            layout.setRow(0, 2.0);
            layout.setRow(2, 2.0);
            switch (this.descriptor.getToolWindow().getAnchor()) {
                case TOP: 
                case BOTTOM: {
                    this.descriptor.setDividerLocation(this.sheet.getHeight());
                    break;
                }
                case LEFT: 
                case RIGHT: {
                    this.descriptor.setDividerLocation(this.sheet.getWidth());
                }
            }
            if (this.descriptor.getTypeDescriptor(ToolWindowType.SLIDING).isAnimating()) {
                this.slidingAnimation.hide(this.sheet.getBounds());
            } else {
                this.layeredPane.remove(this.sheet);
                this.sheet.setBorder(null);
                this.sheet.removeAll();
                SwingUtil.repaint(this.layeredPane);
            }
        }
    }

    protected void initComponents() {
        this.mainPanel = new JPanel();
        this.sheet = new TranslucentPanel((LayoutManager)((Object)new ExtendedTableLayout(new double[][]{{2.0, -1.0, 2.0}, {2.0, -1.0, 2.0}})));
        this.border = new SlidingBorder();
        this.slidingAnimation = new SlidingAnimation();
        this.layeredPane = this.descriptor.getManager().getLayeredPane();
    }

    protected void initListeners() {
        this.propertyChangeListener = new PropertyListener();
        MyDoggyToolWindow toolWindowSource = this.descriptor.getToolWindow();
        toolWindowSource.addPlafPropertyChangeListener(this.propertyChangeListener, "anchor", "type", "active", "maximized");
        PropertyChangeEventSource slidingDescriptorSource = (PropertyChangeEventSource)this.descriptor.getToolWindow().getTypeDescriptor(SlidingTypeDescriptor.class);
        slidingDescriptorSource.addPlafPropertyChangeListener("type", this.propertyChangeListener);
        this.descriptor.getManager().addInternalPropertyChangeListener("temporarilyVisible", this.propertyChangeListener);
        this.descriptor.getManager().addInternalPropertyChangeListener("managerWindowAncestor", this.propertyChangeListener);
        this.slidingMouseInputHandler = new SlidingMouseInputHandler(this.descriptor);
        this.componentListener = new ComponentResizer();
        this.descriptor.getManager().addComponentListener(this.componentListener);
    }

    protected void removeListeners() {
        if (this.sheet != null) {
            this.sheet.removeMouseMotionListener(this.slidingMouseInputHandler);
            this.sheet.removeMouseListener(this.slidingMouseInputHandler);
        }
        MyDoggyToolWindow toolWindowSource = this.descriptor.getToolWindow();
        toolWindowSource.removePlafPropertyChangeListener(this.propertyChangeListener, "anchor", "type", "active", "maximized");
        PropertyChangeEventSource slidingDescriptorSource = (PropertyChangeEventSource)this.descriptor.getToolWindow().getTypeDescriptor(SlidingTypeDescriptor.class);
        slidingDescriptorSource.removePlafPropertyChangeListener("type", this.propertyChangeListener);
        this.descriptor.getManager().removeInternalPropertyChangeListener("temporarilyVisible", this.propertyChangeListener);
        this.descriptor.getManager().removeInternalPropertyChangeListener("managerWindowAncestor", this.propertyChangeListener);
        this.descriptor.getManager().removeComponentListener(this.componentListener);
    }

    protected void update() {
        TableLayout layout = (TableLayout)this.sheet.getLayout();
        layout.setColumn(0, 0.0);
        layout.setColumn(2, 0.0);
        layout.setRow(0, 0.0);
        layout.setRow(2, 0.0);
        if (this.barContainer != null) {
            this.barContainer.getParent().getLayout().layoutContainer(this.barContainer.getParent());
        }
        this.resize();
        ToolWindowPanel content = this.toolWindowPanel;
        this.sheet.remove(content);
        this.sheet.add((Component)content, "1,1,FULL,FULL");
        this.border.setAnchor(this.toolWindow.getAnchor());
        this.sheet.setBorder(this.border);
        int height = this.mainPanel.getHeight();
        Point point = SwingUtilities.convertPoint(this.mainPanel, 0, 0, this.layeredPane);
        this.sheet.setBounds(point.x, point.y, this.mainPanel.getWidth(), height);
        this.layeredPane.remove(this.sheet);
        this.layeredPane.setLayer(this.sheet, JLayeredPane.DEFAULT_LAYER + 2);
        this.layeredPane.add(this.sheet);
        this.layeredPane.validate();
    }

    protected void resize() {
        int length = Math.max(this.descriptor.getDividerLocation(), this.descriptor.getDockedTypeDescriptor().getMinimumDockLength());
        if (length == -1) {
            length = 200;
        }
        switch (this.toolWindow.getAnchor()) {
            case LEFT: {
                int height = this.barContainer.getHeight();
                this.mainPanel.setSize(length, height);
                Point location = new Point(0, 0);
                SwingUtilities.convertPointToScreen(location, this.barContainer);
                location.x += this.barContainer.getWidth();
                this.mainPanel.setLocation(location);
                break;
            }
            case RIGHT: {
                int height = this.barContainer.getHeight();
                this.mainPanel.setSize(length, height);
                Point location = new Point(0, 0);
                SwingUtilities.convertPointToScreen(location, this.barContainer);
                location.x -= this.mainPanel.getWidth();
                this.mainPanel.setLocation(location);
                break;
            }
            case TOP: {
                int width = this.barContainer.getWidth();
                this.mainPanel.setSize(width, length);
                Point location = new Point(0, 0);
                SwingUtilities.convertPointToScreen(location, this.barContainer);
                location.y += this.barContainer.getHeight();
                this.mainPanel.setLocation(location);
                break;
            }
            case BOTTOM: {
                int width = this.barContainer.getWidth();
                this.mainPanel.setSize(width, length);
                Point location = new Point(0, 0);
                SwingUtilities.convertPointToScreen(location, this.barContainer);
                location.y -= this.mainPanel.getHeight();
                this.mainPanel.setLocation(location);
            }
        }
    }

    protected void ensureMaximized() {
        this.sheet.setBounds(this.calcFirstX(), this.calcFirstY(), this.calcMaxWidth(), this.calcMaxHeight());
    }

    protected int calcFirstX() {
        return this.descriptor.getManagerBounds().x + this.descriptor.getToolBar(ToolWindowAnchor.LEFT).getSize();
    }

    protected int calcFirstY() {
        return this.descriptor.getManagerBounds().y + this.descriptor.getToolBar(ToolWindowAnchor.TOP).getSize() + this.descriptor.getManager().getJMenuBarExtraHeight();
    }

    protected int calcMaxWidth() {
        int width = this.descriptor.getManagerBounds().width;
        width -= this.descriptor.getToolBar(ToolWindowAnchor.LEFT).getSize();
        return width -= this.descriptor.getToolBar(ToolWindowAnchor.RIGHT).getSize();
    }

    protected int calcMaxHeight() {
        int height = this.descriptor.getManagerBounds().height;
        height -= this.descriptor.getToolBar(ToolWindowAnchor.TOP).getSize();
        return height -= this.descriptor.getToolBar(ToolWindowAnchor.BOTTOM).getSize();
    }

    public class PropertyListener
    extends DynamicPropertyChangeListener
    implements ActionListener {
        protected TransparencyAnimation animation;
        protected Timer timer;
        protected Rectangle oldBounds = null;

        public PropertyListener() {
            this.animation = new TransparencyAnimation(SlidingContainer.this.sheet, (Component)SlidingContainer.this.sheet, 1.0f, 500.0f);
        }

        public void onAnchor(PropertyChangeEvent evt) {
            ToolWindow evtToolWindow = (ToolWindow)evt.getSource();
            if (SlidingContainer.this.toolWindow.getType() == ToolWindowType.SLIDING && SlidingContainer.this.toolWindow.isVisible() && !evtToolWindow.isVisible()) {
                SlidingContainer.this.update();
            }
        }

        public void onType(PropertyChangeEvent evt) {
            if (evt.getNewValue() == ToolWindowType.SLIDING) {
                if (SlidingContainer.this.layeredPane != null) {
                    SlidingContainer.this.sheet.addMouseMotionListener(SlidingContainer.this.slidingMouseInputHandler);
                    SlidingContainer.this.sheet.addMouseListener(SlidingContainer.this.slidingMouseInputHandler);
                }
            } else if (SlidingContainer.this.layeredPane != null) {
                SlidingContainer.this.sheet.removeMouseMotionListener(SlidingContainer.this.slidingMouseInputHandler);
                SlidingContainer.this.sheet.removeMouseListener(SlidingContainer.this.slidingMouseInputHandler);
            }
        }

        public void onMaximized(PropertyChangeEvent evt) {
            if (SlidingContainer.this.toolWindow.getType() == ToolWindowType.SLIDING) {
                if (((Boolean)evt.getNewValue()).booleanValue()) {
                    this.oldBounds = SlidingContainer.this.sheet.getBounds();
                    SlidingContainer.this.ensureMaximized();
                } else {
                    SlidingContainer.this.sheet.setBounds(this.oldBounds);
                    SlidingContainer.this.update();
                }
                SwingUtil.repaint(SlidingContainer.this.sheet);
            }
        }

        public void onActive(PropertyChangeEvent evt) {
            if (SlidingContainer.this.descriptor.getToolWindow().getType() == ToolWindowType.SLIDING) {
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    if (this.timer != null) {
                        this.timer.stop();
                        if (this.animation.isAnimating()) {
                            this.animation.stop();
                        }
                    }
                    SlidingContainer.this.sheet.setAlphaModeRatio(1.0f);
                } else {
                    SlidingTypeDescriptor slidingTypeDescriptor = (SlidingTypeDescriptor)SlidingContainer.this.descriptor.getTypeDescriptor(ToolWindowType.SLIDING);
                    if (slidingTypeDescriptor.isTransparentMode()) {
                        this.timer = new Timer(slidingTypeDescriptor.getTransparentDelay(), this);
                        this.timer.start();
                    }
                }
                SwingUtil.repaint(SlidingContainer.this.layeredPane);
            }
        }

        public void onEnabled(PropertyChangeEvent evt) {
            boolean newValue = (Boolean)evt.getNewValue();
            if (!newValue && SlidingContainer.this.toolWindow.getType() == ToolWindowType.SLIDING) {
                SlidingContainer.this.toolWindow.setType(ToolWindowType.DOCKED);
            }
        }

        public void onTemporarilyVisible(PropertyChangeEvent evt) {
            if (SlidingContainer.this.toolWindow.getType() == ToolWindowType.SLIDING && SlidingContainer.this.toolWindow.isVisible()) {
                SlidingContainer.this.update();
            }
        }

        public void onManagerWindowAncestor(PropertyChangeEvent evt) {
            if (evt.getNewValue() != null) {
                SlidingContainer.this.layeredPane = SlidingContainer.this.descriptor.getManager().getLayeredPane();
                if (SlidingContainer.this.toolWindow.getType() == ToolWindowType.SLIDING) {
                    SlidingContainer.this.sheet.removeMouseMotionListener(SlidingContainer.this.slidingMouseInputHandler);
                    SlidingContainer.this.sheet.removeMouseListener(SlidingContainer.this.slidingMouseInputHandler);
                    SlidingContainer.this.sheet.addMouseMotionListener(SlidingContainer.this.slidingMouseInputHandler);
                    SlidingContainer.this.sheet.addMouseListener(SlidingContainer.this.slidingMouseInputHandler);
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (this.timer.isRunning()) {
                this.timer.stop();
                SlidingTypeDescriptor slidingTypeDescriptor = (SlidingTypeDescriptor)SlidingContainer.this.descriptor.getTypeDescriptor(ToolWindowType.SLIDING);
                this.animation.setAlpha(slidingTypeDescriptor.getTransparentRatio());
                this.animation.show(new Object[0]);
            }
        }
    }

    public class ComponentResizer
    extends ComponentAdapter
    implements Cleaner {
        public ComponentResizer() {
            SlidingContainer.this.descriptor.getCleaner().addBefore(SlidingContainer.this, this);
        }

        public void cleanup() {
            SlidingContainer.this.descriptor.getManager().removeComponentListener(this);
        }

        public void componentResized(ComponentEvent e) {
            if (SlidingContainer.this.toolWindow.getType() == ToolWindowType.SLIDING && SlidingContainer.this.toolWindow.isVisible()) {
                if (SlidingContainer.this.toolWindow.isMaximized()) {
                    SlidingContainer.this.ensureMaximized();
                } else {
                    SlidingContainer.this.update();
                }
            }
        }
    }

    public class SlidingAnimation
    extends AbstractAnimation {
        protected int length;
        protected Rectangle bounds;
        protected int lastLen;

        public SlidingAnimation() {
            super(60.0f);
            this.lastLen = 0;
        }

        protected void onStartAnimation(AbstractAnimation.Direction direction) {
            this.lastLen = 0;
            switch (SlidingContainer.this.toolWindow.getAnchor()) {
                case LEFT: 
                case RIGHT: {
                    this.length = this.bounds.width;
                    break;
                }
                case TOP: 
                case BOTTOM: {
                    this.length = this.bounds.height;
                }
            }
        }

        protected void onFinishAnimation() {
            switch (this.getAnimationDirection()) {
                case INCOMING: {
                    SlidingContainer.this.sheet.setBounds(this.bounds);
                    SlidingContainer.this.descriptor.assignFocus();
                    SlidingContainer.this.descriptor.externalFocusValueAdjusting = false;
                    break;
                }
                case OUTGOING: {
                    SlidingContainer.this.layeredPane.remove(SlidingContainer.this.sheet);
                    SlidingContainer.this.sheet.setBorder(null);
                    SlidingContainer.this.sheet.removeAll();
                }
            }
        }

        protected void onHide(Object ... params) {
            this.bounds = (Rectangle)params[0];
        }

        protected void onShow(Object ... params) {
            this.bounds = (Rectangle)params[0];
            switch (SlidingContainer.this.toolWindow.getAnchor()) {
                case LEFT: {
                    SlidingContainer.this.sheet.setSize(0, SlidingContainer.this.sheet.getHeight());
                    break;
                }
                case RIGHT: {
                    SlidingContainer.this.sheet.setLocation(SlidingContainer.this.sheet.getX() + SlidingContainer.this.sheet.getWidth(), SlidingContainer.this.sheet.getY());
                    SlidingContainer.this.sheet.setSize(0, SlidingContainer.this.sheet.getHeight());
                    break;
                }
                case TOP: {
                    SlidingContainer.this.sheet.setSize(SlidingContainer.this.sheet.getWidth(), 0);
                    break;
                }
                case BOTTOM: {
                    SlidingContainer.this.sheet.setLocation(SlidingContainer.this.sheet.getX(), SlidingContainer.this.sheet.getY() + SlidingContainer.this.sheet.getHeight());
                    SlidingContainer.this.sheet.setSize(SlidingContainer.this.sheet.getWidth(), 0);
                }
            }
        }

        protected float onAnimating(float animationPercent) {
            int animatingLength = 0;
            AbstractAnimation.Direction direction = this.getAnimationDirection();
            switch (SlidingContainer.this.toolWindow.getAnchor()) {
                case LEFT: {
                    animatingLength = direction == AbstractAnimation.Direction.INCOMING ? (int)(animationPercent * (float)this.length) : (int)((1.0f - animationPercent) * (float)this.length);
                    SlidingContainer.this.sheet.setSize(animatingLength, SlidingContainer.this.sheet.getHeight());
                    break;
                }
                case RIGHT: {
                    animatingLength = (int)(animationPercent * (float)this.length);
                    if (direction == AbstractAnimation.Direction.INCOMING) {
                        SlidingContainer.this.sheet.setLocation(SlidingContainer.this.sheet.getX() - (animatingLength - this.lastLen), SlidingContainer.this.sheet.getY());
                        SlidingContainer.this.sheet.setSize(animatingLength, SlidingContainer.this.sheet.getHeight());
                        break;
                    }
                    SlidingContainer.this.sheet.setLocation(this.bounds.x + animatingLength, SlidingContainer.this.sheet.getY());
                    SlidingContainer.this.sheet.setSize((int)((1.0f - animationPercent) * (float)this.length), SlidingContainer.this.sheet.getHeight());
                    break;
                }
                case TOP: {
                    animatingLength = direction == AbstractAnimation.Direction.INCOMING ? (int)(animationPercent * (float)this.length) : (int)((1.0f - animationPercent) * (float)this.length);
                    SlidingContainer.this.sheet.setSize(SlidingContainer.this.sheet.getWidth(), animatingLength);
                    break;
                }
                case BOTTOM: {
                    animatingLength = (int)(animationPercent * (float)this.length);
                    if (direction == AbstractAnimation.Direction.INCOMING) {
                        SlidingContainer.this.sheet.setLocation(SlidingContainer.this.sheet.getX(), SlidingContainer.this.sheet.getY() - (animatingLength - this.lastLen));
                        SlidingContainer.this.sheet.setSize(SlidingContainer.this.sheet.getWidth(), animatingLength);
                        break;
                    }
                    SlidingContainer.this.sheet.setLocation(SlidingContainer.this.sheet.getX(), this.bounds.y + animatingLength);
                    SlidingContainer.this.sheet.setSize(SlidingContainer.this.sheet.getWidth(), (int)((1.0f - animationPercent) * (float)this.length));
                }
            }
            SlidingContainer.this.sheet.validate();
            SlidingContainer.this.sheet.repaint();
            this.lastLen = animatingLength;
            return animationPercent;
        }

        protected AbstractAnimation.Direction chooseFinishDirection(AbstractAnimation.Type type) {
            return type == AbstractAnimation.Type.SHOW ? AbstractAnimation.Direction.NONE : super.chooseFinishDirection(type);
        }
    }
}

