/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.noos.xing.mydoggy.AggregationPosition;
import org.noos.xing.mydoggy.FloatingLiveTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindow;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.PropertyChangeEventSource;
import org.noos.xing.mydoggy.plaf.ui.MyDoggyToolWindowContainer;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;
import org.noos.xing.mydoggy.plaf.ui.cmp.FloatingLiveWindow;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.FloatingMoveMouseInputHandler;
import org.noos.xing.mydoggy.plaf.ui.util.DynamicPropertyChangeListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class FloatingLiveContainer
extends MyDoggyToolWindowContainer {
    protected FloatingLiveWindow floatingLiveWindow;
    protected PropertyChangeListener propertyChangeListener;
    protected FloatingMoveMouseInputHandler moveMouseInputHandler;
    protected ComponentListener livePanelComponentListener;
    protected boolean settedListener = false;
    protected Rectangle lastBounds;
    protected boolean valueAdjusting;

    public FloatingLiveContainer(ToolWindowDescriptor toolWindowDescriptor) {
        super(toolWindowDescriptor);
        this.initComponents();
        this.initListeners();
    }

    public void cleanup() {
        this.removeListeners();
        this.floatingLiveWindow = null;
        super.cleanup();
    }

    public void setVisible(boolean visible) {
        ToolWindowPanel content = this.toolWindowPanel;
        if (visible) {
            this.floatingLiveWindow = this.descriptor.getFloatingLiveWindow();
            JComponent floatingLiveComponent = (JComponent)((Object)this.floatingLiveWindow);
            this.floatingLiveWindow.resetLayout();
            ((Component)content).setVisible(true);
            this.floatingLiveWindow.addDockable(this.toolWindow, content);
            this.moveMouseInputHandler.setFloatingContainer(floatingLiveComponent);
            floatingLiveComponent.addComponentListener(this.livePanelComponentListener);
            floatingLiveComponent.setBorder(BorderFactory.createEtchedBorder());
            if (this.lastBounds == null) {
                MyDoggyToolWindowManager managerCmp;
                FloatingLiveTypeDescriptor typeDescriptor = (FloatingLiveTypeDescriptor)this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING_LIVE);
                if (typeDescriptor.getSize() == null) {
                    managerCmp = this.descriptor.getManager();
                    switch (this.toolWindow.getAnchor()) {
                        case LEFT: 
                        case RIGHT: {
                            this.floatingLiveWindow.setSize(this.descriptor.getDockedTypeDescriptor().getDockLength(), (int)((double)((Component)managerCmp).getHeight() / 1.5));
                            break;
                        }
                        case TOP: 
                        case BOTTOM: {
                            this.floatingLiveWindow.setSize((int)((double)((Component)managerCmp).getWidth() / 1.5), this.descriptor.getDockedTypeDescriptor().getDockLength());
                        }
                    }
                } else {
                    this.floatingLiveWindow.setSize(typeDescriptor.getSize());
                }
                SwingUtil.validateBounds(floatingLiveComponent, this.descriptor.getManager().getMainContainer().getBounds());
                if (typeDescriptor.getLocation() == null || typeDescriptor.getLocation().x > this.descriptor.getManager().getWidth() || typeDescriptor.getLocation().y > this.descriptor.getManager().getHeight() || typeDescriptor.getLocation().x < 0 || typeDescriptor.getLocation().y < 0) {
                    managerCmp = this.descriptor.getManager();
                    switch (this.toolWindow.getAnchor()) {
                        case LEFT: {
                            this.floatingLiveWindow.setLocation(50, 50);
                            break;
                        }
                        case RIGHT: {
                            this.floatingLiveWindow.setLocation(((Component)managerCmp).getWidth() - 50 - this.floatingLiveWindow.getWidth(), 50);
                            break;
                        }
                        case TOP: {
                            this.floatingLiveWindow.setLocation(50, 50);
                            break;
                        }
                        case BOTTOM: {
                            this.floatingLiveWindow.setLocation(50, ((Component)managerCmp).getHeight() - 50 - this.floatingLiveWindow.getHeight());
                        }
                    }
                } else {
                    this.floatingLiveWindow.setLocation(typeDescriptor.getLocation());
                }
            } else {
                this.floatingLiveWindow.setBounds(this.lastBounds);
                this.lastBounds = null;
            }
            this.floatingLiveWindow.mount();
        } else {
            this.floatingLiveWindow.removeDockable(this.toolWindow);
            JComponent floatingLiveComponent = (JComponent)((Object)this.floatingLiveWindow);
            floatingLiveComponent.removeComponentListener(this.livePanelComponentListener);
            this.floatingLiveWindow.unmount();
            this.descriptor.removeFloatingLiveWindow();
            this.floatingLiveWindow = null;
        }
    }

    public void setVisible(ToolWindowDescriptor referenceAggregationTool, Component content, ToolWindowDescriptor aggregationOnTool, AggregationPosition aggregationPosition) {
        this.floatingLiveWindow = ((FloatingLiveContainer)referenceAggregationTool.getToolWindowContainer(ToolWindowType.FLOATING_LIVE)).getFloatingLiveWindow();
        this.floatingLiveWindow.addDockable(this.toolWindow, content, aggregationOnTool != null ? aggregationOnTool.getToolWindow() : null, aggregationPosition);
        JComponent floatingLiveComponent = (JComponent)((Object)this.floatingLiveWindow);
        this.moveMouseInputHandler.setFloatingContainer(floatingLiveComponent);
        floatingLiveComponent.addComponentListener(this.livePanelComponentListener);
        this.floatingLiveWindow.mount();
    }

    public FloatingLiveWindow getFloatingLiveWindow() {
        return this.floatingLiveWindow;
    }

    protected void initComponents() {
    }

    protected void initListeners() {
        MyDoggyToolWindow toolWindowSource = this.descriptor.getToolWindow();
        this.propertyChangeListener = new PropertyListener();
        toolWindowSource.addPlafPropertyChangeListener(this.propertyChangeListener, "type", "maximized");
        PropertyChangeEventSource floatingLiveTypeDescriptorSource = (PropertyChangeEventSource)this.descriptor.getToolWindow().getTypeDescriptor(FloatingLiveTypeDescriptor.class);
        floatingLiveTypeDescriptorSource.addPlafPropertyChangeListener(this.propertyChangeListener, "location", "size", "enabled", "visible");
        this.moveMouseInputHandler = new FloatingMoveMouseInputHandler(null);
        this.livePanelComponentListener = new LivePanelComponentListener();
    }

    protected void removeListeners() {
        MyDoggyToolWindow toolWindowSource = this.descriptor.getToolWindow();
        toolWindowSource.removePlafPropertyChangeListener(this.propertyChangeListener, "type", "maximized");
        PropertyChangeEventSource floatingLiveTypeDescriptorSource = (PropertyChangeEventSource)this.descriptor.getToolWindow().getTypeDescriptor(FloatingLiveTypeDescriptor.class);
        floatingLiveTypeDescriptorSource.removePlafPropertyChangeListener(this.propertyChangeListener, "location", "size", "enabled", "visible");
        this.toolWindowTabPanel.removeEventDispatcherlListener(this.moveMouseInputHandler);
        this.toolWindowTitleBar.removeMouseMotionListener(this.moveMouseInputHandler);
        this.toolWindowTitleBar.removeMouseListener(this.moveMouseInputHandler);
    }

    public class LivePanelComponentListener
    extends ComponentAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentResized(ComponentEvent e) {
            FloatingLiveContainer.this.valueAdjusting = true;
            try {
                ((FloatingLiveTypeDescriptor)FloatingLiveContainer.this.toolWindow.getTypeDescriptor(FloatingLiveTypeDescriptor.class)).setSize(FloatingLiveContainer.this.floatingLiveWindow.getWidth(), FloatingLiveContainer.this.floatingLiveWindow.getHeight());
                Object var3_2 = null;
                FloatingLiveContainer.this.valueAdjusting = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                FloatingLiveContainer.this.valueAdjusting = false;
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentMoved(ComponentEvent e) {
            FloatingLiveContainer.this.valueAdjusting = true;
            try {
                ((FloatingLiveTypeDescriptor)FloatingLiveContainer.this.toolWindow.getTypeDescriptor(FloatingLiveTypeDescriptor.class)).setLocation(FloatingLiveContainer.this.floatingLiveWindow.getX(), FloatingLiveContainer.this.floatingLiveWindow.getY());
                Object var3_2 = null;
                FloatingLiveContainer.this.valueAdjusting = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                FloatingLiveContainer.this.valueAdjusting = false;
                throw throwable;
            }
        }
    }

    public class PropertyListener
    extends DynamicPropertyChangeListener {
        protected Rectangle oldBounds = null;

        public void onType(PropertyChangeEvent evt) {
            assert ("type".equals(evt.getPropertyName()));
            if (evt.getNewValue() == ToolWindowType.FLOATING_LIVE) {
                if (FloatingLiveContainer.this.descriptor.getManager().getLayeredPane() != null) {
                    FloatingLiveContainer.this.toolWindowTabPanel.removeEventDispatcherlListener(FloatingLiveContainer.this.moveMouseInputHandler);
                    FloatingLiveContainer.this.toolWindowTitleBar.removeMouseMotionListener(FloatingLiveContainer.this.moveMouseInputHandler);
                    FloatingLiveContainer.this.toolWindowTitleBar.removeMouseListener(FloatingLiveContainer.this.moveMouseInputHandler);
                    FloatingLiveContainer.this.toolWindowTabPanel.addEventDispatcherlListener(FloatingLiveContainer.this.moveMouseInputHandler);
                    FloatingLiveContainer.this.toolWindowTitleBar.addMouseMotionListener(FloatingLiveContainer.this.moveMouseInputHandler);
                    FloatingLiveContainer.this.toolWindowTitleBar.addMouseListener(FloatingLiveContainer.this.moveMouseInputHandler);
                    FloatingLiveContainer.this.settedListener = true;
                }
            } else if (evt.getOldValue() == ToolWindowType.FLOATING_LIVE && FloatingLiveContainer.this.descriptor.getManager().getLayeredPane() != null) {
                FloatingLiveWindow floatingLiveWindow = FloatingLiveContainer.this.descriptor.getManager().getFloatingLiveWindow(FloatingLiveContainer.this.toolWindow);
                if (FloatingLiveContainer.this.settedListener && floatingLiveWindow.isValid()) {
                    FloatingLiveContainer.this.lastBounds = floatingLiveWindow.getBounds();
                }
                FloatingLiveContainer.this.toolWindowTabPanel.removeEventDispatcherlListener(FloatingLiveContainer.this.moveMouseInputHandler);
                FloatingLiveContainer.this.toolWindowTitleBar.removeMouseMotionListener(FloatingLiveContainer.this.moveMouseInputHandler);
                FloatingLiveContainer.this.toolWindowTitleBar.removeMouseListener(FloatingLiveContainer.this.moveMouseInputHandler);
                FloatingLiveContainer.this.settedListener = false;
            }
        }

        public void onMaximized(PropertyChangeEvent evt) {
            if (FloatingLiveContainer.this.toolWindow.getType() == ToolWindowType.FLOATING_LIVE) {
                FloatingLiveWindow floatingLiveWindow = FloatingLiveContainer.this.descriptor.getManager().getFloatingLiveWindow(FloatingLiveContainer.this.toolWindow);
                if (((Boolean)evt.getNewValue()).booleanValue()) {
                    this.oldBounds = floatingLiveWindow.getBounds();
                    Rectangle bounds = FloatingLiveContainer.this.descriptor.getManager().getMainContainer().getBounds();
                    bounds = SwingUtilities.convertRectangle(FloatingLiveContainer.this.descriptor.getManager().getMainContainer(), bounds, FloatingLiveContainer.this.descriptor.getManager().getRootPane().getLayeredPane());
                    floatingLiveWindow.setBounds(bounds);
                } else {
                    floatingLiveWindow.setBounds(this.oldBounds);
                }
                SwingUtil.repaint((Component)((Object)floatingLiveWindow));
            }
        }

        public void onLocation(PropertyChangeEvent evt) {
            if (FloatingLiveContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING_LIVE) != evt.getSource()) {
                return;
            }
            if (FloatingLiveContainer.this.valueAdjusting) {
                return;
            }
            FloatingLiveWindow floatingLiveWindow = FloatingLiveContainer.this.descriptor.getManager().getFloatingLiveWindow(FloatingLiveContainer.this.toolWindow);
            if (floatingLiveWindow.isVisible()) {
                Point location = (Point)evt.getNewValue();
                floatingLiveWindow.setLocation(location);
            }
            FloatingLiveContainer.this.lastBounds = null;
        }

        public void onSize(PropertyChangeEvent evt) {
            if (FloatingLiveContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING_LIVE) != evt.getSource()) {
                return;
            }
            if (FloatingLiveContainer.this.valueAdjusting) {
                return;
            }
            FloatingLiveWindow floatingLiveWindow = FloatingLiveContainer.this.descriptor.getManager().getFloatingLiveWindow(FloatingLiveContainer.this.toolWindow);
            if (floatingLiveWindow.isVisible()) {
                Dimension size = (Dimension)evt.getNewValue();
                floatingLiveWindow.setSize(size);
            }
            FloatingLiveContainer.this.lastBounds = null;
        }

        public void onEnabled(PropertyChangeEvent evt) {
            boolean newValue = (Boolean)evt.getNewValue();
            if (!newValue && FloatingLiveContainer.this.toolWindow.getType() == ToolWindowType.FLOATING_LIVE) {
                FloatingLiveContainer.this.toolWindow.setType(ToolWindowType.DOCKED);
            }
        }

        public void onVisible(PropertyChangeEvent evt) {
            boolean newValue = (Boolean)evt.getNewValue();
            if (!newValue) {
                FloatingLiveContainer.this.lastBounds = FloatingLiveContainer.this.descriptor.getManager().getFloatingLiveWindow(FloatingLiveContainer.this.toolWindow).getBounds();
            }
        }
    }
}

