/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.SwingUtilities;
import org.noos.xing.mydoggy.PersistenceDelegate;
import org.noos.xing.mydoggy.PersistenceDelegateFilter;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowListener;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.event.ToolWindowTabEvent;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindow;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.persistence.InternalPersistenceDelegateFilterAdapter;
import org.noos.xing.mydoggy.plaf.ui.MyDoggyToolWindowContainer;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class DockedContainer
extends MyDoggyToolWindowContainer {
    protected PropertyChangeListener typeListener;
    protected PropertyChangeListener maximizedListener;

    public DockedContainer(ToolWindowDescriptor descriptor) {
        super(descriptor);
        this.initListeners();
    }

    public void cleanup() {
        this.removeListeners();
        this.toolWindow = null;
        this.descriptor = null;
    }

    protected void initListeners() {
        MyDoggyToolWindow toolWindowSource = this.descriptor.getToolWindow();
        this.typeListener = new TypePropertyChangeListener();
        toolWindowSource.addPlafPropertyChangeListener("type", this.typeListener);
        this.maximizedListener = new MaximizedBeforePropertyChangeListener();
        toolWindowSource.addPlafPropertyChangeListener("maximizedBefore", this.maximizedListener);
        this.toolWindow.addToolWindowListener((ToolWindowListener)new DockedToolWindowListener());
        this.descriptor.getManager().addComponentListener(new ComponentResizer());
    }

    protected void removeListeners() {
        MyDoggyToolWindow toolWindowSource = this.descriptor.getToolWindow();
        toolWindowSource.removePlafPropertyChangeListener("type", this.typeListener);
        toolWindowSource.removePlafPropertyChangeListener("maximizedBefore", this.maximizedListener);
    }

    public class ComponentResizer
    extends ComponentAdapter
    implements Cleaner {
        public ComponentResizer() {
            DockedContainer.this.descriptor.getCleaner().addBefore(DockedContainer.this, this);
        }

        public void cleanup() {
            DockedContainer.this.descriptor.getManager().removeComponentListener(this);
        }

        public void componentResized(ComponentEvent e) {
            if (DockedContainer.this.toolWindow.getType() == ToolWindowType.DOCKED && DockedContainer.this.toolWindow.isVisible() && DockedContainer.this.toolWindow.isMaximized()) {
                DockedContainer.this.descriptor.getToolBar().updateMaximizedToolSize();
            }
        }
    }

    public class MaximizedBeforePropertyChangeListener
    implements PropertyChangeListener {
        ByteArrayOutputStream workspace;
        boolean valueAdj = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            if (((Boolean)evt.getNewValue()).booleanValue()) {
                this.workspace = new ByteArrayOutputStream();
                DockedContainer.this.descriptor.getManager().getPersistenceDelegate().save((OutputStream)this.workspace, (PersistenceDelegateFilter)new InternalPersistenceDelegateFilterAdapter(){

                    public boolean storeToolWindow(ToolWindow toolWindow) {
                        return toolWindow != DockedContainer.this.descriptor.getToolWindow();
                    }
                });
            } else if (this.workspace != null) {
                if (this.valueAdj) {
                    return;
                }
                this.valueAdj = true;
                try {
                    DockedContainer.this.descriptor.getManager().getPersistenceDelegate().merge((InputStream)new ByteArrayInputStream(this.workspace.toByteArray()), DockedContainer.this.descriptor.getManager().getResourceManager().getObject(PersistenceDelegate.MergePolicy.class, PersistenceDelegate.MergePolicy.UNION));
                    this.workspace = null;
                    Object var3_2 = null;
                    this.valueAdj = false;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.valueAdj = false;
                    throw throwable;
                }
            }
        }
    }

    public class TypePropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getOldValue() == ToolWindowType.EXTERN) {
                DockedContainer.this.descriptor.setComponent(DockedContainer.this.toolWindow.getToolWindowTabs()[0].getComponent());
            }
        }
    }

    public class DockedToolWindowListener
    implements Cleaner,
    ToolWindowListener,
    PropertyChangeListener {
        public DockedToolWindowListener() {
            DockedContainer.this.descriptor.getCleaner().addBefore(DockedContainer.this, this);
            for (ToolWindowTab tab : DockedContainer.this.toolWindow.getToolWindowTabs()) {
                tab.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void cleanup() {
            DockedContainer.this.toolWindow.removeToolWindowListener((ToolWindowListener)this);
            for (ToolWindowTab tab : DockedContainer.this.toolWindow.getToolWindowTabs()) {
                tab.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public boolean toolWindowTabRemoving(ToolWindowTabEvent event) {
            return true;
        }

        public void toolWindowTabAdded(ToolWindowTabEvent event) {
            ToolWindowTab tab = event.getToolWindowTab();
            tab.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void toolWindowTabRemoved(ToolWindowTabEvent event) {
            if (DockedContainer.this.toolWindow.getToolWindowTabs().length == 0) {
                DockedContainer.this.descriptor.getToolWindowPanel().removeComponent(event.getToolWindowTab().getComponent());
            }
            event.getToolWindowTab().removePropertyChangeListener((PropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            final ToolWindowTab tab = (ToolWindowTab)evt.getSource();
            String property = evt.getPropertyName();
            if ("selected".equals(property)) {
                if (evt.getNewValue() == Boolean.TRUE) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Component focusable = DockedContainer.this.descriptor.getToolWindowPanel().getFocusable();
                            if (focusable == null) {
                                return;
                            }
                            focusable.setFocusable(true);
                            focusable.requestFocusInWindow();
                        }
                    });
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Component toolWindowPanelFocusable = DockedContainer.this.descriptor.getToolWindowPanel().getFocusable();
                            if (toolWindowPanelFocusable == null) {
                                return;
                            }
                            if (toolWindowPanelFocusable.isFocusOwner()) {
                                DockedContainer.this.descriptor.setComponent(tab.getComponent());
                                Component focusable = SwingUtil.findFocusable(tab.getComponent());
                                if (focusable != null) {
                                    focusable.requestFocusInWindow();
                                    toolWindowPanelFocusable.setFocusable(false);
                                } else {
                                    toolWindowPanelFocusable.requestFocusInWindow();
                                }
                            } else {
                                SwingUtilities.invokeLater(this);
                            }
                        }
                    });
                }
            } else if ("component".equals(property) && DockedContainer.this.descriptor.getComponent() == evt.getOldValue()) {
                DockedContainer.this.descriptor.setComponent(tab.getComponent());
            }
        }
    }
}

