/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.persistence.xml;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.noos.xing.mydoggy.ContentManager;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.DockableManager;
import org.noos.xing.mydoggy.PersistenceDelegateCallback;
import org.noos.xing.mydoggy.ToolWindowManager;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitWindow;
import org.noos.xing.mydoggy.plaf.ui.cmp.multisplit.MultiSplitLayout;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class SharedWindows {
    protected PersistenceDelegateCallback persistenceDelegateCallback;
    protected DockableManager dockableManager;
    protected List<SharedWindowEntry> sharedWindows;

    public SharedWindows(DockableManager dockableManager, PersistenceDelegateCallback persistenceDelegateCallback) {
        this.dockableManager = dockableManager;
        this.persistenceDelegateCallback = persistenceDelegateCallback;
        this.sharedWindows = new ArrayList<SharedWindowEntry>();
    }

    public void addSharedWindow(MultiSplitLayout.Node node, String ... ids) {
        this.sharedWindows.add(new SharedWindowEntry(ids, node));
    }

    public String[] getSharedWindow(String id) {
        for (SharedWindowEntry sharedWindowEntry : this.sharedWindows) {
            for (String dockableId : sharedWindowEntry.ids) {
                if (!id.equals(dockableId)) continue;
                return sharedWindowEntry.ids;
            }
        }
        return null;
    }

    public boolean isInSharedWindow(Dockable dockable) {
        String id = dockable.getId();
        for (SharedWindowEntry sharedWindowEntry : this.sharedWindows) {
            for (String dockableId : sharedWindowEntry.ids) {
                if (!id.equals(dockableId)) continue;
                return true;
            }
        }
        return false;
    }

    public Dockable getRefDockable(Dockable dockable) {
        for (String id : this.getSharedWindow(dockable.getId())) {
            if (id.equals(dockable.getId())) continue;
            Dockable ref = this.dockableManager.getDockableById(id);
            if (ref == null) {
                ref = this.dockableManager instanceof ToolWindowManager ? this.persistenceDelegateCallback.toolwindowNotFound((ToolWindowManager)this.dockableManager, id, null) : this.persistenceDelegateCallback.toolwindowNotFound(((ContentManager)this.dockableManager).getToolWindowManager(), id, null);
            }
            if (ref == null || !ref.isVisible()) continue;
            return ref;
        }
        return null;
    }

    public void applyLayouts() {
        for (final SharedWindowEntry sharedWindowEntry : this.sharedWindows) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MultiSplitWindow multiSplitWindow = SwingUtil.getParent(SharedWindows.this.dockableManager.getDockableById(sharedWindowEntry.ids[0]).getComponent(), MultiSplitWindow.class);
                            if (multiSplitWindow != null) {
                                multiSplitWindow.setMultiSplitLayout(sharedWindowEntry.node);
                            }
                        }
                    });
                }
            });
        }
    }

    class SharedWindowEntry {
        String[] ids;
        MultiSplitLayout.Node node;

        SharedWindowEntry(String[] ids, MultiSplitLayout.Node node) {
            this.ids = ids;
            this.node = node;
        }
    }
}

