/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.descriptors;

import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.noos.xing.mydoggy.RepresentativeAnchorDescriptor;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.PropertyChangeEventSource;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolWindowRepresentativeAnchorDescriptor
extends PropertyChangeEventSource
implements RepresentativeAnchorDescriptor<ToolWindow> {
    protected ToolWindowDescriptor toolWindowDescriptor;
    protected ToolWindow toolWindow;
    protected boolean previewEnabled;
    protected int previewDelay;
    protected float previewTransparentRatio;
    protected Set<ToolWindowAnchor> lockingAnchors;
    protected String title;
    protected Icon icon;
    protected boolean visible;

    public ToolWindowRepresentativeAnchorDescriptor(ToolWindowDescriptor toolWindowDescriptor) {
        super(toolWindowDescriptor.getManager().getFirePublicEvent());
        this.toolWindowDescriptor = toolWindowDescriptor;
        this.toolWindow = toolWindowDescriptor.getToolWindow();
        this.previewEnabled = true;
        this.previewDelay = 1000;
        this.previewTransparentRatio = 0.65f;
        this.lockingAnchors = new HashSet<ToolWindowAnchor>();
        this.visible = true;
        this.title = this.toolWindow.getId();
        this.icon = this.toolWindow.getIcon();
        toolWindowDescriptor.getCleaner().addCleaner(this);
    }

    public ToolWindow getDockable() {
        return this.toolWindow;
    }

    public ToolWindowAnchor getAnchor() {
        return this.toolWindow.getAnchor();
    }

    public boolean isPreviewEnabled() {
        return this.previewEnabled;
    }

    public void setPreviewEnabled(boolean previewEnabled) {
        if (this.previewEnabled == previewEnabled) {
            return;
        }
        boolean old = this.previewEnabled;
        this.previewEnabled = previewEnabled;
        this.firePropertyChangeEvent("previewEnabled", old, previewEnabled);
    }

    public int getPreviewDelay() {
        return this.previewDelay;
    }

    public void setPreviewDelay(int previewDelay) {
        if (this.previewDelay == previewDelay) {
            return;
        }
        int old = this.previewDelay;
        this.previewDelay = previewDelay;
        this.firePropertyChangeEvent("previewDelay", old, previewDelay);
    }

    public float getPreviewTransparentRatio() {
        return this.previewTransparentRatio;
    }

    public void setPreviewTransparentRatio(float previewTransparentRatio) {
        if (this.previewTransparentRatio == previewTransparentRatio) {
            return;
        }
        float old = this.previewTransparentRatio;
        this.previewTransparentRatio = previewTransparentRatio;
        this.firePropertyChangeEvent("previewTransparentRatio", Float.valueOf(old), Float.valueOf(previewTransparentRatio));
    }

    public void addLockingAnchor(ToolWindowAnchor anchor) {
        this.lockingAnchors.add(anchor);
    }

    public void removeLockingAnchor(ToolWindowAnchor anchor) {
        this.lockingAnchors.remove(anchor);
    }

    public void removeAllLockingAnchor() {
        this.lockingAnchors.clear();
    }

    public ToolWindowAnchor[] getLockingAnchors() {
        return this.lockingAnchors.toArray(new ToolWindowAnchor[this.lockingAnchors.size()]);
    }

    public boolean containsLockingAnchor(ToolWindowAnchor anchor) {
        return this.lockingAnchors.contains(anchor);
    }

    public void ensureVisible() {
        this.toolWindowDescriptor.getToolBar().ensureVisible(this.toolWindowDescriptor.getRepresentativeAnchor());
    }

    public void showMessage(Icon icon, String message) {
        this.ensureRepresentativeAnchor();
        this.ensureVisible();
        this.firePropertyChangeEvent("showMessage", null, new Object[]{icon, message});
    }

    public void setVisible(boolean visible) {
        if (this.toolWindow.getType() == ToolWindowType.FLOATING_FREE) {
            return;
        }
        if (this.visible == visible) {
            return;
        }
        boolean old = this.visible;
        this.visible = visible;
        this.firePropertyChangeEvent("visible", old, visible);
    }

    public boolean isVisible() {
        return this.toolWindow.getType() != ToolWindowType.FLOATING_FREE && this.visible;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = this.toolWindow.getId();
        }
        if (title != null && title.equals(this.title)) {
            return;
        }
        String old = this.title;
        this.title = title;
        this.firePropertyChangeEvent("title", old, title);
    }

    public String getTitle() {
        return this.title;
    }

    public void setIcon(Icon icon) {
        if (icon == null) {
            icon = this.toolWindow.getIcon();
        }
        if (icon != null && icon.equals(this.icon)) {
            return;
        }
        Icon old = this.icon;
        this.icon = icon;
        this.firePropertyChangeEvent("icon", old, icon);
    }

    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.toolWindow = null;
        this.toolWindowDescriptor = null;
    }

    protected void ensureRepresentativeAnchor() {
        if (this.toolWindowDescriptor.getRepresentativeAnchor() == null) {
            this.setVisible(true);
        }
    }
}

