/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.descriptors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAction;
import org.noos.xing.mydoggy.ToolWindowTypeDescriptor;
import org.noos.xing.mydoggy.plaf.PropertyChangeEventSource;
import org.noos.xing.mydoggy.plaf.actions.PlafToolWindowAction;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;

public abstract class DefaultToolWindowTypeDescriptor
extends PropertyChangeEventSource
implements ToolWindowTypeDescriptor,
PropertyChangeListener {
    protected ToolWindowDescriptor toolWindowDescriptor;
    protected boolean enabled;
    protected boolean animating;
    protected boolean autoHide;
    protected boolean idVisibleOnTitleBar;
    protected boolean titleBarButtonsVisible;
    protected boolean titleBarVisible;
    protected boolean hideRepresentativeButtonOnVisible;
    protected Map<String, ToolWindowAction> toolWindowActionMap;

    protected DefaultToolWindowTypeDescriptor() {
        this.enabled = true;
        this.animating = true;
        this.autoHide = false;
        this.idVisibleOnTitleBar = true;
        this.hideRepresentativeButtonOnVisible = false;
        this.titleBarButtonsVisible = true;
        this.titleBarVisible = true;
        this.toolWindowActionMap = new HashMap<String, ToolWindowAction>();
    }

    public DefaultToolWindowTypeDescriptor(ToolWindowDescriptor toolWindowDescriptor, DefaultToolWindowTypeDescriptor parent, boolean enabled, boolean animating, boolean autoHide, boolean idVisibleOnTitleBar, boolean hideRepresentativeButtonOnVisible, boolean titleBarButtonsVisible, boolean titleBarVisible) {
        super(toolWindowDescriptor.getManager().getFirePublicEvent());
        this.toolWindowDescriptor = toolWindowDescriptor;
        this.animating = animating;
        this.autoHide = autoHide;
        this.enabled = enabled;
        this.idVisibleOnTitleBar = idVisibleOnTitleBar;
        this.hideRepresentativeButtonOnVisible = hideRepresentativeButtonOnVisible;
        this.titleBarButtonsVisible = titleBarButtonsVisible;
        this.titleBarVisible = titleBarVisible;
        this.toolWindowActionMap = new HashMap<String, ToolWindowAction>();
        parent.addPropertyChangeListener(this);
        toolWindowDescriptor.getCleaner().addCleaner(this);
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        boolean old = this.enabled;
        this.enabled = enabled;
        this.firePropertyChangeEvent("enabled", old, enabled);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAnimating() {
        return this.animating;
    }

    public void setAnimating(boolean animating) {
        if (this.animating == animating) {
            return;
        }
        boolean old = this.animating;
        this.animating = animating;
        this.firePropertyChangeEvent("animating", old, animating);
    }

    public void setAutoHide(boolean autoHide) {
        boolean old = this.autoHide;
        this.autoHide = autoHide;
        this.firePropertyChangeEvent("autoHide", old, autoHide);
    }

    public boolean isAutoHide() {
        return this.autoHide;
    }

    public void setIdVisibleOnTitleBar(boolean idVisibleOnTitleBar) {
        if (this.idVisibleOnTitleBar == idVisibleOnTitleBar) {
            return;
        }
        boolean old = this.idVisibleOnTitleBar;
        this.idVisibleOnTitleBar = idVisibleOnTitleBar;
        this.firePropertyChangeEvent("idVisibleOnTitleBar", old, idVisibleOnTitleBar);
    }

    public boolean isIdVisibleOnTitleBar() {
        return this.idVisibleOnTitleBar;
    }

    public void setTitleBarButtonsVisible(boolean titleBarButtonsVisible) {
        if (this.titleBarButtonsVisible == titleBarButtonsVisible) {
            return;
        }
        boolean old = this.titleBarButtonsVisible;
        this.titleBarButtonsVisible = titleBarButtonsVisible;
        this.firePropertyChangeEvent("titleBarButtonsVisible", old, titleBarButtonsVisible);
    }

    public boolean isTitleBarButtonsVisible() {
        return this.titleBarButtonsVisible;
    }

    public void setTitleBarVisible(boolean titleBarVisible) {
        if (this.titleBarVisible == titleBarVisible) {
            return;
        }
        boolean old = this.titleBarVisible;
        this.titleBarVisible = titleBarVisible;
        this.firePropertyChangeEvent("titleBarVisible", old, titleBarVisible);
    }

    public boolean isTitleBarVisible() {
        return this.titleBarVisible;
    }

    public void setHideRepresentativeButtonOnVisible(boolean hideRepresentativeButtonOnVisible) {
        if (this.hideRepresentativeButtonOnVisible == hideRepresentativeButtonOnVisible) {
            return;
        }
        boolean old = this.hideRepresentativeButtonOnVisible;
        this.hideRepresentativeButtonOnVisible = hideRepresentativeButtonOnVisible;
        this.firePropertyChangeEvent("hideRepresentativeButtonOnVisible", old, hideRepresentativeButtonOnVisible);
    }

    public boolean isHideRepresentativeButtonOnVisible() {
        return this.hideRepresentativeButtonOnVisible;
    }

    public ToolWindowAction getToolWindowAction(String id) {
        return this.toolWindowActionMap.get(id);
    }

    public void addToolWindowAction(ToolWindowAction toolWindowAction) {
        this.addToolWindowAction(toolWindowAction, -1);
    }

    public void addToolWindowAction(ToolWindowAction toolWindowAction, int index) {
        if (toolWindowAction == null) {
            throw new IllegalArgumentException("The action cannot be null.");
        }
        ToolWindowAction oldToolWindowAction = this.toolWindowActionMap.get(toolWindowAction.getId());
        if (oldToolWindowAction != null && !this.toolWindowDescriptor.containsToolWindowAction((ToolWindowTypeDescriptor)this, oldToolWindowAction.getId())) {
            oldToolWindowAction.setToolWindow(null);
        }
        if (!this.toolWindowDescriptor.containsToolWindowAction((ToolWindowTypeDescriptor)this, toolWindowAction)) {
            toolWindowAction.setToolWindow((ToolWindow)this.toolWindowDescriptor.getToolWindow());
        }
        if (toolWindowAction.getValue("constraint") == null) {
            toolWindowAction.putValue("constraint", (Object)index);
        }
        this.toolWindowActionMap.put(toolWindowAction.getId(), toolWindowAction);
        this.firePropertyChangeEvent("toolWindowAction", oldToolWindowAction, toolWindowAction, new Object[]{this});
    }

    public ToolWindowAction[] getToolWindowActions() {
        return this.toolWindowActionMap.values().toArray(new ToolWindowAction[0]);
    }

    public void removeToolWindowAction(String id) {
        if (this.toolWindowActionMap.get(id) instanceof PlafToolWindowAction) {
            throw new IllegalArgumentException("Cannot remove a system action.");
        }
        ToolWindowAction toolWindowAction = this.toolWindowActionMap.remove(id);
        if (toolWindowAction != null && !this.toolWindowDescriptor.containsToolWindowAction((ToolWindowTypeDescriptor)this, toolWindowAction.getId())) {
            toolWindowAction.setToolWindow(null);
        }
        this.firePropertyChangeEvent("toolWindowAction", toolWindowAction, null, new Object[]{this});
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("idVisibleOnTitleBar".equals(evt.getPropertyName())) {
            this.setIdVisibleOnTitleBar((Boolean)evt.getNewValue());
        } else if ("autoHide".equals(evt.getPropertyName())) {
            this.setAutoHide((Boolean)evt.getNewValue());
        } else if ("enabled".equals(evt.getPropertyName())) {
            this.setEnabled((Boolean)evt.getNewValue());
        } else if ("animating".equals(evt.getPropertyName())) {
            this.setAnimating((Boolean)evt.getNewValue());
        } else if ("hideRepresentativeButtonOnVisible".equals(evt.getPropertyName())) {
            this.setHideRepresentativeButtonOnVisible((Boolean)evt.getNewValue());
        } else if ("titleBarButtonsVisible".equals(evt.getPropertyName())) {
            this.setTitleBarButtonsVisible((Boolean)evt.getNewValue());
        } else if ("titleBarVisible".equals(evt.getPropertyName())) {
            this.setTitleBarVisible((Boolean)evt.getNewValue());
        }
    }
}

