/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAction;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.actions.PlafToolWindowAction;
import org.noos.xing.mydoggy.plaf.ui.util.DynamicPropertyChangeListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class PinToolWindowAction
extends ToolWindowAction
implements PlafToolWindowAction {
    protected PropertyChangeListener propertyChangeListener;

    public PinToolWindowAction() {
        super("PIN_ACTION_ID", UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.autoHideOff.inactive"));
        this.setTooltipText(SwingUtil.getString("@@tool.tooltip.unpin"));
        this.putValue("constraint", 2);
    }

    public void setToolWindow(ToolWindow toolWindow) {
        if (toolWindow == null) {
            this.toolWindow.removePropertyChangeListener("autoHide", this.propertyChangeListener);
            this.toolWindow.removePropertyChangeListener("active", this.propertyChangeListener);
            this.toolWindow.removePropertyChangeListener("type", this.propertyChangeListener);
            this.propertyChangeListener = null;
            super.setToolWindow(toolWindow);
        } else {
            super.setToolWindow(toolWindow);
            this.propertyChangeListener = new PropertyListener();
            this.setActionName("toolWindow.pinButton." + toolWindow.getId());
            toolWindow.addPropertyChangeListener("autoHide", this.propertyChangeListener);
            toolWindow.addPropertyChangeListener("active", this.propertyChangeListener);
            toolWindow.addPropertyChangeListener("type", this.propertyChangeListener);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (!"menu.pinned".equals(e.getActionCommand())) {
            this.toolWindow.setActive(true);
        }
        this.toolWindow.setAutoHide(!this.toolWindow.isAutoHide());
    }

    public JMenuItem getMenuItem() {
        if (this.menuItem == null) {
            this.menuItem = new JCheckBoxMenuItem(null, !this.toolWindow.isAutoHide());
            this.menuItem.setText(SwingUtil.getString("@@tool.mode.pinned"));
            this.menuItem.setActionCommand("menu.pinned");
            this.menuItem.addActionListener((ActionListener)((Object)this));
        }
        return this.menuItem;
    }

    public class PropertyListener
    extends DynamicPropertyChangeListener {
        public void onAutoHide(PropertyChangeEvent evt) {
            boolean newValue = (Boolean)evt.getNewValue();
            if (newValue) {
                PinToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.autoHideOn"));
                PinToolWindowAction.this.putValue("ShortDescription", SwingUtil.getString("@@tool.tooltip.pin"));
            } else {
                PinToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.autoHideOff"));
                PinToolWindowAction.this.putValue("ShortDescription", SwingUtil.getString("@@tool.tooltip.unpin"));
            }
        }

        public void onActive(PropertyChangeEvent evt) {
            boolean active = (Boolean)evt.getNewValue();
            if (active) {
                if (PinToolWindowAction.this.toolWindow.isAutoHide()) {
                    PinToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.autoHideOn"));
                } else {
                    PinToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.autoHideOff"));
                }
            } else if (PinToolWindowAction.this.toolWindow.isAutoHide()) {
                PinToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.autoHideOn.inactive"));
            } else {
                PinToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.autoHideOff.inactive"));
            }
        }

        public void onType(PropertyChangeEvent evt) {
            ToolWindowType type = (ToolWindowType)evt.getNewValue();
            switch (type) {
                case DOCKED: 
                case FLOATING_LIVE: {
                    PinToolWindowAction.this.setVisible(true);
                    break;
                }
                case SLIDING: {
                    PinToolWindowAction.this.setVisible(false);
                    break;
                }
                case FLOATING: 
                case FLOATING_FREE: {
                    PinToolWindowAction.this.setVisible(true);
                }
            }
        }
    }
}

