/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAction;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.actions.PlafToolWindowAction;
import org.noos.xing.mydoggy.plaf.ui.util.DynamicPropertyChangeListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class FloatingToolWindowAction
extends ToolWindowAction
implements PlafToolWindowAction {
    protected ToolWindowType oldType;
    protected boolean floatingWindow;
    protected JCheckBoxMenuItem menuItem;
    protected PropertyChangeListener propertyChangeListener;

    public FloatingToolWindowAction() {
        super("FLOATING_ACTION_ID", UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.floating.inactive"));
        this.setTooltipText(SwingUtil.getString("@@tool.tooltip.float"));
        this.putValue("constraint", 3);
    }

    public void setToolWindow(ToolWindow toolWindow) {
        if (toolWindow == null) {
            this.toolWindow.getTypeDescriptor(ToolWindowType.FLOATING).removePropertyChangeListener("enabled", this.propertyChangeListener);
            this.toolWindow.removePropertyChangeListener("type", this.propertyChangeListener);
            this.toolWindow.removePropertyChangeListener("active", this.propertyChangeListener);
            this.propertyChangeListener = null;
            super.setToolWindow(toolWindow);
        } else {
            super.setToolWindow(toolWindow);
            this.propertyChangeListener = new PropertyListener();
            this.setActionName("toolWindow.floatingButton." + toolWindow.getId());
            toolWindow.getTypeDescriptor(ToolWindowType.FLOATING).addPropertyChangeListener("enabled", this.propertyChangeListener);
            toolWindow.addPropertyChangeListener("type", this.propertyChangeListener);
            toolWindow.addPropertyChangeListener("active", this.propertyChangeListener);
        }
    }

    public void actionPerformed(ActionEvent e) {
        ToolWindowType type = this.toolWindow.getType();
        switch (type) {
            case FLOATING: 
            case FLOATING_FREE: {
                this.toolWindow.setType(this.oldType != null ? this.oldType : ToolWindowType.DOCKED);
                break;
            }
            default: {
                this.toolWindow.setType(this.floatingWindow ? ToolWindowType.FLOATING_FREE : ToolWindowType.FLOATING);
            }
        }
    }

    public JMenuItem getMenuItem() {
        if (this.menuItem == null) {
            this.menuItem = new JCheckBoxMenuItem(null, this.toolWindow.getType() == ToolWindowType.FLOATING);
            this.menuItem.setText(SwingUtil.getString("@@tool.mode.floating"));
            this.menuItem.setActionCommand("menu.floating");
            this.menuItem.addActionListener((ActionListener)((Object)this));
        }
        switch (this.toolWindow.getType()) {
            case DOCKED: 
            case SLIDING: {
                this.menuItem.setVisible(this.toolWindow.getTypeDescriptor(ToolWindowType.FLOATING).isEnabled());
                break;
            }
            case FLOATING_LIVE: {
                this.menuItem.setState(false);
                this.menuItem.setVisible(this.toolWindow.getTypeDescriptor(ToolWindowType.FLOATING).isEnabled());
            }
        }
        return this.menuItem;
    }

    public class PropertyListener
    extends DynamicPropertyChangeListener {
        public void onEnabled(PropertyChangeEvent evt) {
            FloatingToolWindowAction.this.setVisible((Boolean)evt.getNewValue());
        }

        public void onType(PropertyChangeEvent evt) {
            ToolWindowType type = (ToolWindowType)evt.getNewValue();
            if (FloatingToolWindowAction.this.menuItem != null) {
                FloatingToolWindowAction.this.menuItem.setState(type == ToolWindowType.FLOATING);
            }
            switch (type) {
                case DOCKED: 
                case FLOATING_LIVE: {
                    FloatingToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.floating"));
                    FloatingToolWindowAction.this.setTooltipText(SwingUtil.getString("@@tool.tooltip.float"));
                    FloatingToolWindowAction.this.setVisible(FloatingToolWindowAction.this.toolWindow.getTypeDescriptor(ToolWindowType.FLOATING).isEnabled());
                    break;
                }
                case SLIDING: {
                    FloatingToolWindowAction.this.setVisible(FloatingToolWindowAction.this.toolWindow.getTypeDescriptor(ToolWindowType.FLOATING).isEnabled());
                    break;
                }
                case FLOATING: 
                case FLOATING_FREE: {
                    FloatingToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.fix"));
                    FloatingToolWindowAction.this.setTooltipText(SwingUtil.getString("@@tool.tooltip.fix"));
                    FloatingToolWindowAction.this.setVisible(true);
                }
            }
            if (evt.getOldValue() == ToolWindowType.FLOATING_FREE || evt.getNewValue() == ToolWindowType.FLOATING_FREE) {
                FloatingToolWindowAction.this.floatingWindow = true;
            } else if (evt.getOldValue() == ToolWindowType.FLOATING || evt.getNewValue() == ToolWindowType.FLOATING) {
                FloatingToolWindowAction.this.floatingWindow = false;
            }
            if (evt.getNewValue() != ToolWindowType.FLOATING && evt.getNewValue() != ToolWindowType.FLOATING_FREE) {
                return;
            }
            FloatingToolWindowAction.this.oldType = (ToolWindowType)evt.getOldValue();
        }

        public void onActive(PropertyChangeEvent evt) {
            boolean active = (Boolean)evt.getNewValue();
            if (active) {
                if (FloatingToolWindowAction.this.toolWindow.getType() == ToolWindowType.FLOATING || FloatingToolWindowAction.this.toolWindow.getType() == ToolWindowType.FLOATING_FREE) {
                    FloatingToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.fix"));
                } else {
                    FloatingToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.floating"));
                }
            } else if (FloatingToolWindowAction.this.toolWindow.getType() == ToolWindowType.FLOATING || FloatingToolWindowAction.this.toolWindow.getType() == ToolWindowType.FLOATING_FREE) {
                FloatingToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.fix.inactive"));
            } else {
                FloatingToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.floating.inactive"));
            }
        }
    }
}

