/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAction;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.actions.PlafToolWindowAction;
import org.noos.xing.mydoggy.plaf.ui.util.DynamicPropertyChangeListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class FloatingLiveToolWindowAction
extends ToolWindowAction
implements PlafToolWindowAction {
    protected JCheckBoxMenuItem menuItem;
    protected PropertyChangeListener propertyChangeListener;

    public FloatingLiveToolWindowAction() {
        super("FLOATING_LIVE_ACTION_ID");
        this.setTooltipText(SwingUtil.getString("@@tool.tooltip.floatingLive"));
        this.setVisibleOnMenuBar(true);
        this.setVisibleOnTitleBar(false);
    }

    public void setToolWindow(ToolWindow toolWindow) {
        if (toolWindow == null) {
            this.toolWindow.getTypeDescriptor(ToolWindowType.FLOATING_LIVE).removePropertyChangeListener("enabled", this.propertyChangeListener);
            this.toolWindow.removePropertyChangeListener("type", this.propertyChangeListener);
            this.propertyChangeListener = null;
            super.setToolWindow(toolWindow);
        } else {
            super.setToolWindow(toolWindow);
            this.propertyChangeListener = new PropertyListener();
            this.setActionName("toolWindow.popup.floatingLive." + toolWindow.getId());
            toolWindow.getTypeDescriptor(ToolWindowType.FLOATING_LIVE).addPropertyChangeListener("enabled", this.propertyChangeListener);
            toolWindow.addPropertyChangeListener("type", this.propertyChangeListener);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.toolWindow.setType(this.toolWindow.getType() != ToolWindowType.FLOATING_LIVE ? ToolWindowType.FLOATING_LIVE : ToolWindowType.DOCKED);
    }

    public JMenuItem getMenuItem() {
        if (this.menuItem == null) {
            this.menuItem = new JCheckBoxMenuItem(null, this.toolWindow.getType() == ToolWindowType.FLOATING_LIVE);
            this.menuItem.setName("toolWindow.popup.floatingLive." + this.toolWindow.getId());
            this.menuItem.setText(SwingUtil.getString("@@tool.mode.floatingLive"));
            this.menuItem.setActionCommand("menu.floatingLive");
            this.menuItem.addActionListener((ActionListener)((Object)this));
        }
        switch (this.toolWindow.getType()) {
            case DOCKED: 
            case SLIDING: 
            case FLOATING: {
                this.menuItem.setState(false);
                this.menuItem.setVisible(this.toolWindow.getTypeDescriptor(ToolWindowType.FLOATING_LIVE).isEnabled());
            }
        }
        return this.menuItem;
    }

    public class PropertyListener
    extends DynamicPropertyChangeListener {
        public void onEnabled(PropertyChangeEvent evt) {
            FloatingLiveToolWindowAction.this.setVisibleOnMenuBar((Boolean)evt.getNewValue());
        }

        public void onType(PropertyChangeEvent evt) {
            ToolWindowType type = (ToolWindowType)evt.getNewValue();
            if (FloatingLiveToolWindowAction.this.menuItem != null) {
                FloatingLiveToolWindowAction.this.menuItem.setState(type == ToolWindowType.FLOATING_LIVE);
            }
        }
    }
}

