/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAction;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.actions.PlafToolWindowAction;
import org.noos.xing.mydoggy.plaf.ui.util.DynamicPropertyChangeListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class DockToolWindowAction
extends ToolWindowAction
implements PlafToolWindowAction {
    protected JCheckBoxMenuItem menuItem;
    protected PropertyChangeListener propertyChangeListener;

    public DockToolWindowAction() {
        super("DOCK_ACTION_ID", UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.docked.inactive"));
        this.setTooltipText(SwingUtil.getString("@@tool.tooltip.undock"));
        this.putValue("constraint", 4);
    }

    public void setToolWindow(ToolWindow toolWindow) {
        if (toolWindow == null) {
            this.toolWindow.getTypeDescriptor(ToolWindowType.SLIDING).removePropertyChangeListener("enabled", this.propertyChangeListener);
            this.toolWindow.removePropertyChangeListener("active", this.propertyChangeListener);
            this.toolWindow.removePropertyChangeListener("type", this.propertyChangeListener);
            this.propertyChangeListener = null;
            super.setToolWindow(toolWindow);
        } else {
            super.setToolWindow(toolWindow);
            this.propertyChangeListener = new PropertyListener();
            this.setActionName("toolWindow.dockButton." + toolWindow.getId());
            toolWindow.getTypeDescriptor(ToolWindowType.SLIDING).addPropertyChangeListener("enabled", this.propertyChangeListener);
            toolWindow.addPropertyChangeListener("active", this.propertyChangeListener);
            toolWindow.addPropertyChangeListener("type", this.propertyChangeListener);
        }
    }

    public void actionPerformed(ActionEvent e) {
        ToolWindowType type = this.toolWindow.getType();
        if (type == ToolWindowType.DOCKED) {
            this.toolWindow.setType(ToolWindowType.SLIDING);
        } else if (type == ToolWindowType.SLIDING || type == ToolWindowType.FLOATING_LIVE) {
            this.toolWindow.setType(ToolWindowType.DOCKED);
        }
    }

    public JMenuItem getMenuItem() {
        if (this.menuItem == null) {
            this.menuItem = new JCheckBoxMenuItem(null, this.toolWindow.getType() == ToolWindowType.DOCKED);
            this.menuItem.setText(SwingUtil.getString("@@tool.mode.docked"));
            this.menuItem.setActionCommand("menu.docked");
            this.menuItem.addActionListener((ActionListener)((Object)this));
        }
        switch (this.toolWindow.getType()) {
            case DOCKED: {
                this.menuItem.setVisible(this.toolWindow.getTypeDescriptor(ToolWindowType.SLIDING).isEnabled());
                break;
            }
            case FLOATING_LIVE: {
                this.menuItem.setState(false);
            }
        }
        return this.menuItem;
    }

    public class PropertyListener
    extends DynamicPropertyChangeListener {
        public void onEnabled(PropertyChangeEvent evt) {
            DockToolWindowAction.this.setVisible((Boolean)evt.getNewValue());
        }

        public void onActive(PropertyChangeEvent evt) {
            boolean active = (Boolean)evt.getNewValue();
            if (active) {
                if (DockToolWindowAction.this.toolWindow.getType() == ToolWindowType.SLIDING || DockToolWindowAction.this.toolWindow.getType() == ToolWindowType.FLOATING_LIVE) {
                    DockToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.docked"));
                } else {
                    DockToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.sliding"));
                }
            } else if (DockToolWindowAction.this.toolWindow.getType() == ToolWindowType.SLIDING || DockToolWindowAction.this.toolWindow.getType() == ToolWindowType.FLOATING_LIVE) {
                DockToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.docked.inactive"));
            } else {
                DockToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.sliding.inactive"));
            }
        }

        public void onType(PropertyChangeEvent evt) {
            ToolWindowType type = (ToolWindowType)evt.getNewValue();
            if (DockToolWindowAction.this.menuItem != null) {
                DockToolWindowAction.this.menuItem.setState(type == ToolWindowType.DOCKED);
                DockToolWindowAction.this.menuItem.setVisible(type != ToolWindowType.FLOATING);
            }
            switch (type) {
                case DOCKED: {
                    DockToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.sliding"));
                    DockToolWindowAction.this.putValue("ShortDescription", SwingUtil.getString("@@tool.tooltip.undock"));
                    DockToolWindowAction.this.setVisible(DockToolWindowAction.this.toolWindow.getTypeDescriptor(ToolWindowType.SLIDING).isEnabled());
                    break;
                }
                case FLOATING_LIVE: {
                    DockToolWindowAction.this.setIcon(UIManager.getIcon("ToolWindowTitleButtonPanelUI.icon.docked"));
                    DockToolWindowAction.this.putValue("ShortDescription", SwingUtil.getString("@@tool.tooltip.dock"));
                    DockToolWindowAction.this.setVisible(DockToolWindowAction.this.toolWindow.getTypeDescriptor(ToolWindowType.SLIDING).isEnabled());
                    break;
                }
                case SLIDING: {
                    DockToolWindowAction.this.putValue("ShortDescription", SwingUtil.getString("@@tool.tooltip.dock"));
                    DockToolWindowAction.this.setVisible(DockToolWindowAction.this.toolWindow.getTypeDescriptor(ToolWindowType.SLIDING).isEnabled());
                    break;
                }
                case FLOATING: 
                case FLOATING_FREE: {
                    DockToolWindowAction.this.setVisible(false);
                }
            }
        }
    }
}

