/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.PropertyChangeEventSource;
import org.noos.xing.mydoggy.plaf.cleaner.CleanerAggregator;
import org.noos.xing.mydoggy.plaf.cleaner.CleanerProvider;
import org.noos.xing.mydoggy.plaf.cleaner.DefaultCleanerAggregator;

public class MyDoggyToolWindowTab
extends PropertyChangeEventSource
implements ToolWindowTab,
CleanerProvider {
    protected boolean root;
    protected String id;
    protected ToolWindow owner;
    protected String title;
    protected Icon icon;
    protected Component component;
    protected boolean selected;
    protected boolean closeable;
    protected boolean minimizable;
    protected boolean flash;
    protected boolean maximized;
    protected boolean minimized;
    protected Dockable dockable;
    protected PropertyChangeListener delegatorListener;
    protected CleanerAggregator cleanerAggregator;

    public MyDoggyToolWindowTab(ToolWindow owner, boolean root, String title, Icon icon, Component component, Dockable dockable) {
        super(((MyDoggyToolWindowManager)owner.getDockableManager()).getFirePublicEvent());
        this.root = root;
        this.id = "" + System.nanoTime();
        this.owner = owner;
        this.title = title;
        this.icon = icon;
        this.component = component;
        this.selected = false;
        this.closeable = !root;
        this.minimizable = true;
        this.dockable = dockable;
        this.flash = false;
        this.maximized = false;
        this.minimized = false;
        if (dockable != null) {
            this.delegatorListener = new DelegatorListener();
            dockable.addPropertyChangeListener(this.delegatorListener);
            this.addPropertyChangeListener(new DelegateListener());
        }
        this.cleanerAggregator = new DefaultCleanerAggregator();
    }

    public ToolWindow getDockableManager() {
        return this.owner;
    }

    public ToolWindow getOwner() {
        return this.owner;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title != null && title.equals(this.getTitle())) {
            return;
        }
        String old = this.title;
        this.title = title;
        this.firePropertyChangeEvent("title", old, title);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        if (this.icon == icon) {
            return;
        }
        Icon old = this.icon;
        this.icon = icon;
        this.firePropertyChangeEvent("icon", old, icon);
    }

    public Component getComponent() {
        return this.component;
    }

    public boolean isFlashing() {
        return this.flash;
    }

    public void setDetached(boolean detached) {
        throw new IllegalStateException("This dockable doesn't support detached mode.");
    }

    public boolean isDetached() {
        return false;
    }

    public void setFlashing(boolean flash) {
        if (flash && this.owner.isVisible() && this.isSelected()) {
            return;
        }
        if (this.flash == flash) {
            return;
        }
        boolean old = this.flash;
        this.flash = flash;
        this.firePropertyChangeEvent("flash", old, flash);
    }

    public void setFlashing(int duration) {
        if (this.isSelected()) {
            return;
        }
        if (this.flash) {
            return;
        }
        this.flash = true;
        this.firePropertyChangeEvent("flash", false, true, duration);
    }

    public void setComponent(Component component) {
        if (this.component == component) {
            return;
        }
        Component old = this.component;
        this.component = component;
        this.firePropertyChangeEvent("component", old, component);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        if (this.selected == selected) {
            return;
        }
        if (selected && this.isMinimized()) {
            this.setMinimized(false);
        }
        boolean old = this.selected;
        this.selected = selected;
        this.firePropertyChangeEvent("selected", old, selected);
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setCloseable(boolean closeable) {
        if (this.closeable == closeable) {
            return;
        }
        boolean old = this.closeable;
        this.closeable = closeable;
        this.firePropertyChangeEvent("closeable", old, closeable);
    }

    public boolean isMinimizable() {
        return this.minimizable;
    }

    public void setMinimizable(boolean minimizable) {
        if (this.minimizable == minimizable) {
            return;
        }
        boolean old = this.minimizable;
        this.minimizable = minimizable;
        this.firePropertyChangeEvent("minimizable", old, minimizable);
    }

    public void setMaximized(boolean maximized) {
        if (this.maximized == maximized) {
            return;
        }
        boolean old = this.maximized;
        this.maximized = maximized;
        this.firePropertyChangeEvent("maximized", old, maximized);
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public void setMinimized(boolean minimized) {
        if (this.minimized == minimized) {
            return;
        }
        boolean old = this.minimized;
        this.minimized = minimized;
        this.firePropertyChangeEvent("minimized", old, minimized);
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void ensureVisible() {
        if (!this.isMinimized()) {
            this.firePlafPropertyChangeEvent("ensureVisible", null, this);
        }
    }

    public boolean isVisible() {
        return this.isSelected();
    }

    public Dockable getDockableDelegator() {
        return this.dockable;
    }

    public String toString() {
        return "MyDoggyToolWindowTab{owner=" + this.owner + ", title='" + this.title + '\'' + ", icon=" + this.icon + ", component=" + this.component + ", selected=" + this.selected + ", closeable=" + this.closeable + ", maximized=" + this.maximized + ", toolWindow=" + this.dockable + '}';
    }

    public void cleanup() {
        if (this.dockable != null) {
            this.dockable.removePropertyChangeListener(this.delegatorListener);
        }
        this.cleanerAggregator.cleanup();
        super.cleanup();
    }

    public CleanerAggregator getCleanerAggregator() {
        return this.cleanerAggregator;
    }

    public class DelegateListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("flash".equals(propertyName)) {
                MyDoggyToolWindowTab.this.dockable.setFlashing(((Boolean)evt.getNewValue()).booleanValue());
            }
        }
    }

    public class DelegatorListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("selected".equals(propertyName)) {
                MyDoggyToolWindowTab.this.setSelected((Boolean)evt.getNewValue());
            } else if ("component".equals(propertyName)) {
                MyDoggyToolWindowTab.this.setComponent((Component)evt.getNewValue());
            } else if ("icon".equals(propertyName)) {
                MyDoggyToolWindowTab.this.setIcon((Icon)evt.getNewValue());
            } else if ("title".equals(propertyName)) {
                MyDoggyToolWindowTab.this.setTitle((String)evt.getNewValue());
            } else if ("closeable".equals(propertyName)) {
                MyDoggyToolWindowTab.this.setCloseable((Boolean)evt.getNewValue());
            } else if ("flash".equals(propertyName)) {
                MyDoggyToolWindowTab.this.setFlashing((Boolean)evt.getNewValue());
            }
        }
    }
}

