/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import org.noos.xing.mydoggy.MostRecentDescriptor;
import org.noos.xing.mydoggy.PushAwayMode;
import org.noos.xing.mydoggy.PushAwayModeDescriptor;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowManagerDescriptor;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.PropertyChangeEventSource;
import org.noos.xing.mydoggy.plaf.ui.util.SourceFilterPropertyChangeListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class MyDoggyToolWindowManagerDescriptor
extends PropertyChangeEventSource
implements ToolWindowManagerDescriptor,
PropertyChangeListener,
MostRecentDescriptor {
    protected PushAwayMode pushAwayMode;
    protected MyDoggyToolWindowManager manager;
    protected boolean numberingEnabled;
    protected boolean previewEnabled;
    protected boolean showUnavailableTools;
    protected Stack<ToolWindowAnchor> mostRecentStack;

    public MyDoggyToolWindowManagerDescriptor(MyDoggyToolWindowManager manager) {
        super(manager.getFirePublicEvent());
        this.manager = manager;
        this.pushAwayMode = PushAwayMode.VERTICAL;
        this.previewEnabled = true;
        this.numberingEnabled = true;
        this.showUnavailableTools = false;
        this.initMostRecent();
    }

    public void setPushAwayMode(PushAwayMode pushAwayMode) {
        if (this.pushAwayMode == pushAwayMode) {
            return;
        }
        this.changePushAwayMode(pushAwayMode);
        PushAwayMode old = this.pushAwayMode;
        this.pushAwayMode = pushAwayMode;
        this.firePropertyChangeEvent("pushAwayMode", old, this.pushAwayMode);
    }

    public PushAwayMode getPushAwayMode() {
        return this.pushAwayMode;
    }

    public PushAwayModeDescriptor getPushAwayModeDescriptor(PushAwayMode pushAwayMode) {
        switch (pushAwayMode) {
            case MOST_RECENT: {
                return this;
            }
        }
        throw new IllegalArgumentException("There isn't any manager for mode. [mode : " + pushAwayMode + "]");
    }

    public void setCornerComponent(ToolWindowManagerDescriptor.Corner corner, Component component) {
        this.manager.setCornerComponent(corner, component);
    }

    public void setNumberingEnabled(boolean numberingEnabled) {
        if (this.numberingEnabled == numberingEnabled) {
            return;
        }
        boolean old = this.numberingEnabled;
        this.numberingEnabled = numberingEnabled;
        this.firePropertyChangeEvent("numberingEnabled", old, numberingEnabled);
    }

    public boolean isNumberingEnabled() {
        return this.numberingEnabled;
    }

    public void setPreviewEnabled(boolean previewEnabled) {
        if (this.previewEnabled == previewEnabled) {
            return;
        }
        boolean old = this.previewEnabled;
        this.previewEnabled = previewEnabled;
        this.firePropertyChangeEvent("previewEnabled", old, previewEnabled);
    }

    public boolean isPreviewEnabled() {
        return this.previewEnabled;
    }

    public void setShowUnavailableTools(boolean showUnavailableTools) {
        if (this.showUnavailableTools == showUnavailableTools) {
            return;
        }
        boolean old = this.showUnavailableTools;
        this.showUnavailableTools = showUnavailableTools;
        this.firePropertyChangeEvent("showUnavailableTools", old, showUnavailableTools);
    }

    public boolean isShowUnavailableTools() {
        return this.showUnavailableTools;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("visible".equals(evt.getPropertyName()) && ((Boolean)evt.getNewValue()).booleanValue()) {
            this.addMostRecentAnchor(((ToolWindow)evt.getSource()).getAnchor());
            if (this.pushAwayMode == PushAwayMode.MOST_RECENT) {
                this.changePushAwayMode(PushAwayMode.MOST_RECENT);
            }
        }
    }

    public void append(ToolWindowAnchor ... anchors) {
        if (anchors == null) {
            throw new NullPointerException("anchors cannot be null.");
        }
        for (ToolWindowAnchor anchor : anchors) {
            this.addMostRecentAnchor(anchor);
        }
        if (this.pushAwayMode == PushAwayMode.MOST_RECENT) {
            this.changePushAwayMode(PushAwayMode.MOST_RECENT);
        }
    }

    public ToolWindowAnchor[] getMostRecentAnchors() {
        return this.mostRecentStack.toArray(new ToolWindowAnchor[this.mostRecentStack.size()]);
    }

    protected void initMostRecent() {
        this.mostRecentStack = new Stack();
        this.mostRecentStack.push(ToolWindowAnchor.TOP);
        this.mostRecentStack.push(ToolWindowAnchor.RIGHT);
        this.mostRecentStack.push(ToolWindowAnchor.BOTTOM);
        this.mostRecentStack.push(ToolWindowAnchor.LEFT);
        this.manager.addInternalPropertyChangeListener("visible", new SourceFilterPropertyChangeListener(this, ToolWindow.class));
    }

    protected void addMostRecentAnchor(ToolWindowAnchor target) {
        if (this.mostRecentStack.peek() == target) {
            return;
        }
        this.mostRecentStack.remove(0);
        Iterator iterator = this.mostRecentStack.iterator();
        while (iterator.hasNext()) {
            ToolWindowAnchor toolWindowAnchor = (ToolWindowAnchor)iterator.next();
            if (toolWindowAnchor != target) continue;
            iterator.remove();
        }
        this.mostRecentStack.push(target);
        if (this.mostRecentStack.size() < 4) {
            this.mrCheckForAnchor(ToolWindowAnchor.LEFT);
            this.mrCheckForAnchor(ToolWindowAnchor.RIGHT);
            this.mrCheckForAnchor(ToolWindowAnchor.BOTTOM);
            this.mrCheckForAnchor(ToolWindowAnchor.TOP);
        }
    }

    protected void changePushAwayMode(PushAwayMode pushAwayMode) {
        int leftSplitLocation = this.manager.getBar(ToolWindowAnchor.LEFT).getSplitDividerLocation();
        int rightSplitLocation = this.manager.getBar(ToolWindowAnchor.RIGHT).getSplitDividerLocation();
        int topSplitLocation = this.manager.getBar(ToolWindowAnchor.TOP).getSplitDividerLocation();
        int bottomSplitLocation = this.manager.getBar(ToolWindowAnchor.BOTTOM).getSplitDividerLocation();
        this.manager.getBar(ToolWindowAnchor.LEFT).getSplitPane().setRightComponent(null);
        this.manager.getBar(ToolWindowAnchor.RIGHT).getSplitPane().setLeftComponent(null);
        this.manager.getBar(ToolWindowAnchor.TOP).getSplitPane().setBottomComponent(null);
        this.manager.getBar(ToolWindowAnchor.BOTTOM).getSplitPane().setTopComponent(null);
        switch (pushAwayMode) {
            case HORIZONTAL: {
                this.manager.getBar(ToolWindowAnchor.LEFT).getSplitPane().setRightComponent(this.manager.getBar(ToolWindowAnchor.RIGHT).getSplitPane());
                this.manager.getBar(ToolWindowAnchor.RIGHT).getSplitPane().setLeftComponent(this.manager.getBar(ToolWindowAnchor.TOP).getSplitPane());
                this.manager.getBar(ToolWindowAnchor.TOP).getSplitPane().setBottomComponent(this.manager.getBar(ToolWindowAnchor.BOTTOM).getSplitPane());
                this.manager.getBar(ToolWindowAnchor.LEFT).getSplitPane().setResizeWeight(0.0);
                this.manager.getBar(ToolWindowAnchor.BOTTOM).getSplitPane().setResizeWeight(1.0);
                this.manager.getBar(ToolWindowAnchor.TOP).getSplitPane().setResizeWeight(0.0);
                this.manager.getBar(ToolWindowAnchor.RIGHT).getSplitPane().setResizeWeight(1.0);
                this.manager.add((Component)this.manager.getBar(ToolWindowAnchor.LEFT).getSplitPane(), "1,1,FULL,FULL");
                this.manager.setMainSplitPane(ToolWindowAnchor.BOTTOM);
                SwingUtil.repaintNow(this.manager);
                this.manager.getBar(ToolWindowAnchor.LEFT).setSplitDividerLocation(leftSplitLocation);
                SwingUtil.repaintNow(this.manager.getBar(ToolWindowAnchor.LEFT).getSplitPane());
                this.manager.getBar(ToolWindowAnchor.RIGHT).setSplitDividerLocation(rightSplitLocation);
                SwingUtil.repaintNow(this.manager.getBar(ToolWindowAnchor.RIGHT).getSplitPane());
                this.manager.getBar(ToolWindowAnchor.TOP).setSplitDividerLocation(topSplitLocation);
                SwingUtil.repaintNow(this.manager.getBar(ToolWindowAnchor.TOP).getSplitPane());
                this.manager.getBar(ToolWindowAnchor.BOTTOM).setSplitDividerLocation(bottomSplitLocation);
                SwingUtil.repaintNow(this.manager.getBar(ToolWindowAnchor.BOTTOM).getSplitPane());
                break;
            }
            case VERTICAL: {
                this.manager.getBar(ToolWindowAnchor.BOTTOM).getSplitPane().setTopComponent(this.manager.getBar(ToolWindowAnchor.TOP).getSplitPane());
                this.manager.getBar(ToolWindowAnchor.TOP).getSplitPane().setBottomComponent(this.manager.getBar(ToolWindowAnchor.LEFT).getSplitPane());
                this.manager.getBar(ToolWindowAnchor.LEFT).getSplitPane().setRightComponent(this.manager.getBar(ToolWindowAnchor.RIGHT).getSplitPane());
                this.manager.getBar(ToolWindowAnchor.LEFT).getSplitPane().setResizeWeight(0.0);
                this.manager.getBar(ToolWindowAnchor.BOTTOM).getSplitPane().setResizeWeight(1.0);
                this.manager.getBar(ToolWindowAnchor.TOP).getSplitPane().setResizeWeight(0.0);
                this.manager.getBar(ToolWindowAnchor.RIGHT).getSplitPane().setResizeWeight(1.0);
                this.manager.add((Component)this.manager.getBar(ToolWindowAnchor.BOTTOM).getSplitPane(), "1,1,FULL,FULL");
                this.manager.setMainSplitPane(ToolWindowAnchor.RIGHT);
                SwingUtil.repaintNow(this.manager);
                this.manager.getBar(ToolWindowAnchor.BOTTOM).setSplitDividerLocation(bottomSplitLocation);
                SwingUtil.repaintNow(this.manager.getBar(ToolWindowAnchor.BOTTOM).getSplitPane());
                this.manager.getBar(ToolWindowAnchor.TOP).setSplitDividerLocation(topSplitLocation);
                SwingUtil.repaintNow(this.manager.getBar(ToolWindowAnchor.TOP).getSplitPane());
                this.manager.getBar(ToolWindowAnchor.LEFT).setSplitDividerLocation(leftSplitLocation);
                SwingUtil.repaintNow(this.manager.getBar(ToolWindowAnchor.LEFT).getSplitPane());
                this.manager.getBar(ToolWindowAnchor.RIGHT).setSplitDividerLocation(rightSplitLocation);
                SwingUtil.repaintNow(this.manager.getBar(ToolWindowAnchor.RIGHT).getSplitPane());
                break;
            }
            case ANTICLOCKWISE: {
                this.manager.getBar(ToolWindowAnchor.LEFT).getSplitPane().setRightComponent(this.manager.getBar(ToolWindowAnchor.BOTTOM).getSplitPane());
                this.manager.getBar(ToolWindowAnchor.BOTTOM).getSplitPane().setTopComponent(this.manager.getBar(ToolWindowAnchor.RIGHT).getSplitPane());
                this.manager.getBar(ToolWindowAnchor.RIGHT).getSplitPane().setLeftComponent(this.manager.getBar(ToolWindowAnchor.TOP).getSplitPane());
                this.manager.getBar(ToolWindowAnchor.RIGHT).getSplitPane().setResizeWeight(1.0);
                this.manager.getBar(ToolWindowAnchor.LEFT).getSplitPane().setResizeWeight(0.0);
                this.manager.getBar(ToolWindowAnchor.BOTTOM).getSplitPane().setResizeWeight(1.0);
                this.manager.getBar(ToolWindowAnchor.TOP).getSplitPane().setResizeWeight(0.0);
                this.manager.add((Component)this.manager.getBar(ToolWindowAnchor.LEFT).getSplitPane(), "1,1,FULL,FULL");
                this.manager.setMainSplitPane(ToolWindowAnchor.TOP);
                SwingUtil.repaintNow(this.manager);
                this.manager.getBar(ToolWindowAnchor.LEFT).setSplitDividerLocation(leftSplitLocation);
                SwingUtil.repaintNow(this.manager.getBar(ToolWindowAnchor.LEFT).getSplitPane());
                this.manager.getBar(ToolWindowAnchor.BOTTOM).setSplitDividerLocation(bottomSplitLocation);
                SwingUtil.repaintNow(this.manager.getBar(ToolWindowAnchor.BOTTOM).getSplitPane());
                this.manager.getBar(ToolWindowAnchor.RIGHT).setSplitDividerLocation(rightSplitLocation);
                SwingUtil.repaintNow(this.manager.getBar(ToolWindowAnchor.RIGHT).getSplitPane());
                this.manager.getBar(ToolWindowAnchor.TOP).setSplitDividerLocation(topSplitLocation);
                SwingUtil.repaintNow(this.manager.getBar(ToolWindowAnchor.TOP).getSplitPane());
                break;
            }
            case MOST_RECENT: {
                this.setSplit((ToolWindowAnchor)this.mostRecentStack.get(3), (ToolWindowAnchor)this.mostRecentStack.get(2));
                this.setSplit((ToolWindowAnchor)this.mostRecentStack.get(2), (ToolWindowAnchor)this.mostRecentStack.get(1));
                this.setSplit((ToolWindowAnchor)this.mostRecentStack.get(1), (ToolWindowAnchor)this.mostRecentStack.get(0));
                this.manager.getBar(ToolWindowAnchor.RIGHT).getSplitPane().setResizeWeight(1.0);
                this.manager.getBar(ToolWindowAnchor.LEFT).getSplitPane().setResizeWeight(0.0);
                this.manager.getBar(ToolWindowAnchor.BOTTOM).getSplitPane().setResizeWeight(1.0);
                this.manager.getBar(ToolWindowAnchor.TOP).getSplitPane().setResizeWeight(0.0);
                this.manager.add((Component)this.manager.getBar((ToolWindowAnchor)this.mostRecentStack.get(3)).getSplitPane(), "1,1,FULL,FULL");
                this.manager.setMainSplitPane((ToolWindowAnchor)this.mostRecentStack.get(0));
                Hashtable<ToolWindowAnchor, Integer> tmp = new Hashtable<ToolWindowAnchor, Integer>();
                tmp.put(ToolWindowAnchor.LEFT, leftSplitLocation);
                tmp.put(ToolWindowAnchor.RIGHT, rightSplitLocation);
                tmp.put(ToolWindowAnchor.BOTTOM, bottomSplitLocation);
                tmp.put(ToolWindowAnchor.TOP, topSplitLocation);
                SwingUtil.repaintNow(this.manager);
                this.manager.getBar((ToolWindowAnchor)this.mostRecentStack.get(3)).setSplitDividerLocation((Integer)tmp.get(this.mostRecentStack.get(3)));
                SwingUtil.repaintNow(this.manager.getBar((ToolWindowAnchor)this.mostRecentStack.get(3)).getSplitPane());
                this.manager.getBar((ToolWindowAnchor)this.mostRecentStack.get(2)).setSplitDividerLocation((Integer)tmp.get(this.mostRecentStack.get(2)));
                SwingUtil.repaintNow(this.manager.getBar((ToolWindowAnchor)this.mostRecentStack.get(2)).getSplitPane());
                this.manager.getBar((ToolWindowAnchor)this.mostRecentStack.get(1)).setSplitDividerLocation((Integer)tmp.get(this.mostRecentStack.get(1)));
                SwingUtil.repaintNow(this.manager.getBar((ToolWindowAnchor)this.mostRecentStack.get(1)).getSplitPane());
                this.manager.getBar((ToolWindowAnchor)this.mostRecentStack.get(0)).setSplitDividerLocation((Integer)tmp.get(this.mostRecentStack.get(0)));
                SwingUtil.repaintNow(this.manager.getBar((ToolWindowAnchor)this.mostRecentStack.get(0)).getSplitPane());
            }
        }
    }

    protected void mrCheckForAnchor(ToolWindowAnchor target) {
        boolean found = false;
        for (ToolWindowAnchor toolWindowAnchor : this.mostRecentStack) {
            if (toolWindowAnchor != target) continue;
            found = true;
            break;
        }
        if (!found) {
            this.mostRecentStack.add(0, target);
        }
    }

    protected void setSplit(ToolWindowAnchor source, ToolWindowAnchor target) {
        this.setSplitComponent(source, this.manager.getBar(target).getSplitPane());
    }

    protected void setSplitComponent(ToolWindowAnchor source, Component cmp) {
        switch (source) {
            case LEFT: {
                this.manager.getBar(source).getSplitPane().setRightComponent(cmp);
                break;
            }
            case RIGHT: {
                this.manager.getBar(source).getSplitPane().setLeftComponent(cmp);
                break;
            }
            case TOP: {
                this.manager.getBar(source).getSplitPane().setBottomComponent(cmp);
                break;
            }
            case BOTTOM: {
                this.manager.getBar(source).getSplitPane().setTopComponent(cmp);
            }
        }
    }
}

