/*
 * Decompiled with CFR 0.152.
 */
package jscl.text;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.function.Constant;
import jscl.math.operator.Binomial;
import jscl.math.operator.Coefficient;
import jscl.math.operator.Derivative;
import jscl.math.operator.Division;
import jscl.math.operator.Elementary;
import jscl.math.operator.Expand;
import jscl.math.operator.FactorOf;
import jscl.math.operator.Factorize;
import jscl.math.operator.Graph;
import jscl.math.operator.Groebner;
import jscl.math.operator.IndefiniteIntegral;
import jscl.math.operator.Integral;
import jscl.math.operator.Limit;
import jscl.math.operator.Numeric;
import jscl.math.operator.Operator;
import jscl.math.operator.Product;
import jscl.math.operator.Quote;
import jscl.math.operator.Remainder;
import jscl.math.operator.Simplify;
import jscl.math.operator.Solve;
import jscl.math.operator.Substitute;
import jscl.math.operator.Sum;
import jscl.math.operator.Taylor;
import jscl.math.operator.matrix.Determinant;
import jscl.math.operator.matrix.Trace;
import jscl.math.operator.matrix.Transpose;
import jscl.math.operator.number.EulerPhi;
import jscl.math.operator.number.Mod;
import jscl.math.operator.number.ModInverse;
import jscl.math.operator.number.ModPow;
import jscl.math.operator.number.PrimitiveRoots;
import jscl.math.operator.product.ComplexProduct;
import jscl.math.operator.product.GeometricProduct;
import jscl.math.operator.product.MatrixProduct;
import jscl.math.operator.product.QuaternionProduct;
import jscl.math.operator.product.TensorProduct;
import jscl.math.operator.product.VectorProduct;
import jscl.math.operator.vector.Curl;
import jscl.math.operator.vector.Dalembertian;
import jscl.math.operator.vector.Del;
import jscl.math.operator.vector.Divergence;
import jscl.math.operator.vector.Grad;
import jscl.math.operator.vector.Jacobian;
import jscl.math.operator.vector.Laplacian;
import jscl.text.Identifier;
import jscl.text.ParameterList;
import jscl.text.ParseException;
import jscl.text.Parser;

public class OperatorParser
extends Parser {
    public static final Parser parser = new OperatorParser();
    private static String[] na = new String[]{"d", "grad", "divergence", "curl", "jacobian", "laplacian", "dalembertian", "del", "vector", "complex", "quaternion", "geometric", "matrix", "tensor", "transpose", "trace", "determinant", "C", "coef", "solve", "subst", "graph", "expand", "factorize", "elementary", "simplify", "numeric", "quote", "limit", "taylor", "sum", "product", "integral", "groebner", "quotient", "rem", "factorof", "mod", "modpow", "modinv", "eulerphi", "primitiveroots"};

    private OperatorParser() {
    }

    @Override
    public Object parse(String string, int[] nArray) throws ParseException {
        Generic[] genericArray;
        int n = nArray[0];
        String string2 = (String)Identifier.parser.parse(string, nArray);
        if (!OperatorParser.valid(string2)) {
            nArray[0] = n;
            throw new ParseException();
        }
        try {
            genericArray = (Generic[])ParameterList.parser.parse(string, nArray);
        }
        catch (ParseException parseException) {
            nArray[0] = n;
            throw parseException;
        }
        Operator operator = null;
        if (string2.compareTo("d") == 0) {
            operator = new Derivative(genericArray[0], genericArray[1], genericArray.length > 2 ? genericArray[2] : genericArray[1], genericArray.length > 3 ? genericArray[3] : JSCLInteger.valueOf(1L));
        } else if (string2.compareTo("grad") == 0) {
            operator = new Grad(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("divergence") == 0) {
            operator = new Divergence(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("curl") == 0) {
            operator = new Curl(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("jacobian") == 0) {
            operator = new Jacobian(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("laplacian") == 0) {
            operator = new Laplacian(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("dalembertian") == 0) {
            operator = new Dalembertian(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("del") == 0) {
            operator = new Del(genericArray[0], genericArray[1], genericArray.length > 2 ? genericArray[2] : JSCLInteger.valueOf(0L));
        } else if (string2.compareTo("vector") == 0) {
            operator = new VectorProduct(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("complex") == 0) {
            operator = new ComplexProduct(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("quaternion") == 0) {
            operator = new QuaternionProduct(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("geometric") == 0) {
            operator = new GeometricProduct(genericArray[0], genericArray[1], genericArray.length > 2 ? genericArray[2] : JSCLInteger.valueOf(0L));
        } else if (string2.compareTo("matrix") == 0) {
            operator = new MatrixProduct(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("tensor") == 0) {
            operator = new TensorProduct(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("transpose") == 0) {
            operator = new Transpose(genericArray[0]);
        } else if (string2.compareTo("trace") == 0) {
            operator = new Trace(genericArray[0]);
        } else if (string2.compareTo("determinant") == 0) {
            operator = new Determinant(genericArray[0]);
        } else if (string2.compareTo("C") == 0) {
            operator = new Binomial(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("coef") == 0) {
            operator = new Coefficient(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("solve") == 0) {
            operator = new Solve(genericArray[0], genericArray[1], genericArray.length > 2 ? genericArray[2] : JSCLInteger.valueOf(0L));
        } else if (string2.compareTo("subst") == 0) {
            operator = new Substitute(genericArray[0], genericArray[1], genericArray[2]);
        } else if (string2.compareTo("graph") == 0) {
            operator = new Graph(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("expand") == 0) {
            operator = new Expand(genericArray[0]);
        } else if (string2.compareTo("factorize") == 0) {
            operator = new Factorize(genericArray[0]);
        } else if (string2.compareTo("elementary") == 0) {
            operator = new Elementary(genericArray[0]);
        } else if (string2.compareTo("simplify") == 0) {
            operator = new Simplify(genericArray[0]);
        } else if (string2.compareTo("numeric") == 0) {
            operator = new Numeric(genericArray[0]);
        } else if (string2.compareTo("quote") == 0) {
            operator = new Quote(genericArray[0]);
        } else if (string2.compareTo("limit") == 0) {
            operator = new Limit(genericArray[0], genericArray[1], genericArray[2], genericArray.length > 3 && genericArray[2].compareTo(Constant.infinity) != 0 && genericArray[2].compareTo(Constant.infinity.negate()) != 0 ? JSCLInteger.valueOf(genericArray[3].signum()) : JSCLInteger.valueOf(0L));
        } else if (string2.compareTo("taylor") == 0) {
            operator = new Taylor(genericArray[0], genericArray[1], genericArray[2], genericArray[3]);
        } else if (string2.compareTo("sum") == 0) {
            operator = new Sum(genericArray[0], genericArray[1], genericArray[2], genericArray[3]);
        } else if (string2.compareTo("product") == 0) {
            operator = new Product(genericArray[0], genericArray[1], genericArray[2], genericArray[3]);
        } else if (string2.compareTo("integral") == 0) {
            operator = genericArray.length > 2 ? new Integral(genericArray[0], genericArray[1], genericArray[2], genericArray[3]) : new IndefiniteIntegral(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("groebner") == 0) {
            operator = new Groebner(genericArray[0], genericArray[1], genericArray.length > 2 ? genericArray[2] : Groebner.lex, genericArray.length > 3 ? genericArray[3] : JSCLInteger.valueOf(0L));
        } else if (string2.compareTo("quotient") == 0) {
            operator = new Division(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("rem") == 0) {
            operator = new Remainder(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("factorof") == 0) {
            operator = new FactorOf(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("mod") == 0) {
            operator = new Mod(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("modpow") == 0) {
            operator = new ModPow(genericArray[0], genericArray[1], genericArray[2]);
        } else if (string2.compareTo("modinv") == 0) {
            operator = new ModInverse(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("eulerphi") == 0) {
            operator = new EulerPhi(genericArray[0]);
        } else if (string2.compareTo("primitiveroots") == 0) {
            operator = new PrimitiveRoots(genericArray[0]);
        }
        return operator;
    }

    static boolean valid(String string) {
        for (int i = 0; i < na.length; ++i) {
            if (string.compareTo(na[i]) != 0) continue;
            return true;
        }
        return false;
    }
}

