/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial.groebner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jscl.math.Debug;
import jscl.math.Generic;
import jscl.math.polynomial.Basis;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Ordering;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.groebner.Block;
import jscl.math.polynomial.groebner.F4;
import jscl.math.polynomial.groebner.Instrumented;
import jscl.math.polynomial.groebner.Natural;
import jscl.math.polynomial.groebner.Pair;
import jscl.math.polynomial.groebner.Sugar;
import jscl.util.ArrayUtils;

public class Standard {
    final int flags;
    final Comparator comparator;
    final Map pairs;
    final List polys = new ArrayList();
    final Map removed = new TreeMap();
    int npairs;
    int npolys;

    Standard(int n) {
        this.flags = n;
        this.comparator = (n & 0x800) > 0 ? Sugar.comparator : Natural.comparator;
        this.pairs = new TreeMap(this.comparator);
    }

    public static Basis compute(Basis basis) {
        return Standard.compute(basis, 0);
    }

    public static Basis compute(Basis basis, int n) {
        return Standard.compute(basis, n, (n & 0x200) > 0);
    }

    static Basis compute(Basis basis, int n, boolean bl) {
        Standard standard = bl ? new Instrumented(n) : Standard.algorithm(basis.ordering(), n);
        standard.computeValue(basis);
        basis = basis.valueof(standard.elements());
        if (bl) {
            return Standard.compute(basis, n, false);
        }
        return basis;
    }

    static Standard algorithm(Ordering ordering, int n) {
        switch (n & 0x180) {
            case 128: {
                return new F4(ordering, n);
            }
            case 256: {
                return new Block(ordering, n);
            }
        }
        return new Standard(n);
    }

    void computeValue(Basis basis) {
        Debug.println(basis);
        this.populate(basis);
        this.npolys = 0;
        this.compute();
        this.remove();
        this.reduce();
        Debug.println("signature = (" + this.npairs + ", " + this.npolys + ", " + this.polys.size() + ")");
    }

    void populate(Basis basis) {
        ArrayList<Polynomial> arrayList = new ArrayList<Polynomial>();
        Generic[] genericArray = basis.elements();
        for (int i = 0; i < genericArray.length; ++i) {
            arrayList.add(basis.polynomial(genericArray[i]));
        }
        this.add(arrayList);
    }

    void add(List list) {
        for (Polynomial polynomial : list) {
            if (polynomial.signum() == 0) continue;
            this.add(polynomial);
        }
    }

    void compute() {
        Debug.println("compute");
        while (!this.pairs.isEmpty()) {
            Pair pair = (Pair)this.pairs.keySet().iterator().next();
            this.process(pair);
            this.remove(pair);
        }
    }

    void process(Pair pair) {
        if (this.criterion(pair)) {
            return;
        }
        Polynomial polynomial = Standard.reduce(pair, this.polys);
        if (polynomial.signum() != 0) {
            this.add(polynomial);
        }
        ++this.npairs;
    }

    static Polynomial reduce(Pair pair, Collection collection) {
        Debug.println(pair);
        return Standard.s_polynomial(pair.polynomial[0], pair.polynomial[1]).reduce(collection, false).normalize().freeze();
    }

    static Polynomial s_polynomial(Polynomial polynomial, Polynomial polynomial2) {
        Monomial monomial = polynomial.head().monomial();
        Monomial monomial2 = polynomial2.head().monomial();
        Monomial monomial3 = monomial.gcd(monomial2);
        monomial = monomial.divide(monomial3);
        monomial2 = monomial2.divide(monomial3);
        return polynomial.multiply(monomial2).reduce(polynomial.head().coef(), monomial, polynomial2);
    }

    void remove(Pair pair) {
        this.pairs.remove(pair);
        if (pair.reduction) {
            this.removed.put(pair.principal, null);
        }
    }

    void add(Polynomial polynomial) {
        polynomial.setIndex(this.polys.size());
        Debug.println("(" + polynomial.head().monomial() + ", " + polynomial.index() + ")");
        if ((this.flags & 0x400) > 0) {
            this.makePairsGM(polynomial);
        } else {
            this.makePairs(polynomial);
        }
        this.polys.add(polynomial);
        ++this.npolys;
    }

    boolean criterion(Pair pair) {
        return (this.flags & 0x400) > 0 ? false : this.b_criterion(pair);
    }

    void makePairs(Polynomial polynomial) {
        for (Polynomial polynomial2 : this.polys) {
            Pair pair = new Pair(polynomial2, polynomial);
            if (pair.coprime) continue;
            this.pairs.put(pair, null);
        }
    }

    boolean b_criterion(Pair pair) {
        for (Polynomial polynomial : this.polys) {
            if (!pair.scm.multiple(polynomial.head().monomial())) continue;
            Pair pair2 = new Pair(this.sort(pair.polynomial[0], polynomial));
            Pair pair3 = new Pair(this.sort(pair.polynomial[1], polynomial));
            if (!this.considered(pair2) || !this.considered(pair3)) continue;
            return true;
        }
        return false;
    }

    boolean considered(Pair pair) {
        return !this.pairs.containsKey(pair);
    }

    Polynomial[] sort(Polynomial polynomial, Polynomial polynomial2) {
        Polynomial[] polynomialArray;
        if (polynomial.index() < polynomial2.index()) {
            Polynomial[] polynomialArray2 = new Polynomial[2];
            polynomialArray2[0] = polynomial;
            polynomialArray = polynomialArray2;
            polynomialArray2[1] = polynomial2;
        } else {
            Polynomial[] polynomialArray3 = new Polynomial[2];
            polynomialArray3[0] = polynomial2;
            polynomialArray = polynomialArray3;
            polynomialArray3[1] = polynomial;
        }
        return polynomialArray;
    }

    void makePairsGM(Polynomial polynomial) {
        Pair pair;
        Comparable comparable2;
        List<Pair> list = new ArrayList();
        for (Pair pair2 : this.pairs.keySet()) {
            Pair pair3 = new Pair(new Polynomial[]{pair2.polynomial[0], polynomial});
            comparable2 = new Pair(new Polynomial[]{pair2.polynomial[1], polynomial});
            if (!this.multiple(pair2, pair3) || !this.multiple(pair2, (Pair)comparable2)) continue;
            list.add(pair2);
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            comparable2 = (Pair)list.get(i);
            this.remove((Pair)comparable2);
        }
        TreeMap treeMap = new TreeMap((this.flags & 0x800) > 0 && (this.flags & 0x1000) > 0 ? Sugar.comparator : Natural.comparator);
        for (Comparable comparable2 : this.polys) {
            pair = new Pair((Polynomial)comparable2, polynomial);
            this.pairs.put(pair, null);
            treeMap.put(pair, null);
        }
        list = ArrayUtils.list(treeMap.keySet());
        n = list.size();
        for (int i = 0; i < n; ++i) {
            pair = (Pair)list.get(i);
            for (int j = i + 1; j < n; ++j) {
                Pair pair4 = (Pair)list.get(j);
                if (!pair4.scm.multiple(pair.scm)) continue;
                this.remove(pair4);
            }
            if (!pair.coprime) continue;
            this.remove(pair);
        }
    }

    boolean multiple(Pair pair, Pair pair2) {
        return pair.scm.multiple(pair2.scm, true) && ((this.flags & 0x800) <= 0 || (this.flags & 0x1000) <= 0 || Sugar.comparator.compare(pair, pair2) > 0);
    }

    void remove() {
        Iterator iterator = this.polys.iterator();
        while (iterator.hasNext()) {
            if (!this.removed.containsKey(iterator.next())) continue;
            iterator.remove();
        }
    }

    void reduce() {
        Debug.println("reduce");
        TreeMap treeMap = new TreeMap();
        int n = this.polys.size();
        for (int i = 0; i < n; ++i) {
            Polynomial polynomial = (Polynomial)this.polys.get(i);
            polynomial = polynomial.reduce(this.polys, true).normalize().freeze();
            this.polys.set(i, polynomial);
            Debug.println("(" + polynomial.head().monomial() + ")");
            treeMap.put(polynomial, null);
        }
        this.polys.clear();
        this.polys.addAll(treeMap.keySet());
    }

    Generic[] elements() {
        int n = this.polys.size();
        Generic[] genericArray = new Generic[n];
        for (int i = 0; i < n; ++i) {
            genericArray[i] = ((Polynomial)this.polys.get(i)).genericValue();
        }
        return genericArray;
    }
}

