/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial.groebner;

import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;

class Pair
implements Comparable {
    final Polynomial[] polynomial;
    final Monomial[] monomial;
    final Monomial scm;
    final int sugar;
    boolean coprime;
    boolean reduction;
    Polynomial principal;

    Pair(Polynomial polynomial, Polynomial polynomial2) {
        this(new Polynomial[]{polynomial, polynomial2});
        int[] nArray;
        boolean bl = this.coprime = this.monomial[0].gcd(this.monomial[1]).degree() == 0;
        if (this.monomial[0].compareTo(this.monomial[1]) < 0) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 1;
            nArray = nArray3;
            nArray3[1] = 0;
        }
        int[] nArray4 = nArray;
        this.reduction = this.monomial[nArray4[1]].multiple(this.monomial[nArray4[0]]);
        this.principal = this.polynomial[nArray4[1]];
    }

    Pair(Polynomial[] polynomialArray) {
        this.polynomial = polynomialArray;
        this.monomial = new Monomial[]{polynomialArray[0].head().monomial(), polynomialArray[1].head().monomial()};
        this.scm = this.monomial[0].scm(this.monomial[1]);
        this.sugar = Math.max(polynomialArray[0].sugar() - polynomialArray[0].degree(), polynomialArray[1].sugar() - polynomialArray[1].degree()) + this.scm.degree();
    }

    public int compareTo(Pair pair) {
        int n = this.scm.compareTo(pair.scm);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        n = this.polynomial[1].index() - pair.polynomial[1].index();
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        n = this.polynomial[0].index() - pair.polynomial[0].index();
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return 0;
    }

    public int compareTo(Object object) {
        return this.compareTo((Pair)object);
    }

    public String toString() {
        return "{" + this.polynomial[0].index() + ", " + this.polynomial[1].index() + "}, " + this.sugar + ", " + this.reduction;
    }
}

