/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import jscl.math.NotDivisibleException;
import jscl.math.Variable;
import jscl.math.polynomial.DegreeReverseLexicographic;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Ordering;
import jscl.math.polynomial.SmallDegreeReverseLexicographic;
import jscl.math.polynomial.SmallLexicographic;
import jscl.math.polynomial.SmallTotalDegreeLexicographic;

class SmallMonomial
extends Monomial {
    static final Ordering lexicographic = SmallLexicographic.ordering;
    static final Ordering totalDegreeLexicographic = SmallTotalDegreeLexicographic.ordering;
    static final Ordering degreeReverseLexicographic = SmallDegreeReverseLexicographic.ordering;
    static final int log2n = 3;
    static final int log2p = 2;
    static final int nmask = 255;
    static final int pmask = 3;

    SmallMonomial(Variable[] variableArray, Ordering ordering) {
        this((variableArray.length - 1 >> 2) + 1, variableArray, ordering);
    }

    SmallMonomial(int n, Variable[] variableArray, Ordering ordering) {
        super(n, variableArray, ordering);
    }

    @Override
    public Monomial multiply(Monomial monomial) {
        Monomial monomial2 = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int n = i >> 2;
            int n2 = (i & 3) << 3;
            int n3 = this.element[n] >> n2 & 0xFF;
            int n4 = monomial.element[n] >> n2 & 0xFF;
            int n5 = n3 + n4;
            if (n5 > 255) {
                throw new ArithmeticException();
            }
            int n6 = n;
            monomial2.element[n6] = monomial2.element[n6] | n5 << n2;
            monomial2.degree += n5;
        }
        return monomial2;
    }

    @Override
    public boolean multiple(Monomial monomial, boolean bl) {
        boolean bl2 = true;
        for (int i = 0; i < this.unknown.length; ++i) {
            int n = i >> 2;
            int n2 = (i & 3) << 3;
            int n3 = this.element[n] >> n2 & 0xFF;
            int n4 = monomial.element[n] >> n2 & 0xFF;
            if (n3 < n4) {
                return false;
            }
            bl2 &= n3 == n4;
        }
        return bl ? !bl2 : true;
    }

    @Override
    public Monomial divide(Monomial monomial) throws ArithmeticException {
        Monomial monomial2 = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int n = i >> 2;
            int n2 = (i & 3) << 3;
            int n3 = this.element[n] >> n2 & 0xFF;
            int n4 = monomial.element[n] >> n2 & 0xFF;
            int n5 = n3 - n4;
            if (n5 < 0) {
                throw new NotDivisibleException();
            }
            int n6 = n;
            monomial2.element[n6] = monomial2.element[n6] | n5 << n2;
        }
        monomial2.degree = this.degree - monomial.degree;
        return monomial2;
    }

    @Override
    public Monomial gcd(Monomial monomial) {
        Monomial monomial2 = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int n = i >> 2;
            int n2 = (i & 3) << 3;
            int n3 = this.element[n] >> n2 & 0xFF;
            int n4 = monomial.element[n] >> n2 & 0xFF;
            int n5 = Math.min(n3, n4);
            int n6 = n;
            monomial2.element[n6] = monomial2.element[n6] | n5 << n2;
            monomial2.degree += n5;
        }
        return monomial2;
    }

    @Override
    public Monomial scm(Monomial monomial) {
        Monomial monomial2 = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int n = i >> 2;
            int n2 = (i & 3) << 3;
            int n3 = this.element[n] >> n2 & 0xFF;
            int n4 = monomial.element[n] >> n2 & 0xFF;
            int n5 = Math.max(n3, n4);
            int n6 = n;
            monomial2.element[n6] = monomial2.element[n6] | n5 << n2;
            monomial2.degree += n5;
        }
        return monomial2;
    }

    @Override
    public int element(int n) {
        if (this.reverse()) {
            n = this.unknown.length - 1 - n;
        }
        int n2 = n >> 2;
        int n3 = (n & 3) << 3;
        return this.element[n2] >> n3 & 0xFF;
    }

    @Override
    void put(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.reverse()) {
            n = this.unknown.length - 1 - n;
        }
        if ((n6 = (n5 = this.element[n4 = n >> 2] >> (n3 = (n & 3) << 3) & 0xFF) + n2) > 255) {
            throw new ArithmeticException();
        }
        int n7 = n4;
        this.element[n7] = this.element[n7] | n6 << n3;
        this.degree += n6 - n5;
    }

    boolean reverse() {
        return this.ordering instanceof DegreeReverseLexicographic;
    }

    @Override
    protected Monomial newinstance() {
        return new SmallMonomial(this.element.length, this.unknown, this.ordering);
    }
}

