/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.Iterator;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Ordering;

class MonomialIterator
implements Iterator {
    static final Ordering ordering = Monomial.iteratorOrdering;
    Monomial monomial;
    Monomial current;
    boolean carry;

    MonomialIterator(Monomial monomial, Monomial monomial2) {
        this.monomial = monomial2;
        this.current = monomial2.valueof(monomial);
        if (ordering.compare(this.current, monomial2) > 0) {
            this.carry = true;
        }
    }

    @Override
    public boolean hasNext() {
        return !this.carry;
    }

    public Object next() {
        Monomial monomial = this.monomial.valueof(this.current);
        if (ordering.compare(this.current, this.monomial) < 0) {
            this.increment();
        } else {
            this.carry = true;
        }
        return monomial;
    }

    void increment() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.current.element.length && this.current.element[n] == 0; ++n) {
        }
        if (n < this.current.element.length) {
            n2 = this.current.element[n];
            this.current.element[n] = 0;
            ++n;
        }
        if (n < this.current.element.length) {
            int n3 = n;
            this.current.element[n3] = this.current.element[n3] + 1;
            this.fill(n2 - 1);
        } else {
            ++this.current.degree;
            this.fill(n2 + 1);
        }
    }

    private void fill(int n) {
        this.current.element[0] = n;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

