/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.Iterator;
import jscl.math.Literal;
import jscl.math.NotDivisibleException;
import jscl.math.Variable;
import jscl.math.function.Frac;
import jscl.math.function.Pow;
import jscl.math.polynomial.BooleanMonomial;
import jscl.math.polynomial.DefinedBooleanMonomial;
import jscl.math.polynomial.DegreeReverseLexicographic;
import jscl.math.polynomial.KthElimination;
import jscl.math.polynomial.Lexicographic;
import jscl.math.polynomial.MonomialDivisor;
import jscl.math.polynomial.MonomialIterator;
import jscl.math.polynomial.Ordering;
import jscl.math.polynomial.SmallMonomial;
import jscl.math.polynomial.TotalDegreeLexicographic;

public class Monomial
implements Comparable {
    public static final Ordering lexicographic = Lexicographic.ordering;
    public static final Ordering totalDegreeLexicographic = TotalDegreeLexicographic.ordering;
    public static final Ordering degreeReverseLexicographic = DegreeReverseLexicographic.ordering;
    public static final Ordering iteratorOrdering = totalDegreeLexicographic;
    final Variable[] unknown;
    final Ordering ordering;
    final int[] element;
    int degree;

    Monomial(Variable[] variableArray, Ordering ordering) {
        this(variableArray.length, variableArray, ordering);
    }

    Monomial(int n, Variable[] variableArray, Ordering ordering) {
        this.unknown = variableArray;
        this.ordering = ordering;
        this.element = new int[n];
    }

    public static Ordering kthElimination(int n) {
        return new KthElimination(n, 1);
    }

    public Variable[] unknown() {
        return this.unknown;
    }

    public Ordering ordering() {
        return this.ordering;
    }

    public Monomial multiply(Monomial monomial) {
        Monomial monomial2 = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            monomial2.element[i] = this.element[i] + monomial.element[i];
        }
        monomial2.degree = this.degree + monomial.degree;
        return monomial2;
    }

    public boolean multiple(Monomial monomial) {
        return this.multiple(monomial, false);
    }

    public boolean multiple(Monomial monomial, boolean bl) {
        boolean bl2 = true;
        for (int i = 0; i < this.unknown.length; ++i) {
            if (this.element[i] < monomial.element[i]) {
                return false;
            }
            bl2 &= this.element[i] == monomial.element[i];
        }
        return bl ? !bl2 : true;
    }

    public Monomial divide(Monomial monomial) throws ArithmeticException {
        Monomial monomial2 = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int n = this.element[i] - monomial.element[i];
            if (n < 0) {
                throw new NotDivisibleException();
            }
            monomial2.element[i] = n;
        }
        monomial2.degree = this.degree - monomial.degree;
        return monomial2;
    }

    public Monomial gcd(Monomial monomial) {
        Monomial monomial2 = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int n;
            monomial2.element[i] = n = Math.min(this.element[i], monomial.element[i]);
            monomial2.degree += n;
        }
        return monomial2;
    }

    public Monomial scm(Monomial monomial) {
        Monomial monomial2 = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int n;
            monomial2.element[i] = n = Math.max(this.element[i], monomial.element[i]);
            monomial2.degree += n;
        }
        return monomial2;
    }

    public int degree() {
        return this.degree;
    }

    public Monomial valueof(Monomial monomial) {
        Monomial monomial2 = this.newinstance();
        System.arraycopy(monomial.element, 0, monomial2.element, 0, monomial2.element.length);
        monomial2.degree = monomial.degree;
        return monomial2;
    }

    public Monomial valueof(Literal literal) {
        Monomial monomial = this.newinstance();
        monomial.init(literal);
        return monomial;
    }

    public Literal literalValue() {
        return Literal.valueOf(this);
    }

    public int element(int n) {
        return this.element[n];
    }

    public Iterator iterator() {
        return this.iterator(this.newinstance());
    }

    public Iterator iterator(Monomial monomial) {
        return new MonomialIterator(monomial, this);
    }

    public Iterator divisor() {
        return this.divisor(this.newinstance());
    }

    public Iterator divisor(Monomial monomial) {
        return new MonomialDivisor(monomial, this);
    }

    static Monomial factory(Variable[] variableArray) {
        return Monomial.factory(variableArray, lexicographic);
    }

    static Monomial factory(Variable[] variableArray, Ordering ordering) {
        return Monomial.factory(variableArray, ordering, 0);
    }

    static Monomial factory(Variable[] variableArray, Ordering ordering, int n) {
        switch (n) {
            case 16: {
                return new SmallMonomial(variableArray, Monomial.small(ordering));
            }
            case 32: {
                return new BooleanMonomial(variableArray, Monomial.small(ordering));
            }
            case 48: {
                return new DefinedBooleanMonomial(variableArray, Monomial.small(ordering));
            }
        }
        return new Monomial(variableArray, ordering);
    }

    static Ordering small(Ordering ordering) {
        if (ordering == lexicographic) {
            return SmallMonomial.lexicographic;
        }
        if (ordering == totalDegreeLexicographic) {
            return SmallMonomial.totalDegreeLexicographic;
        }
        if (ordering == degreeReverseLexicographic) {
            return SmallMonomial.degreeReverseLexicographic;
        }
        throw new UnsupportedOperationException();
    }

    public int compareTo(Monomial monomial) {
        return this.ordering.compare(this, monomial);
    }

    public int compareTo(Object object) {
        return this.compareTo((Monomial)object);
    }

    void init(Literal literal) {
        int n = literal.size();
        for (int i = 0; i < n; ++i) {
            Variable variable = literal.variable(i);
            int n2 = literal.power(i);
            int n3 = Monomial.variable(variable, this.unknown);
            if (n3 >= this.unknown.length) continue;
            this.put(n3, n2);
        }
    }

    static int variable(Variable variable, Variable[] variableArray) {
        int n;
        for (n = 0; n < variableArray.length && !variableArray[n].equals(variable); ++n) {
        }
        return n;
    }

    void put(int n, int n2) {
        int n3 = n;
        this.element[n3] = this.element[n3] + n2;
        this.degree += n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.degree == 0) {
            stringBuffer.append("1");
        }
        boolean bl = false;
        for (int i = 0; i < this.unknown.length; ++i) {
            int n = this.element(i);
            if (n <= 0) continue;
            if (bl) {
                stringBuffer.append("*");
            } else {
                bl = true;
            }
            Variable variable = this.unknown[i];
            if (n == 1) {
                stringBuffer.append(variable);
                continue;
            }
            if (variable instanceof Frac || variable instanceof Pow) {
                stringBuffer.append("(").append(variable).append(")");
            } else {
                stringBuffer.append(variable);
            }
            stringBuffer.append("^").append(n);
        }
        return stringBuffer.toString();
    }

    public String toMathML() {
        String string = "<cn>1</cn>";
        boolean bl = true;
        for (int i = 0; i < this.unknown.length; ++i) {
            int n = this.element(i);
            if (n <= 0) continue;
            String string2 = n == 1 ? this.unknown[i].toMathML() : "<apply><power/>" + this.unknown[i].toMathML() + "<cn>" + n + "</cn></apply>";
            string = bl ? string2 : "<apply><times/>" + string + string2 + "</apply>";
            bl = false;
        }
        return string;
    }

    protected Monomial newinstance() {
        return new Monomial(this.element.length, this.unknown, this.ordering);
    }
}

