/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.math.BigInteger;
import jscl.math.Expression;
import jscl.math.Field;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.Power;
import jscl.math.Variable;

public class ModularInteger
extends Generic
implements Field {
    final int modulo;
    final int content;

    public ModularInteger(long l, int n) {
        this.modulo = n;
        this.content = (int)(l % (long)n);
    }

    public int content() {
        return this.content;
    }

    public int modulo() {
        return this.modulo;
    }

    public ModularInteger add(ModularInteger modularInteger) {
        return this.newinstance((long)this.content + (long)modularInteger.content);
    }

    @Override
    public Generic add(Generic generic) {
        return this.add((ModularInteger)generic);
    }

    public ModularInteger subtract(ModularInteger modularInteger) {
        return this.newinstance((long)this.content + (long)(this.modulo - modularInteger.content));
    }

    @Override
    public Generic subtract(Generic generic) {
        return this.subtract((ModularInteger)generic);
    }

    public ModularInteger multiply(ModularInteger modularInteger) {
        return this.newinstance((long)this.content * (long)modularInteger.content);
    }

    @Override
    public Generic multiply(Generic generic) {
        return this.multiply((ModularInteger)generic);
    }

    @Override
    public Generic divide(Generic generic) throws ArithmeticException {
        return this.multiply(generic.inverse());
    }

    @Override
    public Generic inverse() {
        return this.newinstance(BigInteger.valueOf(this.content).modInverse(BigInteger.valueOf(this.modulo)).intValue());
    }

    @Override
    public Generic gcd(Generic generic) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic gcd() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic negate() {
        return this.newinstance(this.modulo - this.content);
    }

    @Override
    public int signum() {
        return this.content > 0 ? 1 : 0;
    }

    @Override
    public int degree() {
        return 0;
    }

    @Override
    public Generic antiderivative(Variable variable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic derivative(Variable variable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic function(Variable variable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic eval() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic expand() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic factorize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic elementary() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic simplify() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic numeric() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic valueof(Generic generic) {
        if (generic instanceof ModularInteger) {
            return this.newinstance(((ModularInteger)generic).content);
        }
        if (generic instanceof JSCLInteger) {
            return this.newinstance(((JSCLInteger)generic).content().mod(BigInteger.valueOf(this.modulo)).intValue());
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic[] sumValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic[] productValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Power powerValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression expressionValue() {
        return Expression.valueOf(this.integerValue());
    }

    @Override
    public JSCLInteger integerValue() {
        return JSCLInteger.valueOf(this.content);
    }

    @Override
    public Variable variableValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Variable[] variables() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPolynomial(Variable variable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isConstant(Variable variable) {
        throw new UnsupportedOperationException();
    }

    public int compareTo(ModularInteger modularInteger) {
        return this.content < modularInteger.content ? -1 : (this.content > modularInteger.content ? 1 : 0);
    }

    @Override
    public int compareTo(Generic generic) {
        if (generic instanceof ModularInteger) {
            return this.compareTo((ModularInteger)generic);
        }
        return this.compareTo(this.valueof(generic));
    }

    public static ModularInteger valueOf(int n, int n2) {
        return new ModularInteger(n, n2);
    }

    public static ModularInteger factory(int n) {
        return new ModularInteger(0L, n);
    }

    public String toString() {
        return String.valueOf(this.content);
    }

    @Override
    public String toMathML() {
        return "<cn type=\"integer\" base=\"" + this.modulo + "\">" + this.content + "</cn>";
    }

    protected ModularInteger newinstance(long l) {
        return new ModularInteger(l, this.modulo);
    }
}

