/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.Literal;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.Term;
import jscl.util.ArrayUtils;

final class ListPolynomial
extends Polynomial {
    final List content = new LinkedList();
    int degree;
    boolean mutable = true;

    ListPolynomial(Monomial monomial, Generic generic) {
        super(monomial, generic);
    }

    @Override
    public int size() {
        return this.content.size();
    }

    @Override
    public final Iterator iterator(boolean bl, Monomial monomial) {
        return new ContentIterator(bl, monomial);
    }

    int indexOf(Monomial monomial, boolean bl) {
        if (monomial == null) {
            return bl ? this.content.size() : 0;
        }
        int n = ArrayUtils.binarySearch(this.content, new Term(monomial, null));
        return n < 0 ? -n - 1 : (bl ? n : n + 1);
    }

    @Override
    public Polynomial subtract(Polynomial polynomial) {
        if (polynomial.signum() == 0) {
            return this;
        }
        if (this.mutable) {
            Term term;
            ListPolynomial listPolynomial = (ListPolynomial)polynomial;
            ListIterator<Term> listIterator = this.content.listIterator(this.content.size());
            ListIterator listIterator2 = listPolynomial.content.listIterator(listPolynomial.content.size());
            Term term2 = listIterator.hasPrevious() ? (Term)listIterator.previous() : null;
            Term term3 = term = listIterator2.hasPrevious() ? (Term)listIterator2.previous() : null;
            while (term != null) {
                int n;
                int n2 = term2 == null ? 1 : (n = term == null ? -1 : -this.ordering.compare(term2.monomial(), term.monomial()));
                if (n < 0) {
                    term2 = listIterator.hasPrevious() ? (Term)listIterator.previous() : null;
                    continue;
                }
                if (n > 0) {
                    if (term2 != null) {
                        listIterator.next();
                    }
                    listIterator.add(term.negate());
                } else {
                    Term term4 = term2.subtract(term);
                    if (term4.signum() == 0) {
                        listIterator.remove();
                    } else {
                        listIterator.set(term4);
                    }
                }
                term2 = listIterator.hasPrevious() ? (Term)listIterator.previous() : null;
                term = listIterator2.hasPrevious() ? (Term)listIterator2.previous() : null;
            }
            this.degree = ListPolynomial.degree(this);
            this.sugar = Math.max(this.sugar, listPolynomial.sugar);
            this.normalized = false;
            return this;
        }
        return this.copy().subtract(polynomial);
    }

    @Override
    public Polynomial multiplyAndSubtract(Generic generic, Polynomial polynomial) {
        if (generic.signum() == 0) {
            return this;
        }
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this.subtract(polynomial);
        }
        if (this.mutable) {
            Term term;
            ListPolynomial listPolynomial = (ListPolynomial)polynomial;
            ListIterator<Term> listIterator = this.content.listIterator(this.content.size());
            ListIterator listIterator2 = listPolynomial.content.listIterator(listPolynomial.content.size());
            Term term2 = listIterator.hasPrevious() ? (Term)listIterator.previous() : null;
            Term term3 = term = listIterator2.hasPrevious() ? ((Term)listIterator2.previous()).multiply(generic) : null;
            while (term != null) {
                int n;
                int n2 = term2 == null ? 1 : (n = term == null ? -1 : -this.ordering.compare(term2.monomial(), term.monomial()));
                if (n < 0) {
                    term2 = listIterator.hasPrevious() ? (Term)listIterator.previous() : null;
                    continue;
                }
                if (n > 0) {
                    if (term2 != null) {
                        listIterator.next();
                    }
                    listIterator.add(term.negate());
                } else {
                    Term term4 = term2.subtract(term);
                    if (term4.signum() == 0) {
                        listIterator.remove();
                    } else {
                        listIterator.set(term4);
                    }
                }
                term2 = listIterator.hasPrevious() ? (Term)listIterator.previous() : null;
                term = listIterator2.hasPrevious() ? ((Term)listIterator2.previous()).multiply(generic) : null;
            }
            this.degree = ListPolynomial.degree(this);
            this.sugar = Math.max(this.sugar, listPolynomial.sugar);
            this.normalized = false;
            return this;
        }
        return this.copy().multiplyAndSubtract(generic, polynomial);
    }

    @Override
    public Polynomial multiplyAndSubtract(Monomial monomial, Generic generic, Polynomial polynomial) {
        if (this.defined) {
            throw new UnsupportedOperationException();
        }
        if (generic.signum() == 0) {
            return this;
        }
        if (monomial.degree() == 0) {
            return this.multiplyAndSubtract(generic, polynomial);
        }
        if (this.mutable) {
            Term term;
            ListPolynomial listPolynomial = (ListPolynomial)polynomial;
            ListIterator<Term> listIterator = this.content.listIterator(this.content.size());
            ListIterator listIterator2 = listPolynomial.content.listIterator(listPolynomial.content.size());
            Term term2 = listIterator.hasPrevious() ? (Term)listIterator.previous() : null;
            Term term3 = term = listIterator2.hasPrevious() ? ((Term)listIterator2.previous()).multiply(monomial, generic) : null;
            while (term != null) {
                int n;
                int n2 = term2 == null ? 1 : (n = term == null ? -1 : -this.ordering.compare(term2.monomial(), term.monomial()));
                if (n < 0) {
                    term2 = listIterator.hasPrevious() ? (Term)listIterator.previous() : null;
                    continue;
                }
                if (n > 0) {
                    if (term2 != null) {
                        listIterator.next();
                    }
                    listIterator.add(term.negate());
                } else {
                    Term term4 = term2.subtract(term);
                    if (term4.signum() == 0) {
                        listIterator.remove();
                    } else {
                        listIterator.set(term4);
                    }
                }
                term2 = listIterator.hasPrevious() ? (Term)listIterator.previous() : null;
                term = listIterator2.hasPrevious() ? ((Term)listIterator2.previous()).multiply(monomial, generic) : null;
            }
            this.degree = ListPolynomial.degree(this);
            this.sugar = Math.max(this.sugar, listPolynomial.sugar + monomial.degree());
            this.normalized = false;
            return this;
        }
        return this.copy().multiplyAndSubtract(monomial, generic, polynomial);
    }

    @Override
    public Polynomial multiply(Generic generic) {
        if (generic.signum() == 0) {
            return this.valueof(JSCLInteger.valueOf(0L));
        }
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this;
        }
        if (this.mutable) {
            ListIterator<Term> listIterator = this.content.listIterator();
            while (listIterator.hasNext()) {
                listIterator.set(((Term)listIterator.next()).multiply(generic));
            }
            this.normalized = false;
            return this;
        }
        return this.copy().multiply(generic);
    }

    @Override
    public Polynomial multiply(Monomial monomial) {
        if (this.defined) {
            throw new UnsupportedOperationException();
        }
        if (monomial.degree() == 0) {
            return this;
        }
        if (this.mutable) {
            ListIterator<Term> listIterator = this.content.listIterator();
            while (listIterator.hasNext()) {
                listIterator.set(((Term)listIterator.next()).multiply(monomial));
            }
            this.degree += monomial.degree();
            this.sugar += monomial.degree();
            return this;
        }
        return this.copy().multiply(monomial);
    }

    @Override
    public Polynomial divide(Generic generic) throws ArithmeticException {
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this;
        }
        if (this.mutable) {
            ListIterator<Term> listIterator = this.content.listIterator();
            while (listIterator.hasNext()) {
                listIterator.set(((Term)listIterator.next()).divide(generic));
            }
            this.normalized = false;
            return this;
        }
        return this.copy().divide(generic);
    }

    @Override
    public Polynomial divide(Monomial monomial) throws ArithmeticException {
        if (monomial.degree() == 0) {
            return this;
        }
        if (this.mutable) {
            ListIterator<Term> listIterator = this.content.listIterator();
            while (listIterator.hasNext()) {
                listIterator.set(((Term)listIterator.next()).divide(monomial));
            }
            this.degree -= monomial.degree();
            this.sugar -= monomial.degree();
            return this;
        }
        return this.copy().divide(monomial);
    }

    @Override
    public Polynomial gcd(Polynomial polynomial) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int degree() {
        return this.degree;
    }

    @Override
    public Polynomial valueof(Polynomial polynomial) {
        ListPolynomial listPolynomial = this.newinstance(0);
        listPolynomial.init(polynomial);
        return listPolynomial;
    }

    @Override
    public Polynomial valueof(Generic generic) {
        ListPolynomial listPolynomial = this.newinstance(0);
        listPolynomial.init(generic);
        return listPolynomial;
    }

    @Override
    public Polynomial valueof(Monomial monomial) {
        ListPolynomial listPolynomial = this.newinstance(0);
        listPolynomial.init(monomial);
        return listPolynomial;
    }

    @Override
    public Polynomial freeze() {
        this.mutable = false;
        return this;
    }

    @Override
    public Term head() {
        int n = this.content.size();
        return n > 0 ? (Term)this.content.get(n - 1) : null;
    }

    @Override
    public Term tail() {
        int n = this.content.size();
        return n > 0 ? (Term)this.content.get(0) : null;
    }

    void init(Polynomial polynomial) {
        ListPolynomial listPolynomial = (ListPolynomial)polynomial;
        this.content.addAll(listPolynomial.content);
        this.degree = listPolynomial.degree;
        this.sugar = listPolynomial.sugar;
    }

    void init(Expression expression) {
        Generic generic;
        Monomial monomial;
        int n;
        TreeMap<Monomial, Generic> treeMap = new TreeMap<Monomial, Generic>(this.ordering);
        int n2 = expression.size();
        for (n = 0; n < n2; ++n) {
            Generic generic2;
            Object object = expression.literal(n);
            JSCLInteger object2 = expression.coef(n);
            monomial = this.monomial((Literal)object);
            generic = this.coefficient(((Literal)(object = ((Literal)object).divide(monomial.literalValue()))).degree() > 0 ? object2.multiply(Expression.valueOf((Literal)object)) : object2);
            Generic generic3 = (Generic)treeMap.get(monomial);
            Generic generic4 = generic2 = generic3 == null ? generic : generic3.add(generic);
            if (generic2.signum() == 0) {
                treeMap.remove(monomial);
                continue;
            }
            treeMap.put(monomial, generic2);
        }
        n = 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            monomial = (Monomial)entry.getKey();
            generic = (Generic)entry.getValue();
            this.content.add(new Term(monomial, generic));
            n = Math.max(n, monomial.degree());
        }
        this.degree = ListPolynomial.degree(this);
        this.sugar = n;
    }

    void init(Generic generic) {
        if (generic instanceof Expression) {
            this.init((Expression)generic);
        } else {
            Generic generic2 = this.coefficient(generic);
            if (generic2.signum() != 0) {
                this.content.add(new Term(this.monomial(Literal.valueOf()), generic2));
            }
            this.degree = 0;
            this.sugar = 0;
        }
    }

    void init(Monomial monomial) {
        this.content.add(new Term(monomial, this.coefficient(JSCLInteger.valueOf(1L))));
        this.degree = monomial.degree();
        this.sugar = monomial.degree();
    }

    protected ListPolynomial newinstance(int n) {
        return new ListPolynomial(this.monomialFactory, this.coefFactory);
    }

    class ContentIterator
    implements ListIterator {
        final ListIterator iterator;
        final boolean direction;

        ContentIterator(boolean bl, Monomial monomial) {
            this.direction = bl;
            this.iterator = ListPolynomial.this.content.listIterator(ListPolynomial.this.indexOf(monomial, bl));
        }

        @Override
        public boolean hasNext() {
            return this.direction ? this.iterator.hasPrevious() : this.iterator.hasNext();
        }

        @Override
        public Object next() {
            return this.direction ? this.iterator.previous() : this.iterator.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.direction ? this.iterator.hasNext() : this.iterator.hasPrevious();
        }

        public Object previous() {
            return this.direction ? this.iterator.next() : this.iterator.previous();
        }

        @Override
        public int nextIndex() {
            return this.direction ? this.iterator.previousIndex() : this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.direction ? this.iterator.nextIndex() : this.iterator.previousIndex();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        public void set(Object object) {
            this.iterator.set(object);
        }

        public void add(Object object) {
            this.iterator.add(object);
        }
    }
}

