/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import jscl.math.NotDivisibleException;
import jscl.math.Variable;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Ordering;
import jscl.math.polynomial.SmallMonomial;

class BooleanMonomial
extends SmallMonomial {
    static final int log2n = 1;
    static final int log2p = 4;
    static final int nmask = 3;
    static final int pmask = 15;

    BooleanMonomial(Variable[] variableArray, Ordering ordering) {
        this((variableArray.length - 1 >> 4) + 1, variableArray, ordering);
    }

    BooleanMonomial(int n, Variable[] variableArray, Ordering ordering) {
        super(n, variableArray, ordering);
    }

    @Override
    public Monomial multiply(Monomial monomial) {
        Monomial monomial2 = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int n = i >> 4;
            int n2 = (i & 0xF) << 1;
            int n3 = this.element[n] >> n2 & 3;
            int n4 = monomial.element[n] >> n2 & 3;
            int n5 = n3 + n4;
            if (n5 > 3) {
                throw new ArithmeticException();
            }
            int n6 = n;
            monomial2.element[n6] = monomial2.element[n6] | n5 << n2;
            monomial2.degree += n5;
        }
        return monomial2;
    }

    @Override
    public boolean multiple(Monomial monomial, boolean bl) {
        boolean bl2 = true;
        for (int i = 0; i < this.unknown.length; ++i) {
            int n = i >> 4;
            int n2 = (i & 0xF) << 1;
            int n3 = this.element[n] >> n2 & 3;
            int n4 = monomial.element[n] >> n2 & 3;
            if (n3 < n4) {
                return false;
            }
            bl2 &= n3 == n4;
        }
        return bl ? !bl2 : true;
    }

    @Override
    public Monomial divide(Monomial monomial) throws ArithmeticException {
        Monomial monomial2 = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int n = i >> 4;
            int n2 = (i & 0xF) << 1;
            int n3 = this.element[n] >> n2 & 3;
            int n4 = monomial.element[n] >> n2 & 3;
            int n5 = n3 - n4;
            if (n5 < 0) {
                throw new NotDivisibleException();
            }
            int n6 = n;
            monomial2.element[n6] = monomial2.element[n6] | n5 << n2;
        }
        monomial2.degree = this.degree - monomial.degree;
        return monomial2;
    }

    @Override
    public Monomial gcd(Monomial monomial) {
        Monomial monomial2 = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int n = i >> 4;
            int n2 = (i & 0xF) << 1;
            int n3 = this.element[n] >> n2 & 3;
            int n4 = monomial.element[n] >> n2 & 3;
            int n5 = Math.min(n3, n4);
            int n6 = n;
            monomial2.element[n6] = monomial2.element[n6] | n5 << n2;
            monomial2.degree += n5;
        }
        return monomial2;
    }

    @Override
    public Monomial scm(Monomial monomial) {
        Monomial monomial2 = this.newinstance();
        for (int i = 0; i < this.unknown.length; ++i) {
            int n = i >> 4;
            int n2 = (i & 0xF) << 1;
            int n3 = this.element[n] >> n2 & 3;
            int n4 = monomial.element[n] >> n2 & 3;
            int n5 = Math.max(n3, n4);
            int n6 = n;
            monomial2.element[n6] = monomial2.element[n6] | n5 << n2;
            monomial2.degree += n5;
        }
        return monomial2;
    }

    @Override
    public int element(int n) {
        if (this.reverse()) {
            n = this.unknown.length - 1 - n;
        }
        int n2 = n >> 4;
        int n3 = (n & 0xF) << 1;
        return this.element[n2] >> n3 & 3;
    }

    @Override
    void put(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.reverse()) {
            n = this.unknown.length - 1 - n;
        }
        if ((n6 = (n5 = this.element[n4 = n >> 4] >> (n3 = (n & 0xF) << 1) & 3) + n2) > 3) {
            throw new ArithmeticException();
        }
        int n7 = n4;
        this.element[n7] = this.element[n7] | n6 << n3;
        this.degree += n6 - n5;
    }

    @Override
    protected Monomial newinstance() {
        return new BooleanMonomial(this.element.length, this.unknown, this.ordering);
    }
}

