/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import jscl.math.Generic;
import jscl.math.Rational;
import jscl.math.polynomial.ArrayPolynomialGeneric;
import jscl.math.polynomial.Monomial;

class ArrayPolynomialRational
extends ArrayPolynomialGeneric {
    Rational[] coef;

    ArrayPolynomialRational(Monomial monomial) {
        super(monomial, Rational.factory);
    }

    ArrayPolynomialRational(int n, Monomial monomial) {
        this(monomial);
        this.init(n);
    }

    @Override
    void init(int n) {
        this.monomial = new Monomial[n];
        this.coef = new Rational[n];
        this.size = n;
    }

    @Override
    void resize(int n) {
        int n2 = this.monomial.length;
        if (n < n2) {
            Monomial[] monomialArray = new Monomial[n];
            Rational[] rationalArray = new Rational[n];
            System.arraycopy(this.monomial, n2 - n, monomialArray, 0, n);
            System.arraycopy(this.coef, n2 - n, rationalArray, 0, n);
            this.monomial = monomialArray;
            this.coef = rationalArray;
            this.size = n;
        }
    }

    @Override
    protected Generic coefficient(Generic generic) {
        return this.coefFactory.valueof(generic);
    }

    @Override
    protected Generic getCoef(int n) {
        return this.coef[n];
    }

    @Override
    protected void setCoef(int n, Generic generic) {
        this.coef[n] = (Rational)generic;
    }

    @Override
    protected ArrayPolynomialGeneric newinstance(int n) {
        return new ArrayPolynomialRational(n, this.monomialFactory);
    }
}

