/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.polynomial.ArrayPolynomialGeneric;
import jscl.math.polynomial.ModularInteger;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;

class ArrayPolynomialModular
extends ArrayPolynomialGeneric {
    final int modulo;
    int[] coef;

    ArrayPolynomialModular(Monomial monomial, Generic generic) {
        super(monomial, generic);
        this.modulo = ((ModularInteger)generic).modulo();
    }

    ArrayPolynomialModular(int n, Monomial monomial, Generic generic) {
        this(monomial, generic);
        this.init(n);
    }

    @Override
    void init(int n) {
        this.monomial = new Monomial[n];
        this.coef = new int[n];
        this.size = n;
    }

    @Override
    void resize(int n) {
        int n2 = this.monomial.length;
        if (n < n2) {
            Monomial[] monomialArray = new Monomial[n];
            int[] nArray = new int[n];
            System.arraycopy(this.monomial, n2 - n, monomialArray, 0, n);
            System.arraycopy(this.coef, n2 - n, nArray, 0, n);
            this.monomial = monomialArray;
            this.coef = nArray;
            this.size = n;
        }
    }

    @Override
    public Polynomial subtract(Polynomial polynomial) {
        Monomial monomial;
        if (polynomial.signum() == 0) {
            return this;
        }
        ArrayPolynomialModular arrayPolynomialModular = (ArrayPolynomialModular)polynomial;
        ArrayPolynomialModular arrayPolynomialModular2 = (ArrayPolynomialModular)this.newinstance(this.size + arrayPolynomialModular.size);
        int n = arrayPolynomialModular2.size;
        int n2 = this.size;
        int n3 = arrayPolynomialModular.size;
        Monomial monomial2 = n2 > 0 ? this.monomial[--n2] : null;
        Monomial monomial3 = monomial = n3 > 0 ? arrayPolynomialModular.monomial[--n3] : null;
        while (monomial2 != null || monomial != null) {
            int n4;
            int n5;
            int n6 = monomial2 == null ? 1 : (n5 = monomial == null ? -1 : -this.ordering.compare(monomial2, monomial));
            if (n5 < 0) {
                n4 = this.coef[n2];
                arrayPolynomialModular2.monomial[--n] = monomial2;
                arrayPolynomialModular2.coef[n] = n4;
                monomial2 = n2 > 0 ? this.monomial[--n2] : null;
                continue;
            }
            if (n5 > 0) {
                n4 = (int)(((long)this.modulo - (long)arrayPolynomialModular.coef[n3]) % (long)this.modulo);
                arrayPolynomialModular2.monomial[--n] = monomial;
                arrayPolynomialModular2.coef[n] = n4;
                monomial = n3 > 0 ? arrayPolynomialModular.monomial[--n3] : null;
                continue;
            }
            n4 = (int)(((long)this.coef[n2] + (long)this.modulo - (long)arrayPolynomialModular.coef[n3]) % (long)this.modulo);
            if (n4 != 0) {
                arrayPolynomialModular2.monomial[--n] = monomial2;
                arrayPolynomialModular2.coef[n] = n4;
            }
            monomial2 = n2 > 0 ? this.monomial[--n2] : null;
            monomial = n3 > 0 ? arrayPolynomialModular.monomial[--n3] : null;
        }
        arrayPolynomialModular2.resize(arrayPolynomialModular2.size - n);
        arrayPolynomialModular2.degree = ArrayPolynomialModular.degree(arrayPolynomialModular2);
        arrayPolynomialModular2.sugar = Math.max(this.sugar, arrayPolynomialModular.sugar);
        return arrayPolynomialModular2;
    }

    @Override
    public Polynomial multiplyAndSubtract(Generic generic, Polynomial polynomial) {
        Monomial monomial;
        if (generic.signum() == 0) {
            return this;
        }
        int n = generic.integerValue().intValue();
        if (n == 1) {
            return this.subtract(polynomial);
        }
        ArrayPolynomialModular arrayPolynomialModular = (ArrayPolynomialModular)polynomial;
        ArrayPolynomialModular arrayPolynomialModular2 = (ArrayPolynomialModular)this.newinstance(this.size + arrayPolynomialModular.size);
        int n2 = arrayPolynomialModular2.size;
        int n3 = this.size;
        int n4 = arrayPolynomialModular.size;
        Monomial monomial2 = n3 > 0 ? this.monomial[--n3] : null;
        Monomial monomial3 = monomial = n4 > 0 ? arrayPolynomialModular.monomial[--n4] : null;
        while (monomial2 != null || monomial != null) {
            int n5;
            int n6;
            int n7 = monomial2 == null ? 1 : (n6 = monomial == null ? -1 : -this.ordering.compare(monomial2, monomial));
            if (n6 < 0) {
                n5 = this.coef[n3];
                arrayPolynomialModular2.monomial[--n2] = monomial2;
                arrayPolynomialModular2.coef[n2] = n5;
                monomial2 = n3 > 0 ? this.monomial[--n3] : null;
                continue;
            }
            if (n6 > 0) {
                n5 = (int)(((long)this.modulo - (long)arrayPolynomialModular.coef[n4] * (long)n % (long)this.modulo) % (long)this.modulo);
                arrayPolynomialModular2.monomial[--n2] = monomial;
                arrayPolynomialModular2.coef[n2] = n5;
                monomial = n4 > 0 ? arrayPolynomialModular.monomial[--n4] : null;
                continue;
            }
            n5 = (int)(((long)this.coef[n3] + (long)this.modulo - (long)arrayPolynomialModular.coef[n4] * (long)n % (long)this.modulo) % (long)this.modulo);
            if (n5 != 0) {
                arrayPolynomialModular2.monomial[--n2] = monomial2;
                arrayPolynomialModular2.coef[n2] = n5;
            }
            monomial2 = n3 > 0 ? this.monomial[--n3] : null;
            monomial = n4 > 0 ? arrayPolynomialModular.monomial[--n4] : null;
        }
        arrayPolynomialModular2.resize(arrayPolynomialModular2.size - n2);
        arrayPolynomialModular2.degree = ArrayPolynomialModular.degree(arrayPolynomialModular2);
        arrayPolynomialModular2.sugar = Math.max(this.sugar, arrayPolynomialModular.sugar);
        return arrayPolynomialModular2;
    }

    @Override
    public Polynomial multiplyAndSubtract(Monomial monomial, Generic generic, Polynomial polynomial) {
        Monomial monomial2;
        if (this.defined) {
            throw new UnsupportedOperationException();
        }
        if (generic.signum() == 0) {
            return this;
        }
        if (monomial.degree() == 0) {
            return this.multiplyAndSubtract(generic, polynomial);
        }
        int n = generic.integerValue().intValue();
        ArrayPolynomialModular arrayPolynomialModular = (ArrayPolynomialModular)polynomial;
        ArrayPolynomialModular arrayPolynomialModular2 = (ArrayPolynomialModular)this.newinstance(this.size + arrayPolynomialModular.size);
        int n2 = arrayPolynomialModular2.size;
        int n3 = this.size;
        int n4 = arrayPolynomialModular.size;
        Monomial monomial3 = n3 > 0 ? this.monomial[--n3] : null;
        Monomial monomial4 = monomial2 = n4 > 0 ? arrayPolynomialModular.monomial[--n4].multiply(monomial) : null;
        while (monomial3 != null || monomial2 != null) {
            int n5;
            int n6;
            int n7 = monomial3 == null ? 1 : (n6 = monomial2 == null ? -1 : -this.ordering.compare(monomial3, monomial2));
            if (n6 < 0) {
                n5 = this.coef[n3];
                arrayPolynomialModular2.monomial[--n2] = monomial3;
                arrayPolynomialModular2.coef[n2] = n5;
                monomial3 = n3 > 0 ? this.monomial[--n3] : null;
                continue;
            }
            if (n6 > 0) {
                n5 = (int)(((long)this.modulo - (long)arrayPolynomialModular.coef[n4] * (long)n % (long)this.modulo) % (long)this.modulo);
                arrayPolynomialModular2.monomial[--n2] = monomial2;
                arrayPolynomialModular2.coef[n2] = n5;
                monomial2 = n4 > 0 ? arrayPolynomialModular.monomial[--n4].multiply(monomial) : null;
                continue;
            }
            n5 = (int)(((long)this.coef[n3] + (long)this.modulo - (long)arrayPolynomialModular.coef[n4] * (long)n % (long)this.modulo) % (long)this.modulo);
            if (n5 != 0) {
                arrayPolynomialModular2.monomial[--n2] = monomial3;
                arrayPolynomialModular2.coef[n2] = n5;
            }
            monomial3 = n3 > 0 ? this.monomial[--n3] : null;
            monomial2 = n4 > 0 ? arrayPolynomialModular.monomial[--n4].multiply(monomial) : null;
        }
        arrayPolynomialModular2.resize(arrayPolynomialModular2.size - n2);
        arrayPolynomialModular2.degree = ArrayPolynomialModular.degree(arrayPolynomialModular2);
        arrayPolynomialModular2.sugar = Math.max(this.sugar, arrayPolynomialModular.sugar + monomial.degree());
        return arrayPolynomialModular2;
    }

    @Override
    public Polynomial multiply(Generic generic) {
        if (generic.signum() == 0) {
            return this.valueof(JSCLInteger.valueOf(0L));
        }
        int n = generic.integerValue().intValue();
        if (n == 1) {
            return this;
        }
        ArrayPolynomialModular arrayPolynomialModular = (ArrayPolynomialModular)this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            arrayPolynomialModular.monomial[i] = this.monomial[i];
            arrayPolynomialModular.coef[i] = (int)((long)this.coef[i] * (long)n % (long)this.modulo);
        }
        arrayPolynomialModular.degree = this.degree;
        arrayPolynomialModular.sugar = this.sugar;
        return arrayPolynomialModular;
    }

    @Override
    public Polynomial multiply(Monomial monomial) {
        if (this.defined) {
            throw new UnsupportedOperationException();
        }
        if (monomial.degree() == 0) {
            return this;
        }
        ArrayPolynomialModular arrayPolynomialModular = (ArrayPolynomialModular)this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            arrayPolynomialModular.monomial[i] = this.monomial[i].multiply(monomial);
            arrayPolynomialModular.coef[i] = this.coef[i];
        }
        arrayPolynomialModular.degree = this.degree + monomial.degree();
        arrayPolynomialModular.sugar = this.sugar + monomial.degree();
        return arrayPolynomialModular;
    }

    @Override
    protected Generic coefficient(Generic generic) {
        return this.coefFactory.valueof(generic);
    }

    @Override
    protected Generic getCoef(int n) {
        return new ModularInteger(this.coef[n], this.modulo);
    }

    @Override
    protected void setCoef(int n, Generic generic) {
        this.coef[n] = generic.integerValue().intValue();
    }

    @Override
    protected ArrayPolynomialGeneric newinstance(int n) {
        return new ArrayPolynomialModular(n, this.monomialFactory, this.coefFactory);
    }
}

