/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.Literal;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.Term;

class ArrayPolynomialGeneric
extends Polynomial {
    Generic[] coef;
    Monomial[] monomial;
    int size;
    int degree;

    ArrayPolynomialGeneric(Monomial monomial, Generic generic) {
        super(monomial, generic);
    }

    ArrayPolynomialGeneric(int n, Monomial monomial, Generic generic) {
        this(monomial, generic);
        this.init(n);
    }

    @Override
    public int size() {
        return this.size;
    }

    void init(int n) {
        this.monomial = new Monomial[n];
        this.coef = new Generic[n];
        this.size = n;
    }

    void resize(int n) {
        int n2 = this.monomial.length;
        if (n < n2) {
            Monomial[] monomialArray = new Monomial[n];
            Generic[] genericArray = new Generic[n];
            System.arraycopy(this.monomial, n2 - n, monomialArray, 0, n);
            System.arraycopy(this.coef, n2 - n, genericArray, 0, n);
            this.monomial = monomialArray;
            this.coef = genericArray;
            this.size = n;
        }
    }

    @Override
    public Iterator iterator(boolean bl, Monomial monomial) {
        return new ContentIterator(bl, monomial);
    }

    Term term(final int n) {
        return new Term(this.monomial[n], null){

            @Override
            public Generic coef() {
                return this.coef == null ? ArrayPolynomialGeneric.this.getCoef(n) : this.coef;
            }
        };
    }

    int indexOf(Monomial monomial, boolean bl) {
        if (monomial == null) {
            return bl ? this.size : 0;
        }
        int n = Arrays.binarySearch(this.monomial, monomial, this.ordering);
        return n < 0 ? -n - 1 : (bl ? n : n + 1);
    }

    @Override
    public Polynomial subtract(Polynomial polynomial) {
        Monomial monomial;
        if (polynomial.signum() == 0) {
            return this;
        }
        ArrayPolynomialGeneric arrayPolynomialGeneric = (ArrayPolynomialGeneric)polynomial;
        ArrayPolynomialGeneric arrayPolynomialGeneric2 = this.newinstance(this.size + arrayPolynomialGeneric.size);
        int n = arrayPolynomialGeneric2.size;
        int n2 = this.size;
        int n3 = arrayPolynomialGeneric.size;
        Monomial monomial2 = n2 > 0 ? this.monomial[--n2] : null;
        Monomial monomial3 = monomial = n3 > 0 ? arrayPolynomialGeneric.monomial[--n3] : null;
        while (monomial2 != null || monomial != null) {
            Generic generic;
            int n4;
            int n5 = monomial2 == null ? 1 : (n4 = monomial == null ? -1 : -this.ordering.compare(monomial2, monomial));
            if (n4 < 0) {
                generic = this.getCoef(n2);
                arrayPolynomialGeneric2.monomial[--n] = monomial2;
                arrayPolynomialGeneric2.setCoef(n, generic);
                monomial2 = n2 > 0 ? this.monomial[--n2] : null;
                continue;
            }
            if (n4 > 0) {
                generic = arrayPolynomialGeneric.getCoef(n3).negate();
                arrayPolynomialGeneric2.monomial[--n] = monomial;
                arrayPolynomialGeneric2.setCoef(n, generic);
                monomial = n3 > 0 ? arrayPolynomialGeneric.monomial[--n3] : null;
                continue;
            }
            generic = this.getCoef(n2).subtract(arrayPolynomialGeneric.getCoef(n3));
            if (generic.signum() != 0) {
                arrayPolynomialGeneric2.monomial[--n] = monomial2;
                arrayPolynomialGeneric2.setCoef(n, generic);
            }
            monomial2 = n2 > 0 ? this.monomial[--n2] : null;
            monomial = n3 > 0 ? arrayPolynomialGeneric.monomial[--n3] : null;
        }
        arrayPolynomialGeneric2.resize(arrayPolynomialGeneric2.size - n);
        arrayPolynomialGeneric2.degree = ArrayPolynomialGeneric.degree(arrayPolynomialGeneric2);
        arrayPolynomialGeneric2.sugar = Math.max(this.sugar, arrayPolynomialGeneric.sugar);
        return arrayPolynomialGeneric2;
    }

    @Override
    public Polynomial multiplyAndSubtract(Generic generic, Polynomial polynomial) {
        Monomial monomial;
        if (generic.signum() == 0) {
            return this;
        }
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this.subtract(polynomial);
        }
        ArrayPolynomialGeneric arrayPolynomialGeneric = (ArrayPolynomialGeneric)polynomial;
        ArrayPolynomialGeneric arrayPolynomialGeneric2 = this.newinstance(this.size + arrayPolynomialGeneric.size);
        int n = arrayPolynomialGeneric2.size;
        int n2 = this.size;
        int n3 = arrayPolynomialGeneric.size;
        Monomial monomial2 = n2 > 0 ? this.monomial[--n2] : null;
        Monomial monomial3 = monomial = n3 > 0 ? arrayPolynomialGeneric.monomial[--n3] : null;
        while (monomial2 != null || monomial != null) {
            Generic generic2;
            int n4;
            int n5 = monomial2 == null ? 1 : (n4 = monomial == null ? -1 : -this.ordering.compare(monomial2, monomial));
            if (n4 < 0) {
                generic2 = this.getCoef(n2);
                arrayPolynomialGeneric2.monomial[--n] = monomial2;
                arrayPolynomialGeneric2.setCoef(n, generic2);
                monomial2 = n2 > 0 ? this.monomial[--n2] : null;
                continue;
            }
            if (n4 > 0) {
                generic2 = arrayPolynomialGeneric.getCoef(n3).multiply(generic).negate();
                arrayPolynomialGeneric2.monomial[--n] = monomial;
                arrayPolynomialGeneric2.setCoef(n, generic2);
                monomial = n3 > 0 ? arrayPolynomialGeneric.monomial[--n3] : null;
                continue;
            }
            generic2 = this.getCoef(n2).subtract(arrayPolynomialGeneric.getCoef(n3).multiply(generic));
            if (generic2.signum() != 0) {
                arrayPolynomialGeneric2.monomial[--n] = monomial2;
                arrayPolynomialGeneric2.setCoef(n, generic2);
            }
            monomial2 = n2 > 0 ? this.monomial[--n2] : null;
            monomial = n3 > 0 ? arrayPolynomialGeneric.monomial[--n3] : null;
        }
        arrayPolynomialGeneric2.resize(arrayPolynomialGeneric2.size - n);
        arrayPolynomialGeneric2.degree = ArrayPolynomialGeneric.degree(arrayPolynomialGeneric2);
        arrayPolynomialGeneric2.sugar = Math.max(this.sugar, arrayPolynomialGeneric.sugar);
        return arrayPolynomialGeneric2;
    }

    @Override
    public Polynomial multiplyAndSubtract(Monomial monomial, Generic generic, Polynomial polynomial) {
        Monomial monomial2;
        if (this.defined) {
            throw new UnsupportedOperationException();
        }
        if (generic.signum() == 0) {
            return this;
        }
        if (monomial.degree() == 0) {
            return this.multiplyAndSubtract(generic, polynomial);
        }
        ArrayPolynomialGeneric arrayPolynomialGeneric = (ArrayPolynomialGeneric)polynomial;
        ArrayPolynomialGeneric arrayPolynomialGeneric2 = this.newinstance(this.size + arrayPolynomialGeneric.size);
        int n = arrayPolynomialGeneric2.size;
        int n2 = this.size;
        int n3 = arrayPolynomialGeneric.size;
        Monomial monomial3 = n2 > 0 ? this.monomial[--n2] : null;
        Monomial monomial4 = monomial2 = n3 > 0 ? arrayPolynomialGeneric.monomial[--n3].multiply(monomial) : null;
        while (monomial3 != null || monomial2 != null) {
            Generic generic2;
            int n4;
            int n5 = monomial3 == null ? 1 : (n4 = monomial2 == null ? -1 : -this.ordering.compare(monomial3, monomial2));
            if (n4 < 0) {
                generic2 = this.getCoef(n2);
                arrayPolynomialGeneric2.monomial[--n] = monomial3;
                arrayPolynomialGeneric2.setCoef(n, generic2);
                monomial3 = n2 > 0 ? this.monomial[--n2] : null;
                continue;
            }
            if (n4 > 0) {
                generic2 = arrayPolynomialGeneric.getCoef(n3).multiply(generic).negate();
                arrayPolynomialGeneric2.monomial[--n] = monomial2;
                arrayPolynomialGeneric2.setCoef(n, generic2);
                monomial2 = n3 > 0 ? arrayPolynomialGeneric.monomial[--n3].multiply(monomial) : null;
                continue;
            }
            generic2 = this.getCoef(n2).subtract(arrayPolynomialGeneric.getCoef(n3).multiply(generic));
            if (generic2.signum() != 0) {
                arrayPolynomialGeneric2.monomial[--n] = monomial3;
                arrayPolynomialGeneric2.setCoef(n, generic2);
            }
            monomial3 = n2 > 0 ? this.monomial[--n2] : null;
            monomial2 = n3 > 0 ? arrayPolynomialGeneric.monomial[--n3].multiply(monomial) : null;
        }
        arrayPolynomialGeneric2.resize(arrayPolynomialGeneric2.size - n);
        arrayPolynomialGeneric2.degree = ArrayPolynomialGeneric.degree(arrayPolynomialGeneric2);
        arrayPolynomialGeneric2.sugar = Math.max(this.sugar, arrayPolynomialGeneric.sugar + monomial.degree());
        return arrayPolynomialGeneric2;
    }

    @Override
    public Polynomial multiply(Polynomial polynomial) {
        Polynomial polynomial2 = this.newinstance(0);
        for (int i = 0; i < this.size; ++i) {
            polynomial2 = ((Polynomial)polynomial2).multiplyAndSubtract(this.monomial[i], this.getCoef(i).negate(), polynomial);
        }
        return polynomial2;
    }

    @Override
    public Polynomial multiply(Generic generic) {
        if (generic.signum() == 0) {
            return this.valueof(JSCLInteger.valueOf(0L));
        }
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this;
        }
        ArrayPolynomialGeneric arrayPolynomialGeneric = this.newinstance(this.size);
        System.arraycopy(this.monomial, 0, arrayPolynomialGeneric.monomial, 0, this.size);
        for (int i = 0; i < this.size; ++i) {
            arrayPolynomialGeneric.setCoef(i, this.getCoef(i).multiply(generic));
        }
        arrayPolynomialGeneric.degree = this.degree;
        arrayPolynomialGeneric.sugar = this.sugar;
        return arrayPolynomialGeneric;
    }

    @Override
    public Polynomial multiply(Monomial monomial) {
        if (this.defined) {
            throw new UnsupportedOperationException();
        }
        if (monomial.degree() == 0) {
            return this;
        }
        ArrayPolynomialGeneric arrayPolynomialGeneric = this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            arrayPolynomialGeneric.monomial[i] = this.monomial[i].multiply(monomial);
            arrayPolynomialGeneric.setCoef(i, this.getCoef(i));
        }
        arrayPolynomialGeneric.degree = this.degree + monomial.degree();
        arrayPolynomialGeneric.sugar = this.sugar + monomial.degree();
        return arrayPolynomialGeneric;
    }

    @Override
    public Polynomial divide(Generic generic) throws ArithmeticException {
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this;
        }
        ArrayPolynomialGeneric arrayPolynomialGeneric = this.newinstance(this.size);
        System.arraycopy(this.monomial, 0, arrayPolynomialGeneric.monomial, 0, this.size);
        for (int i = 0; i < this.size; ++i) {
            arrayPolynomialGeneric.setCoef(i, this.getCoef(i).divide(generic));
        }
        arrayPolynomialGeneric.degree = this.degree;
        arrayPolynomialGeneric.sugar = this.sugar;
        return arrayPolynomialGeneric;
    }

    @Override
    public Polynomial divide(Monomial monomial) throws ArithmeticException {
        if (monomial.degree() == 0) {
            return this;
        }
        ArrayPolynomialGeneric arrayPolynomialGeneric = this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            arrayPolynomialGeneric.monomial[i] = this.monomial[i].divide(monomial);
            arrayPolynomialGeneric.setCoef(i, this.getCoef(i));
        }
        arrayPolynomialGeneric.degree = this.degree - monomial.degree();
        arrayPolynomialGeneric.sugar = this.sugar - monomial.degree();
        return arrayPolynomialGeneric;
    }

    @Override
    public Polynomial gcd(Polynomial polynomial) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic gcd() {
        if (this.field) {
            return this.coefficient(this.tail());
        }
        Generic generic = this.coefficient(JSCLInteger.valueOf(0L));
        for (int i = this.size - 1; i >= 0; --i) {
            generic = generic.gcd(this.getCoef(i));
        }
        return generic.signum() == this.signum() ? generic : generic.negate();
    }

    @Override
    public Monomial monomialGcd() {
        Monomial monomial = this.monomial(this.tail());
        for (int i = 0; i < this.size; ++i) {
            monomial = monomial.gcd(this.monomial[i]);
        }
        return monomial;
    }

    @Override
    public int degree() {
        return this.degree;
    }

    @Override
    public Polynomial valueof(Polynomial polynomial) {
        ArrayPolynomialGeneric arrayPolynomialGeneric = this.newinstance(0);
        arrayPolynomialGeneric.init(polynomial);
        return arrayPolynomialGeneric;
    }

    @Override
    public Polynomial valueof(Generic generic) {
        ArrayPolynomialGeneric arrayPolynomialGeneric = this.newinstance(0);
        arrayPolynomialGeneric.init(generic);
        return arrayPolynomialGeneric;
    }

    @Override
    public Polynomial valueof(Monomial monomial) {
        ArrayPolynomialGeneric arrayPolynomialGeneric = this.newinstance(0);
        arrayPolynomialGeneric.init(monomial);
        return arrayPolynomialGeneric;
    }

    @Override
    public Polynomial freeze() {
        return this;
    }

    @Override
    public Term head() {
        return this.size > 0 ? this.term(this.size - 1) : null;
    }

    @Override
    public Term tail() {
        return this.size > 0 ? this.term(0) : null;
    }

    protected Generic getCoef(int n) {
        return this.coef[n];
    }

    protected void setCoef(int n, Generic generic) {
        this.coef[n] = generic;
    }

    @Override
    public Generic genericValue() {
        Generic generic = JSCLInteger.valueOf(0L);
        for (int i = 0; i < this.size; ++i) {
            Monomial monomial = this.monomial[i];
            Expression expression = this.getCoef(i).expressionValue();
            generic = ((Generic)generic).add(monomial.degree() > 0 ? ((Generic)expression).multiply(Expression.valueOf(monomial.literalValue())) : expression);
        }
        return generic;
    }

    @Override
    public Generic[] elements() {
        Generic[] genericArray = new Generic[this.size];
        for (int i = 0; i < this.size; ++i) {
            genericArray[i] = this.getCoef(i);
        }
        return genericArray;
    }

    @Override
    public int compareTo(Polynomial polynomial) {
        Monomial monomial;
        ArrayPolynomialGeneric arrayPolynomialGeneric = (ArrayPolynomialGeneric)polynomial;
        int n = this.size;
        int n2 = arrayPolynomialGeneric.size;
        Monomial monomial2 = n == 0 ? null : this.monomial[--n];
        Monomial monomial3 = monomial = n2 == 0 ? null : arrayPolynomialGeneric.monomial[--n2];
        while (monomial2 != null || monomial != null) {
            int n3;
            int n4 = monomial2 == null ? -1 : (n3 = monomial == null ? 1 : this.ordering.compare(monomial2, monomial));
            if (n3 < 0) {
                return -1;
            }
            if (n3 > 0) {
                return 1;
            }
            n3 = this.getCoef(n).compareTo(arrayPolynomialGeneric.getCoef(n2));
            if (n3 < 0) {
                return -1;
            }
            if (n3 > 0) {
                return 1;
            }
            monomial2 = n == 0 ? null : this.monomial[--n];
            monomial = n2 == 0 ? null : arrayPolynomialGeneric.monomial[--n2];
        }
        return 0;
    }

    void init(Polynomial polynomial) {
        ArrayPolynomialGeneric arrayPolynomialGeneric = (ArrayPolynomialGeneric)polynomial;
        this.init(arrayPolynomialGeneric.size);
        System.arraycopy(arrayPolynomialGeneric.monomial, 0, this.monomial, 0, this.size);
        for (int i = 0; i < this.size; ++i) {
            this.setCoef(i, arrayPolynomialGeneric.getCoef(i));
        }
        this.degree = arrayPolynomialGeneric.degree;
        this.sugar = arrayPolynomialGeneric.sugar;
    }

    void init(Expression expression) {
        Generic generic;
        Comparable comparable;
        Object object;
        Object object2;
        int n;
        TreeMap<Object, Comparable> treeMap = new TreeMap<Object, Comparable>(this.ordering);
        int n2 = expression.size();
        for (n = 0; n < n2; ++n) {
            Comparable comparable2;
            object2 = expression.literal(n);
            JSCLInteger jSCLInteger = expression.coef(n);
            object = this.monomial((Literal)object2);
            comparable = this.coefficient(((Literal)(object2 = ((Literal)object2).divide(((Monomial)object).literalValue()))).degree() > 0 ? jSCLInteger.multiply(Expression.valueOf((Literal)object2)) : jSCLInteger);
            generic = (Generic)treeMap.get(object);
            Comparable comparable3 = comparable2 = generic == null ? comparable : generic.add((Generic)comparable);
            if (((Generic)comparable2).signum() == 0) {
                treeMap.remove(object);
                continue;
            }
            treeMap.put(object, comparable2);
        }
        this.init(treeMap.size());
        n = 0;
        object2 = treeMap.entrySet().iterator();
        for (int i = 0; i < this.size; ++i) {
            object = (Map.Entry)object2.next();
            comparable = (Monomial)object.getKey();
            generic = (Generic)object.getValue();
            this.monomial[i] = comparable;
            this.setCoef(i, generic);
            n = Math.max(n, ((Monomial)comparable).degree());
        }
        this.degree = ArrayPolynomialGeneric.degree(this);
        this.sugar = n;
    }

    void init(Generic generic) {
        if (generic instanceof Expression) {
            this.init((Expression)generic);
        } else {
            Generic generic2 = this.coefficient(generic);
            if (generic2.signum() != 0) {
                this.init(1);
                this.monomial[0] = this.monomial(Literal.valueOf());
                this.setCoef(0, generic2);
            } else {
                this.init(0);
            }
            this.degree = 0;
            this.sugar = 0;
        }
    }

    void init(Monomial monomial) {
        this.init(1);
        this.monomial[0] = monomial;
        this.setCoef(0, this.coefficient(JSCLInteger.valueOf(1L)));
        this.degree = monomial.degree();
        this.sugar = monomial.degree();
    }

    protected ArrayPolynomialGeneric newinstance(int n) {
        return new ArrayPolynomialGeneric(n, this.monomialFactory, this.coefFactory);
    }

    class ContentIterator
    implements Iterator {
        final boolean direction;
        int index;

        ContentIterator(boolean bl, Monomial monomial) {
            this.direction = bl;
            this.index = ArrayPolynomialGeneric.this.indexOf(monomial, bl);
        }

        @Override
        public boolean hasNext() {
            return this.direction ? this.index > 0 : this.index < ArrayPolynomialGeneric.this.size;
        }

        public Object next() {
            return this.direction ? ArrayPolynomialGeneric.this.term(--this.index) : ArrayPolynomialGeneric.this.term(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

