/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.TreeMap;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.polynomial.ArrayPolynomialGeneric;
import jscl.math.polynomial.ArrayPolynomialModular;
import jscl.math.polynomial.JSCLBoolean;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;

class ArrayPolynomialBoolean
extends ArrayPolynomialModular {
    ArrayPolynomialBoolean(Monomial monomial) {
        super(monomial, JSCLBoolean.factory);
    }

    ArrayPolynomialBoolean(int n, Monomial monomial) {
        this(monomial);
        this.init(n);
    }

    @Override
    void init(int n) {
        this.monomial = new Monomial[n];
        this.size = n;
    }

    @Override
    void resize(int n) {
        int n2 = this.monomial.length;
        if (n < n2) {
            Monomial[] monomialArray = new Monomial[n];
            System.arraycopy(this.monomial, n2 - n, monomialArray, 0, n);
            this.monomial = monomialArray;
            this.size = n;
        }
    }

    @Override
    public Polynomial subtract(Polynomial polynomial) {
        Monomial monomial;
        if (polynomial.signum() == 0) {
            return this;
        }
        ArrayPolynomialBoolean arrayPolynomialBoolean = (ArrayPolynomialBoolean)polynomial;
        ArrayPolynomialBoolean arrayPolynomialBoolean2 = (ArrayPolynomialBoolean)this.newinstance(this.size + arrayPolynomialBoolean.size);
        int n = arrayPolynomialBoolean2.size;
        int n2 = this.size;
        int n3 = arrayPolynomialBoolean.size;
        Monomial monomial2 = n2 > 0 ? this.monomial[--n2] : null;
        Monomial monomial3 = monomial = n3 > 0 ? arrayPolynomialBoolean.monomial[--n3] : null;
        while (monomial2 != null || monomial != null) {
            int n4;
            int n5 = monomial2 == null ? 1 : (n4 = monomial == null ? -1 : -this.ordering.compare(monomial2, monomial));
            if (n4 < 0) {
                arrayPolynomialBoolean2.monomial[--n] = monomial2;
                monomial2 = n2 > 0 ? this.monomial[--n2] : null;
                continue;
            }
            if (n4 > 0) {
                arrayPolynomialBoolean2.monomial[--n] = monomial;
                monomial = n3 > 0 ? arrayPolynomialBoolean.monomial[--n3] : null;
                continue;
            }
            monomial2 = n2 > 0 ? this.monomial[--n2] : null;
            monomial = n3 > 0 ? arrayPolynomialBoolean.monomial[--n3] : null;
        }
        arrayPolynomialBoolean2.resize(arrayPolynomialBoolean2.size - n);
        arrayPolynomialBoolean2.degree = ArrayPolynomialBoolean.degree(arrayPolynomialBoolean2);
        arrayPolynomialBoolean2.sugar = Math.max(this.sugar, arrayPolynomialBoolean.sugar);
        return arrayPolynomialBoolean2;
    }

    @Override
    public Polynomial multiplyAndSubtract(Generic generic, Polynomial polynomial) {
        if (generic.signum() == 0) {
            return this;
        }
        return this.subtract(polynomial);
    }

    @Override
    public Polynomial multiplyAndSubtract(Monomial monomial, Generic generic, Polynomial polynomial) {
        if (generic.signum() == 0) {
            return this;
        }
        return this.multiplyAndSubtract(generic, polynomial.multiply(monomial));
    }

    @Override
    public Polynomial multiply(Generic generic) {
        if (generic.signum() == 0) {
            return this.valueof(JSCLInteger.valueOf(0L));
        }
        return this;
    }

    @Override
    public Polynomial multiply(Monomial monomial) {
        if (this.defined) {
            Object object;
            TreeMap treeMap = new TreeMap(this.ordering);
            for (int i = 0; i < this.size; ++i) {
                object = this.monomial[i].multiply(monomial);
                if (treeMap.containsKey(object)) {
                    treeMap.remove(object);
                    continue;
                }
                treeMap.put(object, null);
            }
            ArrayPolynomialBoolean arrayPolynomialBoolean = (ArrayPolynomialBoolean)this.newinstance(treeMap.size());
            object = treeMap.keySet().iterator();
            for (int i = 0; i < arrayPolynomialBoolean.size; ++i) {
                arrayPolynomialBoolean.monomial[i] = (Monomial)object.next();
            }
            arrayPolynomialBoolean.degree = ArrayPolynomialBoolean.degree(arrayPolynomialBoolean);
            arrayPolynomialBoolean.sugar = this.sugar + monomial.degree();
            return arrayPolynomialBoolean;
        }
        if (monomial.degree() == 0) {
            return this;
        }
        ArrayPolynomialBoolean arrayPolynomialBoolean = (ArrayPolynomialBoolean)this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            arrayPolynomialBoolean.monomial[i] = this.monomial[i].multiply(monomial);
        }
        arrayPolynomialBoolean.degree = this.degree + monomial.degree();
        arrayPolynomialBoolean.sugar = this.sugar + monomial.degree();
        return arrayPolynomialBoolean;
    }

    @Override
    protected Generic getCoef(int n) {
        return new JSCLBoolean(1L);
    }

    @Override
    protected void setCoef(int n, Generic generic) {
    }

    @Override
    protected ArrayPolynomialGeneric newinstance(int n) {
        return new ArrayPolynomialBoolean(n, this.monomialFactory);
    }
}

