/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.operator.vector;

import jscl.math.Generic;
import jscl.math.JSCLVector;
import jscl.math.NotVectorException;
import jscl.math.Variable;
import jscl.math.operator.VectorOperator;
import jscl.math.operator.product.GeometricProduct;

public class Del
extends VectorOperator {
    public Del(Generic generic, Generic generic2, Generic generic3) {
        super("del", new Generic[]{generic, generic2, generic3});
    }

    @Override
    public Generic compute() {
        Variable[] variableArray = Del.variables(this.parameter[1].vectorValue());
        int[] nArray = GeometricProduct.algebra(this.parameter[2]);
        try {
            JSCLVector jSCLVector = this.parameter[0].vectorValue();
            return jSCLVector.del(variableArray, nArray);
        }
        catch (NotVectorException notVectorException) {
            return this.expressionValue();
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 3;
        if (this.parameter[2].signum() == 0) {
            n = 2;
        }
        stringBuffer.append(this.name);
        stringBuffer.append("(");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.parameter[i]).append(i < n - 1 ? ", " : "");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public String toMathML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<apply>");
        stringBuffer.append(this.operator("nabla").toMathML());
        stringBuffer.append(this.parameter[0].toMathML());
        if (this.parameter[2].signum() != 0) {
            stringBuffer.append(this.parameter[2].toMathML());
        }
        stringBuffer.append("</apply>");
        return stringBuffer.toString();
    }

    @Override
    protected Variable newinstance() {
        return new Del(null, null, null);
    }
}

