/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.operator;

import jscl.math.Generic;
import jscl.math.Variable;
import jscl.math.operator.Operator;

public class Limit
extends Operator {
    public Limit(Generic generic, Generic generic2, Generic generic3, Generic generic4) {
        super("limit", new Generic[]{generic, generic2, generic3, generic4});
    }

    @Override
    public Generic compute() {
        return this.expressionValue();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 4;
        if (this.parameter[3].signum() == 0) {
            n = 3;
        }
        stringBuffer.append(this.name);
        stringBuffer.append("(");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.parameter[i]).append(i < n - 1 ? ", " : "");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public String toMathML() {
        int n = this.parameter[3].signum();
        Variable variable = this.parameter[1].variableValue();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<apply><limit/><lowlimit>");
        if (n == 0) {
            stringBuffer.append(this.parameter[2].toMathML());
        } else {
            stringBuffer.append("<msup>");
            stringBuffer.append(this.parameter[2].toMathML());
            stringBuffer.append("<mo>");
            stringBuffer.append(n < 0 ? "-" : "+");
            stringBuffer.append("</mo>");
            stringBuffer.append("</msup>");
        }
        stringBuffer.append("</lowlimit><bvar>");
        stringBuffer.append(variable.toMathML());
        stringBuffer.append("</bvar>");
        stringBuffer.append(this.parameter[0].toMathML());
        stringBuffer.append("</apply>");
        return stringBuffer.toString();
    }

    @Override
    protected Variable newinstance() {
        return new Limit(null, null, null, null);
    }
}

