/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.operator;

import jscl.math.Generic;
import jscl.math.NotIntegrableException;
import jscl.math.Variable;
import jscl.math.operator.Operator;

public class IndefiniteIntegral
extends Operator {
    public IndefiniteIntegral(Generic generic, Generic generic2) {
        super("integral", new Generic[]{generic, generic2});
    }

    @Override
    public Generic compute() {
        Variable variable = this.parameter[1].variableValue();
        try {
            return this.parameter[0].antiderivative(variable);
        }
        catch (NotIntegrableException notIntegrableException) {
            return this.expressionValue();
        }
    }

    @Override
    public String toMathML() {
        Variable variable = this.parameter[1].variableValue();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<apply><int/><bvar>");
        stringBuffer.append(variable.toMathML());
        stringBuffer.append("</bvar>");
        stringBuffer.append(this.parameter[0].toMathML());
        stringBuffer.append("</apply>");
        return stringBuffer.toString();
    }

    @Override
    protected Variable newinstance() {
        return new IndefiniteIntegral(null, null);
    }
}

